/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.smartKey.comm.req;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfWriteRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridiumx.smartKey.BSmartKeyDevice;
import com.tridiumx.smartKey.comm.BSmartKeyReceiver;
import com.tridiumx.smartKey.comm.rsp.BSmartKeyReadWriteResponse;
import com.tridiumx.smartKey.identify.BSmartKeyDeviceId;
import com.tridiumx.smartKey.identify.BSmartKeyReadKeystrokeParams;
import com.tridiumx.smartKey.identify.BSmartKeyWriteLineParams;
import com.tridiumx.smartKey.point.BSmartKeyProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSmartKeyWriteLineRequest
extends BDdfWriteRequest
implements BIDdfCustomRequest {
    @Generated
    public static final Type TYPE = Sys.loadType(BSmartKeyWriteLineRequest.class);
    public static final int NO_CHANGE = 0;
    public static final int BUZZER_OFF = 0;
    public static final int SMART_KEY_ON = 1;
    public static final int SMART_KEY_OFF = 2;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public byte[] toByteArray() {
        BSmartKeyDeviceId deviceId = (BSmartKeyDeviceId)this.getDeviceId();
        BSmartKeyWriteLineParams writeParams = (BSmartKeyWriteLineParams)this.getWriteParameters();
        int smartKeyId = deviceId.getSmartKeyId();
        int smartKeyLine = writeParams.getLineNumber();
        String textForLine = this.getNewTextForLine();
        if (textForLine.length() > deviceId.getMaxLineLength()) {
            textForLine = textForLine.substring(0, deviceId.getMaxLineLength());
        }
        if (textForLine.length() < deviceId.getMaxLineLength()) {
            textForLine = TextUtil.pad((String)textForLine, (int)deviceId.getMaxLineLength());
        }
        ByteBuffer xmitBytes = new ByteBuffer();
        xmitBytes.writeByte(1);
        xmitBytes.writeByte(51);
        xmitBytes.writeByte(smartKeyId);
        xmitBytes.writeByte(131);
        xmitBytes.writeByte(3 + (textForLine == null ? 0 : textForLine.length() * 2));
        xmitBytes.writeByte(smartKeyLine);
        xmitBytes.writeByte(0);
        if (writeParams.getInvert()) {
            xmitBytes.writeByte(3);
        } else {
            xmitBytes.writeByte(4);
        }
        if (textForLine != null) {
            xmitBytes.setBigEndian(true);
            for (int i = 0; i < textForLine.length(); ++i) {
                xmitBytes.writeChar(textForLine.charAt(i) & 0xFFFF);
            }
        }
        xmitBytes.writeByte(BSmartKeyReceiver.computeChecksum(xmitBytes.getBytes(), xmitBytes.getLength() + 2));
        xmitBytes.writeByte(4);
        byte[] xmit = xmitBytes.toByteArray();
        return xmit;
    }

    public BIDdfResponse processReceive(IDdfDataFrame receiveFrame) throws DdfResponseException {
        return new BSmartKeyReadWriteResponse(receiveFrame);
    }

    private String getNewTextForLine() {
        if (this.getWritableSource() != null && this.getWritableSource().length > 0) {
            IDdfWritable ddfWritable = this.getWritableSource()[0];
            BStatusValue writeValue = ddfWritable.getWriteValue();
            return writeValue.valueToString((Context)ddfWritable.getFacets());
        }
        return null;
    }

    public void processErrorResponse(DdfResponseException errorRsp) {
    }

    public void processLateResponse(BIDdfResponse ddfRsp) {
    }

    public void processResponse(BIDdfResponse ddfRsp) {
        BSmartKeyReadWriteResponse smartKeyRsp = (BSmartKeyReadWriteResponse)ddfRsp;
        BSmartKeyProxyExt smartKeyProxy = (BSmartKeyProxyExt)this.getWritableSource()[0];
        BSmartKeyDevice d = (BSmartKeyDevice)smartKeyProxy.getDdfDevice();
        BControlPoint[] cps = d.getPoints().getPoints();
        for (int i = 0; i < cps.length; ++i) {
            BSmartKeyProxyExt proxyI = (BSmartKeyProxyExt)cps[i].getProxyExt();
            if (!(proxyI.getReadParameters() instanceof BSmartKeyReadKeystrokeParams)) continue;
            proxyI.readOk(smartKeyRsp.parseReadValue((IDdfReadable)proxyI));
        }
    }

    public void processTimeout() {
    }
}

