/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.smartKey.comm.rsp;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.util.EscUtil;
import com.tridiumx.smartKey.SmartKeyLexicon;
import com.tridiumx.smartKey.discover.BSmartKeyPointDiscoveryLeaf;
import com.tridiumx.smartKey.enums.BSmartKeyMonitorModeEnum;
import com.tridiumx.smartKey.identify.BSmartKeyDeviceId;
import com.tridiumx.smartKey.identify.BSmartKeystrokesPointId;
import com.tridiumx.smartKey.point.BSmartKeyProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BStringPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSmartKeyReadWriteResponse
extends BDdfResponse
implements BIDdfReadResponse {
    @Generated
    public static final Type TYPE = Sys.loadType(BSmartKeyReadWriteResponse.class);
    private byte[] receiveBytes;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSmartKeyReadWriteResponse(IDdfDataFrame receiveFrame) throws DdfResponseException {
        this.receiveBytes = new byte[receiveFrame.getFrameSize()];
        System.arraycopy(receiveFrame.getFrameBytes(), 0, this.receiveBytes, 0, this.receiveBytes.length);
    }

    public BSmartKeyReadWriteResponse() {
    }

    public BStatusValue parseReadValue(IDdfReadable readableSource) {
        if (readableSource instanceof BSmartKeyProxyExt) {
            BSmartKeyProxyExt proxy = (BSmartKeyProxyExt)readableSource;
            return this.getReadValue(proxy);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseKeystroke(BSmartKeyProxyExt proxy, BSmartKeystrokesPointId pointId) {
        int keyEnterCode = this.receiveBytes[7] & 0xFF;
        BEnumRange keyMapping = (BEnumRange)proxy.getPointFacets().get("range", (BObject)BSmartKeyPointDiscoveryLeaf.DEFAULT_KEY_MAPPING);
        String origProxyKeyBuf = pointId.getKeyStrokeBuffer();
        String newProxyKeyBuf = "";
        String sNewKey = keyEnterCode == 255 || !keyMapping.isOrdinal(keyEnterCode) ? "" : EscUtil.slot.unescape(keyMapping.getTag(keyEnterCode));
        String wordDelimiter = ((BSmartKeyDeviceId)this.getDeviceId()).getWordDelimiter();
        String clearIndicator = ((BSmartKeyDeviceId)this.getDeviceId()).getClearIndicator();
        newProxyKeyBuf = pointId.getKeystrokeMode() == BSmartKeyMonitorModeEnum.dataEntered || pointId.getKeystrokeMode() == BSmartKeyMonitorModeEnum.dataEnteredCumulative ? (origProxyKeyBuf.endsWith(wordDelimiter) && sNewKey.length() > 0 ? sNewKey : origProxyKeyBuf + sNewKey) : origProxyKeyBuf + sNewKey;
        try {
            if (pointId.getKeystrokeMode() == BSmartKeyMonitorModeEnum.dataEntered) {
                if (newProxyKeyBuf.endsWith(wordDelimiter)) {
                    String string = newProxyKeyBuf.substring(0, newProxyKeyBuf.length() - wordDelimiter.length());
                    return string;
                }
                String string = "";
                return string;
            }
            if (pointId.getKeystrokeMode() == BSmartKeyMonitorModeEnum.dataEnteredCumulative) {
                if (newProxyKeyBuf.endsWith(wordDelimiter)) {
                    String string = newProxyKeyBuf.substring(0, newProxyKeyBuf.length() - wordDelimiter.length());
                    return string;
                }
                String string = newProxyKeyBuf;
                return string;
            }
            String string = sNewKey;
            return string;
        }
        finally {
            if (newProxyKeyBuf.endsWith(clearIndicator)) {
                pointId.setKeyStrokeBuffer("");
            } else {
                pointId.setKeyStrokeBuffer(newProxyKeyBuf);
            }
        }
    }

    private BStatusValue getReadValue(BSmartKeyProxyExt proxy) {
        String sRawValue = null;
        if (!(proxy.getPointId() instanceof BSmartKeystrokesPointId)) {
            return proxy.getReadValue();
        }
        BSmartKeystrokesPointId keystrokesPointId = (BSmartKeystrokesPointId)proxy.getPointId();
        sRawValue = this.parseKeystroke(proxy, keystrokesPointId);
        BControlPoint controlPoint = proxy.getParentPoint();
        if (controlPoint instanceof BINumeric) {
            if (sRawValue.length() > 0) {
                try {
                    return new BStatusNumeric(Double.parseDouble(sRawValue));
                }
                catch (NumberFormatException nfe) {
                    return new BStatusNumeric((double)Long.parseLong(sRawValue));
                }
            }
            return new BStatusNumeric(0.0, BStatus.nullStatus);
        }
        if (controlPoint instanceof BIBoolean) {
            String trueText = proxy.getPointFacets().gets("trueText", null);
            if (trueText == null) {
                throw new BajaRuntimeException(SmartKeyLexicon.makeBooleanDataPointMustDefineTrueText(proxy));
            }
            return new BStatusBoolean(sRawValue.trim().equals(trueText));
        }
        if (controlPoint instanceof BIEnum) {
            BStatusEnum e = ((BEnumPoint)controlPoint).getOut();
            try {
                int ordinal = (int)Math.round(Double.parseDouble(sRawValue));
                return new BStatusEnum((BEnum)BDynamicEnum.make((int)ordinal, (BEnumRange)e.getValue().getRange()));
            }
            catch (NumberFormatException nfe) {
                int ordinal = Math.round(Long.parseLong(sRawValue));
                return new BStatusEnum((BEnum)BDynamicEnum.make((int)ordinal, (BEnumRange)e.getValue().getRange()));
            }
        }
        if (controlPoint instanceof BStringPoint) {
            return new BStatusString(sRawValue);
        }
        throw new IllegalStateException("Unsupported control point type: " + controlPoint.getType() + "! Please have my program fixed.");
    }
}

