/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oauth2;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderConfigurationRequest;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.tridium.json.JSONObject;
import com.tridium.oauth2.OAuth2AuthorizationServerConfigurationException;
import com.tridium.oauth2.OAuth2AuthorizationServerMetadata;
import java.io.IOException;
import java.net.URL;

public class OAuth2AuthorizationServerMetadataResolver {
    public OAuth2AuthorizationServerMetadata resolve(URL authServerMetadataEndpoint) throws OAuth2AuthorizationServerConfigurationException {
        OAuth2AuthorizationServerMetadata resolvedMetadata;
        try {
            Issuer issuer = new Issuer(authServerMetadataEndpoint.toExternalForm());
            HTTPRequest providerConfigRequest = new OIDCProviderConfigurationRequest(issuer).toHTTPRequest();
            HTTPResponse configResponse = providerConfigRequest.send();
            OIDCProviderMetadata providerMetadata = OIDCProviderMetadata.parse(configResponse.getBodyAsJSONObject());
            if (providerMetadata.getTokenEndpointURI() == null) {
                throw new OAuth2AuthorizationServerConfigurationException("Unable to obtain Token endpoint from OAuth 2.0 Authorization Server Metadata");
            }
            JSONObject metadataJSON = new JSONObject(configResponse.getBody());
            resolvedMetadata = new OAuth2AuthorizationServerMetadata(metadataJSON);
        }
        catch (ParseException | IOException e) {
            throw new OAuth2AuthorizationServerConfigurationException("Unable to obtain OAuth 2.0 Authorization Server Metadata from URI", e);
        }
        return resolvedMetadata;
    }
}

