/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.nav;

import com.tridium.history.nav.BFilteredHistorySpace;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.history.BHistorySpace;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BFilteredHistoryNavNode
extends BObject
implements BINavNode,
BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BFilteredHistoryNavNode.class);
    BINavNode historyNavNode;
    IFilter deviceFilter;
    IFilter historyFilter;
    IFilter folderFilter;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static final BFilteredHistoryNavNode make(BObject obj, IFilter deviceFilter, IFilter historyFilter, IFilter folderFilter) {
        AgentList agents = obj.getAgents().filter(AgentFilter.is((Type)TYPE));
        if (obj instanceof BINavNode && agents.size() != 0) {
            BFilteredHistoryNavNode fhnn = (BFilteredHistoryNavNode)agents.getDefault().getInstance();
            fhnn.setHistoryNavNode((BINavNode)obj);
            fhnn.setDeviceFilter(deviceFilter);
            fhnn.setHistoryFilter(historyFilter);
            fhnn.setFolderFilter(folderFilter);
            return fhnn;
        }
        try {
            BHistorySpace space = (BHistorySpace)BOrd.make((String)"history:").get(obj);
            return new BFilteredHistorySpace(space);
        }
        catch (Exception e) {
            System.out.println("Cannot resolve history space.");
            e.printStackTrace();
            return null;
        }
    }

    public BINavNode getHistoryNavNode() {
        return this.historyNavNode;
    }

    public void setHistoryNavNode(BINavNode node) {
        this.historyNavNode = node;
    }

    public IFilter getDeviceFilter() {
        return this.deviceFilter;
    }

    public void setDeviceFilter(IFilter filter) {
        this.deviceFilter = filter;
    }

    public IFilter getHistoryFilter() {
        return this.historyFilter;
    }

    public void setHistoryFilter(IFilter filter) {
        this.historyFilter = filter;
    }

    public IFilter getFolderFilter() {
        return this.folderFilter;
    }

    public void setFolderFilter(IFilter filter) {
        this.folderFilter = filter;
    }

    public String getNavName() {
        return this.historyNavNode.getNavName();
    }

    public String getNavDisplayName(Context cx) {
        return this.historyNavNode.getNavDisplayName(cx);
    }

    public String getNavDescription(Context cx) {
        return this.historyNavNode.getNavDescription(cx);
    }

    public BINavNode getNavParent() {
        return this.historyNavNode.getNavParent();
    }

    public boolean hasNavChildren() {
        return this.historyNavNode.hasNavChildren();
    }

    public BOrd getNavOrd() {
        return this.historyNavNode.getNavOrd();
    }

    public BIcon getNavIcon() {
        return this.historyNavNode.getNavIcon();
    }

    public BINavNode getNavChild(String name) {
        return this.historyNavNode.getNavChild(name);
    }

    public BINavNode resolveNavChild(String name) {
        return this.historyNavNode.resolveNavChild(name);
    }

    public BINavNode[] getNavChildren() {
        return this.historyNavNode.getNavChildren();
    }
}

