/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.pdf.BAbstractHistoryChartToPdf;
import com.tridium.history.pdf.BHistoryToTablePdf;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.history.ui.HistoryUiUtil;
import javax.baja.file.BExporter;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"history:IHistory", "history:HistoryExt"})})
@NiagaraProperties(value={@NiagaraProperty(name="timeRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.DEFAULT"), @NiagaraProperty(name="delta", type="boolean", defaultValue="false")})
public class BHistoryToChartPdf
extends BAbstractHistoryChartToPdf {
    @Generated
    public static final Property timeRange = BHistoryToChartPdf.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    @Generated
    public static final Property delta = BHistoryToChartPdf.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryToChartPdf.class);

    @Generated
    public BDynamicTimeRange getTimeRange() {
        return (BDynamicTimeRange)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BDynamicTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Generated
    public boolean getDelta() {
        return this.getBoolean(delta);
    }

    @Generated
    public void setDelta(boolean v) {
        this.setBoolean(delta, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BHistoryChart getHistoryChart(PdfOp op) {
        BObject o = op.get();
        BIHistory history = null;
        if (o instanceof BIHistory) {
            history = (BIHistory)o;
        } else if (o instanceof BHistoryExt) {
            BHistoryExt ext = (BHistoryExt)o;
            ext.lease(1);
            BHistoryConfig cfg = ext.getHistoryConfig();
            BHistoryId id = cfg.getId();
            BOrd base = ext.getAbsoluteOrd();
            BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
            history = (BIHistory)ord.resolve().get();
        }
        if (history == null) {
            return null;
        }
        BHistoryChart chart = new BHistoryChart();
        chart.setDefaultTimeRange(this.getTimeRange());
        chart.setDefaultDelta(this.getDelta() && history.getRecordType().getResolvedType().is(BNumericTrendRecord.TYPE));
        chart.loadValue((BObject)history, HistoryUiUtil.makeSyncLoadFacets((Context)op));
        return chart;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 407) {
            BHistoryToTablePdf.updateExportSettingsForCurrentHistoryInView((BExporter)a, (OrdTarget)b, (BWbView)c, timeRange, delta);
        }
        return super.fw(x, a, b, c, d);
    }
}

