/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.pdf.BAbstractHistoryTableToPdf;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.history.ui.BHistoryTable;
import com.tridium.history.ui.HistoryUiUtil;
import com.tridium.pdf.PdfUtil;
import com.tridium.workbench.web.browser.BWebWidget;
import java.util.logging.Level;
import javax.baja.file.BExporter;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"history:IHistory", "history:HistoryExt"})})
@NiagaraProperties(value={@NiagaraProperty(name="timeRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.DEFAULT"), @NiagaraProperty(name="delta", type="boolean", defaultValue="false")})
public class BHistoryToTablePdf
extends BAbstractHistoryTableToPdf {
    @Generated
    public static final Property timeRange = BHistoryToTablePdf.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    @Generated
    public static final Property delta = BHistoryToTablePdf.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryToTablePdf.class);

    @Generated
    public BDynamicTimeRange getTimeRange() {
        return (BDynamicTimeRange)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BDynamicTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Generated
    public boolean getDelta() {
        return this.getBoolean(delta);
    }

    @Generated
    public void setDelta(boolean v) {
        this.setBoolean(delta, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BHistoryTable getHistoryTable(PdfOp op) {
        BObject o = op.get();
        BIHistory history = null;
        if (o instanceof BIHistory) {
            history = (BIHistory)o;
        } else if (o instanceof BHistoryExt) {
            BHistoryExt ext = (BHistoryExt)o;
            ext.lease(1);
            BHistoryConfig cfg = ext.getHistoryConfig();
            BHistoryId id = cfg.getId();
            BOrd base = ext.getAbsoluteOrd();
            BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
            history = (BIHistory)ord.resolve().get();
        }
        if (history == null) {
            return null;
        }
        BHistoryTable table = new BHistoryTable();
        table.setDefaultTimeRange(this.getTimeRange());
        table.setDefaultDelta(this.getDelta() && history.getRecordType().getResolvedType().is(BNumericTrendRecord.TYPE));
        table.loadValue((BObject)history, HistoryUiUtil.makeSyncLoadFacets((Context)op));
        return table;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 407) {
            BExporter exporter = (BExporter)a;
            BHistoryToTablePdf.updateExportSettingsForCurrentHistoryInView(exporter, (OrdTarget)b, (BWbView)c, exporter.getProperty("timeRange"), exporter.getProperty("delta"));
        }
        return super.fw(x, a, b, c, d);
    }

    static void updateExportSettingsForCurrentHistoryInView(BExporter historyExporter, OrdTarget target, BWbView currentView, Property timeRangeProperty, Property deltaProperty) {
        BIHistory historyBeingExported = null;
        BObject exportTarget = target.get();
        if (exportTarget instanceof BIHistory) {
            historyBeingExported = (BIHistory)exportTarget;
        } else if (exportTarget instanceof BHistoryExt) {
            BHistoryExt ext = (BHistoryExt)exportTarget;
            try {
                ext.lease(1);
                BOrd ord = BOrd.make((BOrd)ext.getAbsoluteOrd(), (String)("history:" + ext.getHistoryConfig().getId()));
                historyBeingExported = (BIHistory)ord.get(null, (Context)target);
            }
            catch (Exception e) {
                PdfUtil.log.log(Level.WARNING, "During export, could not resolve history for " + ext.toPathString(), PdfUtil.log.isLoggable(Level.FINE) ? e : null);
            }
        }
        if (historyBeingExported == null) {
            return;
        }
        boolean isNumericHistory = historyBeingExported.getRecordType().getResolvedType().is(BNumericTrendRecord.TYPE);
        if (isNumericHistory) {
            historyExporter.setFlags((Slot)deltaProperty, historyExporter.getFlags((Slot)deltaProperty) & 0xFFFFFFFB);
        } else {
            historyExporter.setFlags((Slot)deltaProperty, historyExporter.getFlags((Slot)deltaProperty) | 4);
        }
        if (currentView == null) {
            return;
        }
        BIHistory historyInCurrentView = null;
        BDynamicTimeRange currentTimeRange = BDynamicTimeRange.DEFAULT;
        boolean currentDelta = false;
        if (currentView instanceof BHistoryTable) {
            BHistoryTable table = (BHistoryTable)currentView;
            historyInCurrentView = table.getHistory();
            currentDelta = table.isDelta();
            try {
                currentTimeRange = table.getRange();
            }
            catch (Exception e) {
                PdfUtil.log.log(Level.WARNING, "During export, could not read time range from current HistoryTable view", PdfUtil.log.isLoggable(Level.FINE) ? e : null);
            }
        } else if (currentView instanceof BHistoryChart) {
            BHistoryChart chart = (BHistoryChart)currentView;
            historyInCurrentView = chart.getHistory();
            currentDelta = chart.isDelta();
            try {
                currentTimeRange = chart.getRange();
            }
            catch (Exception e) {
                PdfUtil.log.log(Level.WARNING, "During export, could not read time range from current HistoryChart view", PdfUtil.log.isLoggable(Level.FINE) ? e : null);
            }
        } else if (currentView instanceof BWebWidget) {
            currentView.fw(407, (Object)historyExporter, (Object)target, (Object)currentView, null);
        }
        if (historyInCurrentView != null && historyInCurrentView.getId().equals((Object)historyBeingExported.getId())) {
            historyExporter.set(timeRangeProperty, (BValue)currentTimeRange);
            historyExporter.set(deltaProperty, (BValue)BBoolean.make((isNumericHistory && currentDelta ? 1 : 0) != 0));
        }
    }
}

