/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.history.ui.BHistoryChooser;
import javax.baja.history.BHistorySpace;
import javax.baja.history.HistoryException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"history:HistorySpace"})})
@NiagaraAction(name="updateCommands")
public class BHistoryDbMaintenance
extends BWbView {
    @Generated
    public static final Action updateCommands = BHistoryDbMaintenance.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryDbMaintenance.class);
    private static Lexicon lex = Lexicon.make((String)"history");
    private static int BATCH_SIZE = 5;
    private BHistoryChooser chooser;
    private ToggleCommand clearAllRecords;
    private ToggleCommand clearOldRecords;
    private ToggleCommand deleteHistories;
    private Command runMaintenance;
    private BWbEditor dateEditor;

    @Generated
    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryDbMaintenance() {
        BEdgePane main = new BEdgePane();
        this.chooser = new BHistoryChooser();
        main.setCenter((BWidget)new BBorderPane((BWidget)this.chooser, lex.getText("histories")));
        BGridPane options = new BGridPane(2);
        options.setHalign(BHalign.left);
        options.setValign(BValign.top);
        OptionGroup optionGroup = new OptionGroup();
        this.clearOldRecords = new ClearOldRecords();
        optionGroup.add(this.clearOldRecords);
        options.add("clearOld", (BValue)new BRadioButton(this.clearOldRecords));
        this.dateEditor = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
        BAbsTime now = Clock.time();
        BAbsTime beforeTime = BAbsTime.make((int)(now.getYear() - 5), (BMonth)now.getMonth(), (int)now.getDay());
        this.dateEditor.loadValue((BObject)beforeTime);
        BFlowPane datePane = new BFlowPane();
        datePane.add("before", (BValue)new BLabel(lex.getText("before")));
        datePane.add("dateEditor", (BValue)this.dateEditor);
        options.add("date", (BValue)new BBorderPane((BWidget)datePane, 0.0, 0.0, 0.0, 10.0));
        this.clearAllRecords = new ClearAllRecords();
        optionGroup.add(this.clearAllRecords);
        options.add("clearAll", (BValue)new BRadioButton(this.clearAllRecords));
        options.add(null, (BValue)new BLabel(""));
        this.deleteHistories = new DeleteHistories();
        optionGroup.add(this.deleteHistories);
        options.add("deleteHistories", (BValue)new BRadioButton(this.deleteHistories));
        options.add(null, (BValue)new BLabel(""));
        this.runMaintenance = new RunMaintenance();
        this.runMaintenance.setEnabled(false);
        BButton runButton = new BButton(this.runMaintenance);
        BGridPane actions = new BGridPane(1);
        actions.add("run", (BValue)runButton);
        BEdgePane mainBottom = new BEdgePane();
        mainBottom.setCenter((BWidget)new BBorderPane((BWidget)options));
        mainBottom.setBottom((BWidget)actions);
        main.setBottom((BWidget)mainBottom);
        this.add(null, (BValue)new BLink((BComponent)this.chooser, (Slot)BHistoryChooser.selectionModified, (Slot)updateCommands));
        this.setContent((BWidget)main);
    }

    public void doLoadValue(BObject o, Context context) {
        this.chooser.setHistorySpace((BHistorySpace)o);
    }

    public void runMaintenance() {
        try {
            int arrayLen;
            String msg;
            String title;
            if (this.chooser.getResultSize() == 0) {
                return;
            }
            BOrd[] selections = this.chooser.getResult();
            BAbsTime before = null;
            if (this.clearAllRecords.isSelected()) {
                title = lex.getText("confirmClear.title");
                if (BDialog.confirm((BWidget)this, (String)title, (Object)(msg = lex.getText("confirmClear"))) != 4) {
                    return;
                }
            } else if (this.clearOldRecords.isSelected()) {
                before = (BAbsTime)this.dateEditor.saveValue();
                title = lex.getText("confirmClear.title");
                if (BDialog.confirm((BWidget)this, (String)title, (Object)(msg = lex.getText("confirmClear.before", new Object[]{before.toString()}))) != 4) {
                    return;
                }
            } else if (this.deleteHistories.isSelected()) {
                title = lex.getText("confirmDelete.title");
                if (BDialog.confirm((BWidget)this, (String)title, (Object)(msg = lex.getText("confirmDelete"))) != 4) {
                    return;
                }
            } else {
                return;
            }
            int total = selections.length;
            int batches = total / BATCH_SIZE;
            if (total % BATCH_SIZE != 0) {
                ++batches;
            }
            String successTitle = null;
            int i = 0;
            for (int b = 0; b < batches && (arrayLen = Math.min(BATCH_SIZE, total - i)) > 0; ++b) {
                BOrd[] ords = new BOrd[arrayLen];
                for (int j = 0; j < arrayLen; ++j) {
                    ords[j] = selections[i + j];
                }
                i += arrayLen;
                try (HistorySpaceConnection conn = ((BHistorySpace)this.getCurrentValue()).getConnection(null);){
                    if (this.clearAllRecords.isSelected()) {
                        conn.clearAllRecords(ords);
                        successTitle = lex.getText("command.clearAllRecords.label");
                        continue;
                    }
                    if (this.clearOldRecords.isSelected()) {
                        conn.clearOldRecords(ords, before);
                        successTitle = lex.getText("command.clearOldRecords.label");
                        continue;
                    }
                    if (!this.deleteHistories.isSelected()) continue;
                    conn.deleteHistories(ords);
                    successTitle = lex.getText("command.deleteHistories.label");
                    continue;
                }
            }
            if (this.deleteHistories.isSelected()) {
                this.chooser.clear();
            }
            if (successTitle != null) {
                BDialog.info((BWidget)this, successTitle, (Object)lex.getText("maintenance.success"));
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HistoryException((Throwable)ex);
        }
    }

    public void doUpdateCommands() {
        this.runMaintenance.setEnabled(this.chooser.getResultSize() != 0);
    }

    private class RunMaintenance
    extends Command {
        public RunMaintenance() {
            super((BWidget)BHistoryDbMaintenance.this, Sys.getModuleForClass(BHistoryDbMaintenance.class), "command.runMaintenance");
        }

        public CommandArtifact doInvoke() {
            BHistoryDbMaintenance.this.runMaintenance();
            return null;
        }
    }

    private class DeleteHistories
    extends ToggleCommand {
        public DeleteHistories() {
            super((BWidget)BHistoryDbMaintenance.this, Sys.getModuleForClass(BHistoryDbMaintenance.class), "command.deleteHistories");
        }
    }

    private class ClearOldRecords
    extends ToggleCommand {
        public ClearOldRecords() {
            super((BWidget)BHistoryDbMaintenance.this, Sys.getModuleForClass(BHistoryDbMaintenance.class), "command.clearOldRecords");
        }
    }

    private class ClearAllRecords
    extends ToggleCommand {
        public ClearAllRecords() {
            super((BWidget)BHistoryDbMaintenance.this, Sys.getModuleForClass(BHistoryDbMaintenance.class), "command.clearAllRecords");
        }
    }

    private class OptionGroup
    extends ToggleCommandGroup<ToggleCommand> {
        private OptionGroup() {
        }

        public void selected(ToggleCommand cmd) {
            if (BHistoryDbMaintenance.this.dateEditor != null) {
                BHistoryDbMaintenance.this.dateEditor.setReadonly(cmd != BHistoryDbMaintenance.this.clearOldRecords);
            }
        }
    }
}

