/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.ui.chart.BChartEditor;
import com.tridium.history.ui.chart.BReportViewer;
import javax.baja.history.BHistorySpace;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"history:HistorySpace", "history:HistoryShortcuts", "history:HistoryFolder"}, requiredPermissions="r")})
public class BHistoryChartBuilder
extends BWbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryChartBuilder.class);
    private Command saveCmd = new SaveChartCommand();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        OrdTarget target = this.getWbShell().getActiveOrdTarget();
        ViewQuery viewQuery = target.getViewQuery();
        String idText = null;
        if (viewQuery != null) {
            idText = viewQuery.getParameter("id", null);
        }
        if (idText == null) {
            if (this.getContent() instanceof BChartEditor) {
                ((BChartEditor)this.getContent()).builder = this;
                ((BChartEditor)this.getContent()).load(value);
            } else {
                BChartEditor editor = new BChartEditor(this);
                this.setContent((BWidget)editor);
                editor.load(value);
            }
            this.saveCmd.setEnabled(false);
            this.setTransferWidget(((BChartEditor)this.getContent()).getTransferWidget());
        } else {
            int id = -1;
            try {
                id = Integer.parseInt(idText);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.getContent() instanceof BReportViewer) {
                ((BReportViewer)this.getContent()).load(id);
            } else {
                BReportViewer viewer = new BReportViewer(this);
                this.setContent((BWidget)viewer);
                viewer.load(id);
            }
            this.saveCmd.setEnabled(true);
            this.setTransferWidget(((BReportViewer)this.getContent()).getTransferWidget());
        }
    }

    public BOrd getBuilderOrd() {
        BObject val = this.getCurrentValue();
        BOrd absOrd = null;
        if (val instanceof BSpace) {
            absOrd = ((BSpace)val).getAbsoluteOrd();
        } else if (val instanceof BComponent) {
            absOrd = ((BComponent)val).getAbsoluteOrd();
        } else if (val instanceof BINavNode) {
            absOrd = ((BINavNode)val).getNavOrd();
        }
        return BOrd.make((BOrd)absOrd, (String)"view:history:HistoryChartBuilder").normalize();
    }

    public Command getSaveCommand() {
        return this.saveCmd;
    }

    public void setSaveReportEnabled(boolean en) {
        Command cmd = this.getSaveCommand();
        if (cmd != null) {
            cmd.setEnabled(en);
        }
    }

    public BToolBar getViewToolBar() {
        Command saveCmd = this.getSaveCommand();
        if (saveCmd == null) {
            return null;
        }
        BToolBar tb = new BToolBar();
        tb.add("save", saveCmd);
        return tb;
    }

    public BHistorySpace getHistorySpace() {
        try {
            return (BHistorySpace)BOrd.make((String)"history:").get(this.getCurrentValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class SaveChartCommand
    extends Command {
        public SaveChartCommand() {
            super((BWidget)BHistoryChartBuilder.this, Sys.getModuleForClass(BHistoryChartBuilder.class), "chartBuilder.saveChart");
        }

        public CommandArtifact doInvoke() {
            try {
                BWidget content = BHistoryChartBuilder.this.getContent();
                if (content instanceof BReportViewer) {
                    ((BReportViewer)BHistoryChartBuilder.this.getContent()).save();
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)BHistoryChartBuilder.this, (String)"Cannot save chart.", (Object)e);
            }
            return null;
        }
    }
}

