/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.exporters;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.data.BDataTable;
import com.tridium.file.exporters.BITableToCsv;
import com.tridium.history.BHistory;
import com.tridium.history.ui.BHistoryTable;
import com.tridium.history.util.HistoryUtil;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.file.ExportOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.view.BIWbViewExporter;

@NiagaraType(agent={@AgentOn(types={"history:HistoryTable"})})
@NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.DEFAULT", flags=4, override=true)
public class BHistoryTableToCsv
extends BITableToCsv
implements BIWbViewExporter {
    @Generated
    public static final Property facets = BHistoryTableToCsv.newProperty((int)4, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryTableToCsv.class);
    private static final Logger LOGGER = Logger.getLogger("history");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void export(ExportOp op) throws Exception {
        BHistoryTable history = (BHistoryTable)op.get();
        PrintWriter out = new PrintWriter(new OutputStreamWriter(op.getOutputStream(), "UTF-8"));
        if (this.getIncludeBOM()) {
            out.print("\ufeff");
            out.flush();
        }
        if (this.getIncludeHeaders()) {
            out.print("history:" + history.getHistory().getNavDisplayName((Context)new BasicContext((Context)op, BHistory.FULL_DISPLAY_NAME_CX.getFacets())));
            out.print(this.getLineEnding());
            out.print(HistoryUtil.getRangeStr((BDynamicTimeRange)history.getRange(), (Context)op));
            out.print(this.getLineEnding());
            out.print(this.getLineEnding());
            out.flush();
        }
        TableModel model = history.getTableModel();
        if (this.getEncodeToString() && model instanceof DynamicTableModel) {
            this.export(((DynamicTableModel)model).export(), op);
        } else {
            if (this.getEncodeToString() && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("BHistoryTableToCsv cannot encodeToString for TableModel: " + history.getTableModel().getClass());
            }
            this.export((BITable)BHistoryTableToCsv.makeTable(history.getTableModel()), op);
        }
    }

    static BDataTable makeTable(TableModel model) {
        int colCount = model.getColumnCount();
        int rowCount = model.getRowCount();
        BDataTable t = new BDataTable();
        for (int c = 0; c < colCount; ++c) {
            String name = model.getColumnName(c);
            t.addColumn(name, name, BString.TYPE, 0, BFacets.NULL);
        }
        t.startRows();
        for (int r = 0; r < rowCount; ++r) {
            t.startRow();
            for (int c = 0; c < colCount; ++c) {
                String v = model.getValueAt(r, c).toString();
                t.set((BIDataValue)BString.make((String)v), BFacets.NULL);
            }
            t.endRow();
        }
        t.endRows();
        return t;
    }
}

