/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart;

import com.tridium.chart.BAxisBoundFE;
import java.util.ArrayList;
import javax.baja.chart.BAxis;
import javax.baja.chart.binding.BAxisBound;
import javax.baja.chart.binding.BAxisSpec;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"chart:AxisSpec"})})
@NiagaraAction(name="updateType", flags=4)
public class BAxisSpecFE
extends BWbFieldEditor {
    @Generated
    public static final Action updateType = BAxisSpecFE.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAxisSpecFE.class);
    private static final int LABEL_GAP = 8;
    private static final int EDITOR_GAP = 4;
    private static final int VGAP = 4;
    private static Lexicon lex = Lexicon.make((String)"chart");
    private BListDropDown typeSelect = new BListDropDown();
    private BLabel minLabel;
    private BAxisBoundFE minEditor;
    private BLabel maxLabel;
    private BAxisBoundFE maxEditor;

    @Generated
    public void updateType() {
        this.invoke(updateType, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAxisSpecFE() {
        BList list = this.typeSelect.getList();
        list.setRenderer((ListRenderer)new TypeListRenderer());
        list.addItem((Object)BTypeSpec.NULL);
        TypeInfo[] axisTypes = Sys.getRegistry().getTypes(BAxis.TYPE.getTypeInfo());
        ArrayList<BTypeSpec> temp = new ArrayList<BTypeSpec>(axisTypes.length);
        for (int i = 0; i < axisTypes.length; ++i) {
            if (axisTypes[i].isAbstract()) continue;
            temp.add(((BAxis)axisTypes[i].getInstance()).getValueType().getTypeSpec());
        }
        Object[] typeSpecs = temp.toArray(new BTypeSpec[0]);
        SortUtil.sort((Object[])typeSpecs);
        for (int i = 0; i < typeSpecs.length; ++i) {
            list.addItem(typeSpecs[i]);
        }
        this.add("typeSelect", (BValue)this.typeSelect);
        this.minLabel = new BLabel(lex.getText("min"));
        this.add("minLabel", (BValue)this.minLabel);
        this.minEditor = new BAxisBoundFE();
        this.add("minEditor", (BValue)this.minEditor);
        this.maxLabel = new BLabel(lex.getText("max"));
        this.add("maxlabel", (BValue)this.maxLabel);
        this.maxEditor = new BAxisBoundFE();
        this.add("maxEditor", (BValue)this.maxEditor);
        this.add("typeModLink", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)setModified));
        this.add("typeUpdate", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)updateType));
        this.add("minLink", (BValue)new BLink((BComponent)this.minEditor, (Slot)BWbFieldEditor.setModified, (Slot)setModified));
        this.add("maxLink", (BValue)new BLink((BComponent)this.maxEditor, (Slot)BWbFieldEditor.setModified, (Slot)setModified));
    }

    public void doLoadValue(BObject value, Context cx) {
        BAxisSpec spec = (BAxisSpec)value;
        BTypeSpec valueType = spec.getValueType();
        this.typeSelect.setSelectedItem((Object)valueType);
        this.minEditor.loadValue((BObject)spec.getMin(), cx);
        this.minEditor.setValueType(valueType);
        this.maxEditor.loadValue((BObject)spec.getMax(), cx);
        this.maxEditor.setValueType(valueType);
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        BAxisSpec spec = (BAxisSpec)value;
        spec.setValueType((BTypeSpec)this.typeSelect.getSelectedItem());
        spec.setMin((BAxisBound)this.minEditor.saveValue(cx));
        spec.setMax((BAxisBound)this.maxEditor.saveValue(cx));
        return spec;
    }

    public void doSetReadonly(boolean ro) {
        this.typeSelect.setEnabled(!ro);
        this.minEditor.setReadonly(ro);
        this.maxEditor.setReadonly(ro);
    }

    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        this.typeSelect.computePreferredSize();
        this.minLabel.computePreferredSize();
        this.minEditor.computePreferredSize();
        this.maxLabel.computePreferredSize();
        this.maxEditor.computePreferredSize();
        pw = this.typeSelect.getPreferredWidth();
        pw += 8.0;
        pw += Math.max(this.minLabel.getPreferredWidth(), this.maxLabel.getPreferredWidth());
        pw += 4.0;
        double rowHeight1 = Math.max(this.minLabel.getPreferredHeight(), this.minEditor.getPreferredHeight());
        double rowHeight2 = Math.max(this.maxLabel.getPreferredHeight(), this.maxEditor.getPreferredHeight());
        ph = this.typeSelect.getPreferredHeight();
        ph = Math.max(ph, rowHeight1 + 4.0 + rowHeight2);
        this.setPreferredSize(pw += Math.max(this.minEditor.getPreferredWidth(), this.maxLabel.getPreferredWidth()), ph);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.typeSelect.computePreferredSize();
        this.minLabel.computePreferredSize();
        this.minEditor.computePreferredSize();
        this.maxLabel.computePreferredSize();
        this.maxEditor.computePreferredSize();
        double x = 0.0;
        this.typeSelect.setBounds(x, (h - this.typeSelect.getPreferredHeight()) / 2.0, this.typeSelect.getPreferredWidth(), this.typeSelect.getPreferredHeight());
        double rowHeight1 = Math.max(this.minLabel.getPreferredHeight(), this.minEditor.getPreferredHeight());
        double rowHeight2 = Math.max(this.maxLabel.getPreferredHeight(), this.maxEditor.getPreferredHeight());
        double y = 0.0;
        this.minLabel.setBounds(x += this.typeSelect.getPreferredWidth() + 8.0, y + (rowHeight1 - this.minLabel.getPreferredHeight()) / 2.0, this.minLabel.getPreferredWidth(), this.minLabel.getPreferredHeight());
        this.maxLabel.setBounds(x, (y += rowHeight1 + 4.0) + (rowHeight2 - this.maxLabel.getPreferredHeight()) / 2.0, this.maxLabel.getPreferredWidth(), this.maxLabel.getPreferredHeight());
        y = 0.0;
        this.minEditor.setBounds(x += Math.max(this.minLabel.getPreferredWidth(), this.maxLabel.getPreferredWidth()) + 4.0, y + (rowHeight1 - this.minEditor.getPreferredHeight()) / 2.0, this.minEditor.getPreferredWidth(), this.minEditor.getPreferredHeight());
        this.maxEditor.setBounds(x, (y += rowHeight1 + 4.0) + (rowHeight2 - this.maxEditor.getPreferredHeight()) / 2.0, this.maxEditor.getPreferredWidth(), this.maxEditor.getPreferredHeight());
    }

    public void doUpdateType() {
        this.minEditor.setValueType((BTypeSpec)this.typeSelect.getSelectedItem());
        this.maxEditor.setValueType((BTypeSpec)this.typeSelect.getSelectedItem());
        this.relayout();
    }

    public static void main(String[] args) {
        BAxisSpec spec = new BAxisSpec();
        spec.setValueType(BINumeric.TYPE.getTypeSpec());
        spec.setMin(BAxisBound.makeAuto());
        spec.setMax(BAxisBound.makeAuto());
        BAxisSpecFE ed = new BAxisSpecFE();
        ed.loadValue((BObject)spec);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)ed);
        BFrame f = new BFrame();
        f.setContent((BWidget)pane);
        f.setScreenBounds(200.0, 10.0, 400.0, 300.0);
        f.open();
    }

    private class TypeListRenderer
    extends ListRenderer {
        private TypeListRenderer() {
        }

        public String getItemText(ListRenderer.Item item) {
            if (((BTypeSpec)item.value).isNull()) {
                return lex.getText("auto");
            }
            return super.getItemText(item);
        }
    }
}

