/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart;

import com.tridium.chart.BAbstractPanControl;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChartPane;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;

@NiagaraType
@NiagaraProperty(name="zoomFactor", type="double", defaultValue="0.15")
public class BDockedPanControl
extends BAbstractPanControl {
    @Generated
    public static final Property zoomFactor = BDockedPanControl.newProperty((int)0, (double)0.15, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDockedPanControl.class);
    static final int UP = 1;
    static final int RIGHT = 2;
    static final int DOWN = 3;
    static final int LEFT = 4;
    private BChartPane chart = null;
    private BToolBar bar = null;
    private ZoomOutCommand zoomOut;
    private CancelZoomCommand cancelZoom;
    private PanDirectionCommand panUp;
    private PanDirectionCommand panLeft;
    private PanDirectionCommand panDown;
    private PanDirectionCommand panRight;
    private ZoomHorizontalCommand zoomHorizontal;
    private ZoomVerticalCommand zoomVertical;

    @Generated
    public double getZoomFactor() {
        return this.getDouble(zoomFactor);
    }

    @Generated
    public void setZoomFactor(double v) {
        this.setDouble(zoomFactor, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDockedPanControl() {
    }

    public BDockedPanControl(BChartPane chart) {
        this.chart = chart;
        this.bar = new BToolBar();
        this.zoomOut = new ZoomOutCommand(this, chart);
        this.cancelZoom = new CancelZoomCommand(this, chart);
        this.panUp = new PanDirectionCommand(this, chart, 1);
        this.panRight = new PanDirectionCommand(this, chart, 2);
        this.panDown = new PanDirectionCommand(this, chart, 3);
        this.panLeft = new PanDirectionCommand(this, chart, 4);
        this.zoomHorizontal = new ZoomHorizontalCommand(this, chart);
        this.zoomVertical = new ZoomVerticalCommand(this, chart);
        this.bar.add("zoomOut", (Command)this.zoomOut);
        this.bar.add("cancelZoom", (Command)this.cancelZoom);
        this.bar.add("sep1", (BValue)new BSeparator());
        this.bar.add("panUp", (Command)this.panUp);
        this.bar.add("panDown", (Command)this.panDown);
        this.bar.add("panRight", (Command)this.panRight);
        this.bar.add("panLeft", (Command)this.panLeft);
        this.bar.add("sep2", (BValue)new BSeparator());
        this.bar.add("zoomHorizontal", (Command)this.zoomHorizontal);
        this.bar.add("zoomVertical", (Command)this.zoomVertical);
        this.add("dockedPanControl", (BValue)this.bar);
    }

    public void computePreferredSize() {
        this.bar.computePreferredSize();
        this.setPreferredSize(this.getParentWidget().getWidth(), this.bar.getPreferredHeight());
    }

    public void doLayout(BWidget[] kids) {
        if (this.chart == null) {
            return;
        }
        this.bar.setBounds(0.0, 0.0, this.getPreferredWidth(), this.getPreferredHeight());
    }

    public void paint(Graphics g) {
        this.paintChildren(g);
    }

    public void updateActionStates() {
        if (this.chart == null) {
            return;
        }
        this.zoomOut.setEnabled(this.chart.isZoomed(BAxisDimension.x) || this.chart.isZoomed(BAxisDimension.y));
        this.panUp.setEnabled(this.chart.isZoomed(BAxisDimension.y));
        this.panDown.setEnabled(this.chart.isZoomed(BAxisDimension.y));
        this.panLeft.setEnabled(this.chart.isZoomed(BAxisDimension.x));
        this.panRight.setEnabled(this.chart.isZoomed(BAxisDimension.x));
    }

    class PanDirectionCommand
    extends Command {
        BChartPane chart;
        int dir;

        PanDirectionCommand(BWidget owner, BChartPane chart, int dir) {
            super(owner, null);
            this.icon = this.getImage(dir);
            this.description = this.getDesc(dir);
            this.dir = dir;
            this.chart = chart;
        }

        private BImage getImage(int dir) {
            switch (dir) {
                case 1: {
                    return BImage.make((String)"module://icons/x16/arrowUp.png");
                }
                case 2: {
                    return BImage.make((String)"module://icons/x16/arrowRight.png");
                }
                case 3: {
                    return BImage.make((String)"module://icons/x16/arrowDown.png");
                }
                case 4: {
                    return BImage.make((String)"module://icons/x16/arrowLeft.png");
                }
            }
            return null;
        }

        private String getDesc(int dir) {
            switch (dir) {
                case 1: {
                    return "Pan up.";
                }
                case 2: {
                    return "Pan right.";
                }
                case 3: {
                    return "Pan down.";
                }
                case 4: {
                    return "Pan left.";
                }
            }
            return null;
        }

        public CommandArtifact doInvoke() {
            switch (this.dir) {
                case 1: {
                    this.chart.panUp();
                    break;
                }
                case 2: {
                    this.chart.panRight();
                    break;
                }
                case 3: {
                    this.chart.panDown();
                    break;
                }
                case 4: {
                    this.chart.panLeft();
                }
            }
            return null;
        }
    }

    class ZoomVerticalCommand
    extends Command {
        BChartPane chart;

        ZoomVerticalCommand(BWidget owner, BChartPane chart) {
            super(owner, null, BImage.make((String)"module://icons/x16/zoomVertical.png"), null, "Zoom vertical.");
            this.chart = chart;
        }

        public CommandArtifact doInvoke() {
            double height = this.chart.getCanvas().getHeight();
            double clip = height * BDockedPanControl.this.getZoomFactor();
            this.chart.zoomIn(BAxisDimension.y, height - clip, clip);
            return null;
        }
    }

    class ZoomHorizontalCommand
    extends Command {
        BChartPane chart;

        ZoomHorizontalCommand(BWidget owner, BChartPane chart) {
            super(owner, null, BImage.make((String)"module://icons/x16/zoomHorizontal.png"), null, "Zoom horizontal.");
            this.chart = chart;
        }

        public CommandArtifact doInvoke() {
            double width = this.chart.getCanvas().getWidth();
            double clip = width * BDockedPanControl.this.getZoomFactor();
            this.chart.zoomIn(BAxisDimension.x, clip, width - clip);
            return null;
        }
    }

    class CancelZoomCommand
    extends Command {
        BChartPane chart;

        CancelZoomCommand(BWidget owner, BChartPane chart) {
            super(owner, null, BImage.make((String)"module://icons/x16/noZoom.png"), null, "Cancel zoom");
            this.chart = chart;
        }

        public CommandArtifact doInvoke() {
            this.chart.noZoom();
            return null;
        }
    }

    class ZoomOutCommand
    extends Command {
        BChartPane chart;

        ZoomOutCommand(BWidget owner, BChartPane chart) {
            super(owner, null, BImage.make((String)"module://icons/x16/undo.png"), null, "Zoom out");
            this.chart = chart;
        }

        public CommandArtifact doInvoke() {
            this.chart.zoomOut();
            return null;
        }
    }
}

