/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart.test;

import java.util.Random;
import javax.baja.chart.Series;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.Type;

public class TestSeries
extends Series {
    static Random rand = new Random();
    private String name;
    private double[] data;
    private double min;
    private double max;
    private boolean even = false;
    private BFacets facets0;
    private BFacets facets1;

    public TestSeries(String name, int rows, double maxValue, boolean even, BFacets facets0, BFacets facets1) {
        this.name = name;
        this.even = even;
        this.facets0 = facets0;
        this.facets1 = facets1;
        this.data = new double[rows];
        this.min = 0.0;
        this.max = 0.0;
        for (int i = 0; i < rows; ++i) {
            this.data[i] = maxValue * rand.nextDouble();
            if (i == 0) {
                this.max = this.min = this.data[i];
                continue;
            }
            this.max = Math.max(this.data[i], this.max);
            this.min = Math.min(this.data[i], this.min);
        }
        if (this.min == this.max) {
            this.min -= 5.0;
            this.max += 5.0;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type getColumnType(int col) {
        return BDouble.TYPE;
    }

    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        return "Column-" + col;
    }

    @Override
    public String getColumnDisplayName(int col) {
        return this.getColumnName(col);
    }

    @Override
    public BFacets getColumnFacets(int col) {
        if (col == 0) {
            return this.facets0;
        }
        return this.facets1;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public Object getValue(int row, int col) {
        if (col == 0) {
            return BDouble.make((double)row);
        }
        return BDouble.make((double)this.data[row]);
    }

    @Override
    public Object getMin(int col) {
        if (col == 0) {
            return BDouble.make((double)0.0);
        }
        return BDouble.make((double)this.min);
    }

    @Override
    public Object getMax(int col) {
        if (col == 0) {
            return BDouble.make((double)(this.data.length - 1));
        }
        return BDouble.make((double)this.max);
    }
}

