/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.chart.BChartLegend;
import javax.baja.chart.BChartPane;
import javax.baja.chart.DefaultSwatchRenderer;
import javax.baja.chart.Series;
import javax.baja.chart.SwatchRenderer;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

@NiagaraType
public class BDefaultChartLegend
extends BChartLegend {
    @Generated
    public static final Type TYPE = Sys.loadType(BDefaultChartLegend.class);
    private static Lexicon lex = Lexicon.make((String)"chart");
    private static BFont defFont = BFont.make((String)lex.getText("chart.legend.font"));
    private static final double MARGIN = 4.0;
    private static final double SPACING = 8.0;
    private SwatchRenderer swatchRenderer = new DefaultSwatchRenderer();
    private LegendRow rows;
    private RectGeom bounds;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public double getPreferredHeight(double w) {
        if (!this.isEnabled() || !this.isVisible()) {
            return 0.0;
        }
        BChartPane pane = this.getPane();
        if (pane == null) {
            return 0.0;
        }
        double x = 8.0;
        double y = 4.0;
        int rowCount = 1;
        LegendItem temp = this.getItems();
        if (temp == null) {
            return 0.0;
        }
        double itemHeight = temp.height;
        int itemCount = 0;
        int countThisRow = 0;
        while (temp != null) {
            ++itemCount;
            if (x + temp.width > w && countThisRow > 0) {
                ++rowCount;
                countThisRow = 0;
                x = 8.0;
                y += temp.height + 4.0;
            }
            x += temp.width + 8.0;
            ++countThisRow;
            temp = temp.next;
        }
        if (itemCount <= 1) {
            return 0.0;
        }
        return itemHeight * (double)rowCount + 4.0 * (double)(rowCount + 1);
    }

    public void doLayout(BWidget[] kids) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        BChartPane pane = this.getPane();
        if (pane == null) {
            return;
        }
        LegendItem temp = this.getItems();
        if (temp == null) {
            return;
        }
        double w = this.getWidth();
        LegendRow thisRow = this.rows = new LegendRow();
        while (temp != null) {
            LegendItem toAdd = temp;
            temp = temp.next;
            double newWidth = thisRow.addToEnd(toAdd);
            if (!(newWidth > w) || thisRow.count <= 1) continue;
            thisRow.removeFromEnd();
            thisRow = thisRow.next = new LegendRow();
            thisRow.addToEnd(toAdd);
        }
        LegendRow tempRow = this.rows;
        double x = 4.0;
        double y = 4.0;
        double rowHeight = tempRow.first.height;
        double maxRow = 0.0;
        while (tempRow != null) {
            maxRow = Math.max(maxRow, tempRow.width);
            x = (w - tempRow.width) / 2.0;
            LegendItem item = tempRow.first;
            while (item != null) {
                item.setLocation(x, y);
                x += item.width + 8.0;
                item = item.next;
            }
            y += rowHeight + 4.0;
            tempRow = tempRow.next;
        }
        this.bounds = new RectGeom(Math.max(0.0, (w - maxRow) / 2.0 - 4.0), 0.0, Math.min(w - 1.0, maxRow + 8.0 - 1.0), this.getHeight() - 1.0);
    }

    private LegendItem getItems() {
        LegendItem first = null;
        LegendItem last = null;
        Series[] seriesList = this.getPane().getAllSeries();
        for (int j = 0; j < seriesList.length; ++j) {
            LegendItem item = new LegendItem(seriesList[j], this.swatchRenderer);
            item.computeSize();
            if (first == null) {
                first = last = item;
                continue;
            }
            last.next = item;
            last = item;
        }
        return first;
    }

    public void paint(Graphics g) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        BChartPane pane = this.getPane();
        LegendItem temp = this.getItems();
        if (pane == null || temp == null) {
            return;
        }
        g.setBrush(this.getBackground());
        g.fill((IGeom)this.bounds);
        LegendRow tempRow = this.rows;
        while (tempRow != null) {
            LegendItem item = tempRow.first;
            while (item != null) {
                g.push();
                g.translate(item.x, item.y);
                item.paint(g);
                g.pop();
                item = item.next;
            }
            tempRow = tempRow.next;
        }
        g.setBrush(BColor.black.toBrush());
        g.stroke((IGeom)this.bounds);
    }

    public void setSwatchRenderer(SwatchRenderer swatchRenderer) {
        if (swatchRenderer == null) {
            throw new NullPointerException("Swatch renderer cannot be null.");
        }
        this.swatchRenderer = swatchRenderer;
    }

    private class LegendItem {
        Series series;
        SwatchRenderer swatch;
        double width;
        double height;
        double x;
        double y;
        LegendItem next = null;

        public LegendItem(Series series, SwatchRenderer swatch) {
            this.series = series;
            this.swatch = swatch;
        }

        public void computeSize() {
            BFont font = BDefaultChartLegend.this.getFont();
            if (font.isNull()) {
                font = defFont;
            }
            this.width = this.swatch.getWidth() + 4.0 + font.width(this.series.getName());
            this.height = Math.max(this.swatch.getHeight(), font.getHeight());
        }

        public void setLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public void paint(Graphics g) {
            BFont font = BDefaultChartLegend.this.getFont();
            if (font.isNull()) {
                font = defFont;
            }
            this.swatch.paintSwatch(this.series, g, 0.0, (this.height - this.swatch.getHeight()) / 2.0);
            BBrush textBrush = BDefaultChartLegend.this.getFill();
            if (textBrush.isNull()) {
                textBrush = BColor.black.toBrush();
            }
            g.setBrush(textBrush);
            g.setFont(font);
            g.drawString(this.series.getName(), this.swatch.getWidth() + 4.0, this.height - (this.height - font.getAscent()) / 2.0);
        }

        public String toString() {
            return this.series.getName();
        }
    }

    private class LegendRow {
        LegendItem first;
        LegendItem last;
        int count = 0;
        double width;
        LegendRow next = null;

        private LegendRow() {
        }

        public double addToFront(LegendItem item) {
            item.next = null;
            if (this.first == null) {
                this.first = this.last = item;
            } else {
                item.next = this.first;
                this.first = item;
            }
            ++this.count;
            this.updateWidth();
            return this.width;
        }

        public double addToEnd(LegendItem item) {
            item.next = null;
            if (this.last == null) {
                this.first = this.last = item;
            } else {
                this.last.next = item;
                this.last = item;
            }
            ++this.count;
            this.updateWidth();
            return this.width;
        }

        public LegendItem removeFromFront() {
            if (this.count == 0) {
                return null;
            }
            LegendItem result = null;
            if (this.first == this.last) {
                result = this.first;
                this.last = null;
                this.first = null;
            } else {
                result = this.first;
                this.first = this.first.next;
                result.next = null;
            }
            --this.count;
            this.updateWidth();
            return result;
        }

        public LegendItem removeFromEnd() {
            if (this.count == 0) {
                return null;
            }
            LegendItem result = null;
            if (this.first == this.last) {
                result = this.first;
                this.last = null;
                this.first = null;
            } else {
                LegendItem temp = this.first;
                while (temp.next != this.last) {
                    temp = temp.next;
                }
                result = this.last;
                this.last = temp;
                this.last.next = null;
            }
            --this.count;
            this.updateWidth();
            return result;
        }

        private void updateWidth() {
            this.width = 8.0 + (double)(this.count - 1) * 8.0;
            LegendItem temp = this.first;
            while (temp != null) {
                this.width += temp.width;
                temp = temp.next;
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            LegendItem temp = this.first;
            while (temp != null) {
                if (temp != this.first) {
                    s.append(", ");
                }
                s.append(temp.toString());
                temp = temp.next;
            }
            return s.toString();
        }
    }
}

