/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import java.util.ArrayList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BAxisLocation;
import javax.baja.chart.Series;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDiscreteAxis
extends BAxis {
    @Generated
    public static final Type TYPE = Sys.loadType(BDiscreteAxis.class);
    private Object NULL = new Object();
    private Object[] range;
    private double[] locs;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDiscreteAxis() {
        this.setMinAuto(false);
        this.setMaxAuto(false);
    }

    @Override
    public Type getValueType() {
        return BValue.TYPE;
    }

    public void setRange(Object[] range) {
        this.range = range;
        this.locs = new double[range.length];
    }

    @Override
    public Object getAxisMin() {
        if (this.range.length == 0) {
            return this.NULL;
        }
        return this.range[0];
    }

    @Override
    public void setAxisMin(Object newMin) {
    }

    @Override
    public Object getAxisMax() {
        if (this.range.length == 0) {
            return this.NULL;
        }
        return this.range[this.range.length - 1];
    }

    @Override
    public void setAxisMax(Object newMax) {
    }

    @Override
    public Object[] getTickValues() {
        return this.range;
    }

    @Override
    public String valueToString(Object value) {
        if (value instanceof BObject) {
            return ((BObject)value).toString((Context)this.getFacets());
        }
        return value.toString();
    }

    @Override
    public void doLayout() {
        block3: {
            BAxisDimension dim;
            double loc;
            double segWidth;
            double gapWidth;
            block2: {
                double len = this.getFullLength();
                int gaps = this.range.length + 1;
                gapWidth = len / (double)this.range.length / 5.0;
                segWidth = (len - (double)gaps * gapWidth) / (double)this.range.length;
                double segOffset = segWidth / 2.0;
                loc = gapWidth + segOffset;
                dim = this.getDimension();
                if (dim != BAxisDimension.y) break block2;
                for (int i = this.range.length - 1; i >= 0; --i) {
                    this.locs[i] = loc;
                    loc += segWidth + gapWidth;
                }
                break block3;
            }
            if (dim != BAxisDimension.x) break block3;
            for (int i = 0; i < this.range.length; ++i) {
                this.locs[i] = loc;
                loc += segWidth + gapWidth;
            }
        }
    }

    @Override
    public double toDisplaySpace(Object value) {
        if (value instanceof BEnum) {
            for (int i = 0; i < this.range.length; ++i) {
                if (((BEnum)this.range[i]).getOrdinal() != ((BEnum)value).getOrdinal()) continue;
                return this.locs[i];
            }
        } else {
            for (int i = 0; i < this.range.length; ++i) {
                if (!this.range[i].equals(value)) continue;
                return this.locs[i];
            }
        }
        throw new IllegalArgumentException("Value out of discrete axis range: " + value);
    }

    @Override
    public Object fromDisplaySpace(double loc) {
        double d2;
        if (this.getLocation() == BAxisLocation.left || this.getLocation() == BAxisLocation.right) {
            if (loc > this.locs[0]) {
                return this.range[0];
            }
            if (loc < this.locs[this.locs.length - 1]) {
                return this.range[this.range.length - 1];
            }
            int index = 1;
            while (loc < this.locs[index]) {
                ++index;
            }
            double d = (this.locs[index - 1] - this.locs[index]) / 2.0 + this.locs[index];
            return d < loc ? this.range[index - 1] : this.range[index];
        }
        if (loc < this.locs[0]) {
            return this.range[0];
        }
        if (loc > this.locs[this.locs.length - 1]) {
            return this.range[this.range.length - 1];
        }
        int index = 0;
        while (loc > this.locs[index]) {
            ++index;
        }
        double d1 = loc - this.locs[index];
        double d = d2 = index < this.locs.length - 2 ? this.locs[index + 1] - loc : Double.MAX_VALUE;
        if (d1 < d2) {
            return this.range[index];
        }
        return this.range[index + 1];
    }

    @Override
    public boolean isZoomEnabled() {
        return false;
    }

    public static Object[] extractRange(Series series, int column) {
        if (series.getColumnType(column).is(BEnum.TYPE)) {
            BEnumRange enumRange = null;
            BFacets facets = series.getColumnFacets(column);
            if (null != facets) {
                BObject range = facets.get("range");
                if (range != null && range instanceof BEnumRange) {
                    enumRange = (BEnumRange)range;
                }
                return BDiscreteAxis.extractEnumRange(enumRange, series, column);
            }
        }
        int rowCount = series.getRowCount();
        ArrayList<Object> temp = new ArrayList<Object>(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            Object value = series.getValue(row, column);
            if (temp.contains(value)) continue;
            temp.add(value);
        }
        Object[] range = temp.toArray();
        if (range.length > 0 && range[0] instanceof Comparable) {
            SortUtil.sort((Object[])range, (Object[])range, (boolean)true);
        }
        return range;
    }

    public static Object[] extractEnumRange(BEnumRange range, Series series, int column) {
        if (range == null) {
            range = BEnumRange.NULL;
        }
        int[] ordinals = range.getOrdinals();
        IntHashMap ordMap = new IntHashMap(Math.max(7, ordinals.length));
        for (int i = 0; i < ordinals.length; ++i) {
            ordMap.put(ordinals[i], (Object)range.get(ordinals[i]));
        }
        int rowCount = series.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            BEnum value = (BEnum)series.getValue(row, column);
            if (ordMap.get(value.getOrdinal()) != null) continue;
            ordMap.put(value.getOrdinal(), (Object)value);
        }
        Object[] values = (BEnum[])ordMap.toArray((Object[])new BEnum[ordMap.size()]);
        SortUtil.sort((Object[])values);
        return values;
    }

    public void merge(BDiscreteAxis arg) {
        if (this.isCompatible(arg)) {
            int i;
            Series[] argSeries = arg.getSeries();
            for (int i2 = 0; i2 < argSeries.length; ++i2) {
                this.updateSeries(argSeries[i2]);
            }
            int size = arg.range.length + this.range.length;
            ArrayList<Object> temp = new ArrayList<Object>(size);
            for (i = 0; i < arg.range.length; ++i) {
                temp.add(arg.range[i]);
            }
            for (i = 0; i < this.range.length; ++i) {
                temp.add(this.range[i]);
            }
            Object[] tempRange = temp.toArray();
            if (tempRange[0] instanceof Comparable) {
                SortUtil.sort((Object[])tempRange, (Object[])tempRange, (boolean)true);
            }
            this.range = tempRange;
            this.locs = new double[size];
        }
    }
}

