/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.TrendFlags;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDiscreteLineChart
extends BChart {
    @Generated
    public static final Type TYPE = Sys.loadType(BDiscreteLineChart.class);
    private double lastX;
    private double lastY;
    private BPen defaultPen = BPen.make((double)1.0);
    private int startIndex = 0;
    private int discreteCount = 1;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDiscreteLineChart() {
    }

    public BDiscreteLineChart(ChartModel model) {
        super(model);
    }

    public void setStartIndex(int index, int of) {
        this.startIndex = index;
        this.discreteCount = of;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPaint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        int xcol = 0;
        int ycol = 1;
        g.push();
        try {
            ChartModel model = this.getModel();
            int specCount = model.getSpecCount();
            int discreteIndex = this.startIndex;
            for (int i = 0; i < specCount; ++i) {
                ChartSpec spec = model.getSpec(i);
                BAxis xaxis = spec.getXAxis();
                BAxis yaxis = spec.getYAxis();
                Series series = spec.getSeries();
                g.setBrush(series.getBrush());
                BPen pen = series.getPen();
                if (pen == null) {
                    pen = this.defaultPen;
                }
                g.setPen(pen);
                int rowCount = series.getRowCount();
                boolean lastHidden = false;
                double offset = -((double)(this.discreteCount / 2) * (pen.getWidth() + 1.0)) + (double)discreteIndex++ * (pen.getWidth() + 1.0);
                for (int row = 0; row < rowCount; ++row) {
                    int trendFlags = series.getTrendFlags(row);
                    if (TrendFlags.isHidden((int)trendFlags)) {
                        lastHidden = true;
                        continue;
                    }
                    double x = xaxis.toDisplaySpace(series.getValue(row, xcol));
                    double y = yaxis.toDisplaySpace(series.getValue(row, ycol));
                    if (row != 0) {
                        x += offset;
                    }
                    y += offset;
                    if (row != 0 && !lastHidden && !TrendFlags.isStart((int)trendFlags)) {
                        g.strokeLine(this.lastX, this.lastY, x, this.lastY);
                        g.strokeLine(x, this.lastY, x, y);
                    }
                    lastHidden = false;
                    this.lastX = x;
                    this.lastY = y;
                }
            }
        }
        finally {
            g.pop();
        }
    }
}

