/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.gx.GxEnv;
import javax.baja.chart.AxisRenderer;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BAxisLocation;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.Series;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.util.Lexicon;

public class DefaultAxisRenderer
extends AxisRenderer {
    protected static final double SWATCH_WIDTH = 12.0;
    protected static final double SWATCH_HEIGHT = 12.0;
    private static final String SPACER = "      ";
    private static Lexicon lex = Lexicon.make((String)"chart");
    private BFont tickFont;
    private BFont unitFont;
    private BFont titleFont;

    public DefaultAxisRenderer() {
        this.unitFont = this.tickFont = BFont.make((String)lex.getText("chart.axis.tick.font"));
        this.titleFont = BFont.make((String)lex.getText("chart.axis.title.font"));
    }

    @Override
    public void paint(Graphics g, BAxis axis) {
        if (axis.getLocation() == BAxisLocation.left) {
            this.paintLeft(g, axis);
        } else if (axis.getLocation() == BAxisLocation.bottom) {
            this.paintBottom(g, axis);
        } else if (axis.getLocation() == BAxisLocation.right) {
            this.paintRight(g, axis);
        } else if (axis.getLocation() == BAxisLocation.top) {
            this.paintTop(g, axis);
        }
    }

    @Override
    public double getPreferredAxisWidth(BAxis axis) {
        BAxisDimension dim = axis.getDimension();
        double total = 7.0;
        if (dim == BAxisDimension.x) {
            total += this.tickFont.getHeight() + 4.0;
        } else if (dim == BAxisDimension.y) {
            if (axis instanceof BDiscreteAxis) {
                double maxLen = 0.0;
                Object[] tickValues = axis.getTickValues();
                for (int i = 0; i < tickValues.length; ++i) {
                    maxLen = Math.max(maxLen, this.tickFont.width(axis.valueToString(tickValues[i])));
                }
                total += maxLen + 4.0;
            } else {
                String maxLabel = axis.valueToString(axis.getAxisMax());
                total += this.tickFont.width(maxLabel) + 4.0;
            }
        }
        double labelWidth = 0.0;
        String label = this.getAxisLabel(axis);
        if (label.length() == 0) {
            label = SPACER;
        }
        labelWidth = this.titleFont.width(label);
        return (total += labelWidth) + 5.0;
    }

    public void paintTop(Graphics g, BAxis axis) {
        String unit;
        double w = axis.getWidth();
        double h = axis.getHeight();
        Object[] ticks = axis.getTickValues();
        int tickCount = ticks == null ? 0 : ticks.length;
        g.setBrush(BColor.black);
        g.setFont(this.tickFont);
        double lastEnd = axis.getMinMargin();
        for (int i = 0; i < tickCount; ++i) {
            double loc = axis.toDisplaySpace(ticks[i]);
            String label = axis.valueToString(ticks[i]);
            double len = this.tickFont.width(label);
            double x = loc - len / 2.0;
            if (i != 0 && !(x > lastEnd + 5.0)) continue;
            if (i == 0) {
                x = 0.0;
            }
            if (x + len >= w && (x = w - len) <= lastEnd + 5.0) continue;
            g.strokeLine(loc, h - 5.0, loc, h);
            g.drawString(label, x, h - 7.0);
            lastEnd = x + len;
        }
        String title = axis.getTitle();
        if (title != null && title.length() != 0) {
            g.setFont(this.titleFont);
            g.drawString(title, (axis.getLength() - this.titleFont.width(title)) / 2.0, h - 7.0 - this.tickFont.getHeight() - 4.0);
        }
        if ((unit = axis.getUnitLabel()) != null && unit.length() != 0) {
            g.setFont(this.unitFont);
            g.drawString(unit, axis.getLength() - this.unitFont.width(unit) - 4.0, this.unitFont.getHeight() + 4.0);
        }
    }

    public void paintBottom(Graphics g, BAxis axis) {
        String unit;
        double w = axis.getWidth();
        Object[] ticks = axis.getTickValues();
        int tickCount = ticks == null ? 0 : ticks.length;
        g.setBrush(BColor.black);
        g.setFont(this.tickFont);
        double lastEnd = axis.getMinMargin();
        for (int i = 0; i < tickCount; ++i) {
            double loc = axis.toDisplaySpace(ticks[i]);
            String label = axis.valueToString(ticks[i]);
            double len = this.tickFont.width(label);
            double x = loc - len / 2.0;
            if (i != 0 && !(x > lastEnd + 5.0)) continue;
            if (i == 0) {
                x = 0.0;
            }
            if (x + len >= w && (x = w - len) <= lastEnd + 5.0) continue;
            g.strokeLine(loc, 0.0, loc, 5.0);
            g.drawString(label, x, 5.0 + this.tickFont.getHeight());
            lastEnd = x + len;
        }
        String title = axis.getTitle();
        if (title != null && title.length() != 0) {
            g.setFont(this.titleFont);
            g.drawString(title, (axis.getLength() - this.titleFont.width(title)) / 2.0, 5.0 + this.tickFont.getHeight() + 4.0 + this.titleFont.getHeight());
        }
        if ((unit = axis.getUnitLabel()) != null && unit.length() != 0) {
            g.setFont(this.unitFont);
            g.drawString(unit, axis.getLength() - this.unitFont.width(unit) - 4.0, 5.0 + this.tickFont.getHeight() + 4.0 + this.unitFont.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintLeft(Graphics g, BAxis axis) {
        double w = axis.getWidth();
        double h = axis.getHeight();
        Object[] ticks = axis.getTickValues();
        int tickCount = ticks == null ? 0 : ticks.length;
        g.setBrush(BColor.black);
        g.setFont(this.tickFont);
        double maxTickLabel = 0.0;
        double lastEnd = h;
        for (int i = 0; i < tickCount; ++i) {
            double loc = axis.toDisplaySpace(ticks[i]);
            String label = axis.valueToString(ticks[i]);
            double labelLen = this.tickFont.width(label);
            double y = loc + this.tickFont.getAscent() / 2.0 - 1.0;
            if (loc < 0.0 || loc > h) continue;
            maxTickLabel = Math.max(labelLen, maxTickLabel);
            if (i == 0 || i == tickCount - 1 || lastEnd == h || y < lastEnd - 5.0) {
                g.strokeLine(w - 5.0, loc, w, loc);
                g.drawString(label, w - 7.0 - labelLen, y);
                lastEnd = y - this.tickFont.getAscent();
                continue;
            }
            g.strokeLine(w - 2.0, loc, w, loc);
        }
        String label = this.getAxisLabel(axis);
        if (label.length() == 0) {
            label = SPACER;
        }
        if (GxEnv.get().isRotationSupported()) {
            g.push();
            try {
                g.setFont(this.titleFont);
                double labelWidth = this.titleFont.width(label);
                double ty = h / 2.0 - maxTickLabel;
                double tx = 3.0;
                g.drawString(label, tx, ty);
                if (axis.getShowSwatches()) {
                    Series[] s = axis.getSeries();
                    double x = Math.max(0.0, tx + labelWidth / 2.0 - 6.0);
                    for (int i = 0; i < s.length; ++i) {
                        double y = ty + 5.0;
                        if (i > 0) {
                            y += (double)i * 12.0 + (double)(i * 3);
                        }
                        g.setBrush(s[i].getBrush());
                        g.fillRect(x, y, 12.0, 12.0);
                    }
                }
            }
            finally {
                g.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRight(Graphics g, BAxis axis) {
        double w = axis.getWidth();
        double h = axis.getHeight();
        Object[] ticks = axis.getTickValues();
        int tickCount = ticks == null ? 0 : ticks.length;
        g.setBrush(BColor.black);
        g.setFont(this.tickFont);
        double maxTickLabel = 0.0;
        double lastEnd = h;
        for (int i = 0; i < tickCount; ++i) {
            double loc = axis.toDisplaySpace(ticks[i]);
            String label = axis.valueToString(ticks[i]);
            double labelLen = this.tickFont.width(label);
            maxTickLabel = Math.max(labelLen, maxTickLabel);
            double y = loc + this.tickFont.getAscent() / 2.0 - 1.0;
            if (loc < 0.0 || loc > h) continue;
            if (i == 0 || i == tickCount - 1 || lastEnd == h || y < lastEnd - 5.0) {
                g.strokeLine(0.0, loc, 5.0, loc);
                g.drawString(label, 8.0, y);
                lastEnd = y - this.tickFont.getAscent();
                continue;
            }
            g.strokeLine(0.0, loc, 2.0, loc);
        }
        String label = this.getAxisLabel(axis);
        if (label.length() == 0) {
            label = SPACER;
        }
        if (GxEnv.get().isRotationSupported()) {
            g.push();
            try {
                g.setFont(this.titleFont);
                double labelWidth = this.titleFont.width(label);
                double tx = w - labelWidth - 7.0;
                double ty = h / 2.0 - maxTickLabel;
                g.drawString(label, tx, ty);
                if (axis.getShowSwatches()) {
                    Series[] s = axis.getSeries();
                    double x = Math.max(0.0, tx + labelWidth / 2.0 - 6.0);
                    for (int i = 0; i < s.length; ++i) {
                        double y = ty + 5.0;
                        if (i > 0) {
                            y += (double)i * 12.0 + (double)(i * 3);
                        }
                        g.setBrush(s[i].getBrush());
                        g.fillRect(x, y, 12.0, 12.0);
                    }
                }
            }
            finally {
                g.pop();
            }
        }
    }

    private String getAxisLabel(BAxis axis) {
        String title = axis.getTitle();
        String unit = axis.getUnitLabel();
        String label = "";
        if (title != null && title.length() > 0) {
            label = label + title;
        }
        if (unit != null && unit.length() > 0) {
            label = label + " (" + unit + ")";
        }
        return label.trim();
    }
}

