/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart.binding;

import com.tridium.chart.BoundChartSpec;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChart;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BAxisSpec;
import javax.baja.chart.binding.BChartBinding;
import javax.baja.chart.binding.BChartBindingCollection;
import javax.baja.ui.BBinding;

public class BoundChartModel
extends ChartModel {
    public static Logger log = Logger.getLogger("chart.binding");
    private final ArrayList<ChartSpec> specs = new ArrayList();

    @Override
    public synchronized int getSpecCount() {
        if (this.specs == null) {
            return 0;
        }
        return this.specs.size();
    }

    @Override
    public synchronized ChartSpec getSpec(int index) {
        return this.specs.get(index);
    }

    public synchronized void removeAllSpecs() {
        this.specs.clear();
    }

    public void syncBindings() {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        chart.syncBindings();
    }

    public synchronized void doSyncBindings() {
        BChartBinding binding;
        int i;
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        BBinding[] allBindings = chart.getBindings();
        ArrayList<BBinding> boundBindings = new ArrayList<BBinding>(allBindings.length);
        for (int i2 = 0; i2 < allBindings.length; ++i2) {
            BBinding binding2 = allBindings[i2];
            if (!(binding2 instanceof BChartBinding) || !binding2.isBound()) continue;
            boundBindings.add(binding2);
        }
        int specCount = this.specs.size();
        int boundCount = boundBindings.size();
        for (i = specCount - 1; i >= 0; --i) {
            BoundChartSpec spec = (BoundChartSpec)this.specs.get(i);
            BChartBinding binding3 = spec.getBinding();
            boolean found = false;
            for (int j = 0; j < boundCount; ++j) {
                BChartBinding bound = (BChartBinding)((Object)boundBindings.get(j));
                if (binding3 != bound) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.specs.remove(i);
        }
        specCount = this.specs.size();
        for (i = boundCount - 1; i >= 0; --i) {
            binding = (BChartBinding)((Object)boundBindings.get(i));
            boolean found = false;
            for (int j = 0; j < specCount; ++j) {
                BoundChartSpec spec = (BoundChartSpec)this.specs.get(j);
                if (spec.getBinding() != binding) continue;
                found = true;
                break;
            }
            if (!found) continue;
            boundBindings.remove(i);
        }
        boundCount = boundBindings.size();
        for (i = 0; i < boundCount; ++i) {
            binding = (BChartBinding)((Object)boundBindings.get(i));
            this.addSpec(binding);
        }
        this.fireModelModified();
    }

    public synchronized void addSpec(BChartBinding binding) {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        if (!binding.isBound()) {
            return;
        }
        Series[] seriesSet = binding instanceof BChartBindingCollection ? ((BChartBindingCollection)binding).createSeriesSet() : new Series[]{binding.createSeries()};
        for (int i = 0; i < seriesSet.length; ++i) {
            BAxis check;
            BAxis check2;
            Series series = seriesSet[i];
            BAxis xaxis = null;
            if (chart.usesXAxis()) {
                xaxis = binding.getXAxis().toAxis(series, 0, BAxisDimension.x);
            }
            if (xaxis != null && (check2 = this.getChart().getPane().findAxis(xaxis)) != null) {
                xaxis = check2;
            }
            BAxis yaxis = null;
            if (chart.usesYAxis()) {
                BAxisSpec yAxisSpec = null;
                yAxisSpec = binding instanceof BChartBindingCollection ? ((BChartBindingCollection)binding).getYAxis(series) : binding.getYAxis();
                yaxis = yAxisSpec.toAxis(series, 1, BAxisDimension.y);
            }
            if (yaxis != null && (check = this.getChart().getPane().findAxis(yaxis)) != null) {
                if (check instanceof BDiscreteAxis) {
                    ((BDiscreteAxis)check).merge((BDiscreteAxis)yaxis);
                }
                yaxis = check;
            }
            BoundChartSpec spec = new BoundChartSpec(binding, series, xaxis, yaxis);
            spec.setModel(this);
            this.specs.add(spec);
        }
    }
}

