/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.celleditors;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BColorChooser;
import com.tridium.workbench.colorchooser.BGradientEditor;
import com.tridium.workbench.colorchooser.BImageEditor;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.celleditor.BWbCellEditor;

@NiagaraType(agent={@AgentOn(types={"gx:Brush"})})
public class BBrushCE
extends BWbCellEditor
implements BMenu.MenuCloseListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BBrushCE.class);
    private BBrush brush;
    private BBrushSwatch swatch;
    private SwatchController controller;
    private BLabel label;
    private BMenu menu;
    private RectGeom button = new RectGeom();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBrushCE() {
        this.swatch = new BBrushSwatch();
        this.add("swatch", (BValue)this.swatch);
        this.label = new BLabel();
        this.add("label", (BValue)this.label);
        this.label.setHalign(BHalign.left);
        this.controller = new SwatchController();
        this.swatch.setController(this.controller);
        this.menu = new BMenu();
        this.menu.add(null, (Command)new SolidCommand((BWidget)this));
        this.menu.add(null, (Command)new GradientCommand((BWidget)this));
        this.menu.add(null, (Command)new ImageCommand((BWidget)this));
        this.menu.add(null, (Command)new NullCommand((BWidget)this));
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        this.brush = (BBrush)value;
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        return this.brush;
    }

    public void computePreferredSize() {
        this.setPreferredSize(120.0, 10.0);
    }

    public void doLayout(BWidget[] children) {
        double h;
        double w = this.getWidth();
        double bw = h = this.getHeight();
        double bh = h - 4.0;
        BBrush br = this.brush;
        this.swatch.setBrush(br);
        if (br == null || br.isNull()) {
            this.label.setText("(default)");
        } else {
            BBrush.Paint paint = br.getPaint();
            if (paint instanceof BBrush.Solid) {
                this.label.setText(((BBrush.Solid)paint).getColor().toString());
            } else if (paint instanceof BBrush.Gradient) {
                this.label.setText("(gradient)");
            } else if (paint instanceof BBrush.Image) {
                this.label.setText("(image)");
            }
        }
        this.swatch.setBounds(2.0, 2.0, bw, bh);
        this.label.setBounds(bw + 6.0, 3.0, w - bw - bw - 12.0, bh);
        this.button.set(w - bw - 1.0, 3.0, bw - 2.0, bh - 2.0);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintChild(g, (BWidget)this.label);
        this.paintChild(g, this.swatch);
        if (!this.isReadonly()) {
            Theme.dropDown().paintButton(g, (BWidget)this, this.button, this.menu.isOpen());
        }
    }

    public void menuClosed(BMenu menu) {
        this.repaint();
    }

    public void mousePressed(BMouseEvent event) {
        this.cellSelected();
        if (this.isReadonly()) {
            return;
        }
        if (event.isButton1Down() && this.button.contains(event.getX(), event.getY())) {
            this.menu.computePreferredSize();
            double x = this.button.x + this.button.width - this.menu.getPreferredWidth() + 2.0;
            double y = this.button.y + this.button.height + 1.0;
            this.menu.open((BWidget)this, x, y);
            this.repaint();
        } else {
            this.controller.mousePressed(event);
        }
    }

    void doSolid() {
        BColor c;
        BBrush br = this.brush;
        BBrush.Paint paint = br.getPaint();
        BColor bColor = c = !br.isNull() && paint instanceof BBrush.Solid ? BColorChooser.openInDialog((BWidget)this, ((BBrush.Solid)paint).getColor()) : BColorChooser.openInDialog((BWidget)this);
        if (c != null) {
            this.brush = c.toBrush();
            this.setModified();
            this.relayout();
        }
    }

    void doGradient() {
        BBrush br = this.brush;
        BBrush.Paint paint = br.getPaint();
        BBrush bBrush = br = paint instanceof BBrush.Gradient ? BGradientEditor.openInDialog((BWidget)this, br) : BGradientEditor.openInDialog((BWidget)this, BBrush.NULL);
        if (br != null) {
            this.brush = br;
            this.setModified();
            this.relayout();
        }
    }

    void doImage() {
        BBrush br = this.brush;
        BBrush.Paint paint = br.getPaint();
        BBrush bBrush = br = paint instanceof BBrush.Image ? BImageEditor.openInDialog((BWidget)this, br) : BImageEditor.openInDialog((BWidget)this, BBrush.NULL);
        if (br != null) {
            BBrush.Paint p = br.getPaint();
            if (p instanceof BBrush.Image) {
                BImage img = ((BBrush.Image)p).getImage();
                img.sync();
                img.setBaseOrd(BWbShell.getWbShell((BWidget)this).getActiveOrd());
            }
            this.brush = br;
            this.setModified();
            this.relayout();
        }
    }

    void doNull() {
        this.brush = BBrush.NULL;
        this.setModified();
        this.relayout();
    }

    class NullCommand
    extends Command {
        public NullCommand(BWidget owner) {
            super(owner, "Null/Default");
        }

        public CommandArtifact doInvoke() {
            BBrushCE.this.doNull();
            return null;
        }
    }

    class ImageCommand
    extends Command {
        public ImageCommand(BWidget owner) {
            super(owner, "Image");
        }

        public CommandArtifact doInvoke() {
            BBrushCE.this.doImage();
            return null;
        }
    }

    class GradientCommand
    extends Command {
        public GradientCommand(BWidget owner) {
            super(owner, "Gradient");
        }

        public CommandArtifact doInvoke() {
            BBrushCE.this.doGradient();
            return null;
        }
    }

    class SolidCommand
    extends Command {
        public SolidCommand(BWidget owner) {
            super(owner, "Solid");
        }

        public CommandArtifact doInvoke() {
            BBrushCE.this.doSolid();
            return null;
        }
    }

    class SwatchController
    extends BBrushSwatch.Controller {
        SwatchController() {
        }

        @Override
        public void mousePressed(BMouseEvent event) {
            if (BBrushCE.this.isReadonly()) {
                return;
            }
            if (event.isButton1Down()) {
                BBrush br = BBrushCE.this.brush;
                BBrush.Paint paint = br.getPaint();
                if (paint instanceof BBrush.Solid) {
                    BBrushCE.this.doSolid();
                } else if (paint instanceof BBrush.Gradient) {
                    BBrushCE.this.doGradient();
                } else if (paint instanceof BBrush.Image) {
                    BBrushCE.this.doImage();
                }
            } else if (event.isButton3Down()) {
                BBrushCE.this.cellPopup(event);
            }
        }
    }
}

