/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.workbench.colorchooser.BBrushSwatch;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BScrollPane;

@NiagaraType
public class BBrushList
extends BWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BBrushList.class);
    private Controller controller = new Controller();
    private int cols = 8;
    private double swatchWidth = 15.0;
    private double swatchHeight = 15.0;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BWidget makeScroll(BBrush[] list) {
        return BBrushList.makeScroll(list, null);
    }

    public static BWidget makeScroll(BBrush[] list, Controller c) {
        BBrushList bl = new BBrushList(list);
        if (c != null) {
            bl.setController(c);
        }
        BScrollPane pane = new BScrollPane((BWidget)bl);
        return new BBorderPane((BWidget)pane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
    }

    public BBrushList() {
    }

    public BBrushList(BBrush[] list) {
        this.setList(list);
    }

    public void setList(BBrush[] list) {
        this.removeAll();
        for (int i = 0; i < list.length; ++i) {
            BBrushSwatch s = new BBrushSwatch(list[i]);
            s.setController(new SubController(s));
            this.add(null, (BValue)s);
        }
    }

    public void setColumns(int cols) {
        this.cols = cols;
    }

    public void setSwatchSize(double w, double h) {
        this.swatchWidth = w;
        this.swatchHeight = h;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller c) {
        this.controller = c;
    }

    public void computePreferredSize() {
        BWidget[] kids = this.getChildWidgets();
        int rows = kids.length / this.cols;
        if (kids.length % this.cols > 0) {
            ++rows;
        }
        double pw = (double)this.cols * (this.swatchWidth - 1.0) + 1.0;
        double ph = (double)rows * (this.swatchWidth - 1.0) + 1.0;
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        for (int j = 0; j < kids.length; ++j) {
            int row = j * this.cols;
            for (int i = 0; i < this.cols && row + i < kids.length; ++i) {
                kids[row + i].setBounds((double)i * (this.swatchWidth - 1.0), (double)j * (this.swatchHeight - 1.0), this.swatchWidth, this.swatchHeight);
            }
        }
    }

    public boolean isChildLegal(BComponent child) {
        if (!super.isChildLegal(child)) {
            return false;
        }
        return child instanceof BBrushSwatch;
    }

    class SubController
    extends BBrushSwatch.Controller {
        private BBrushSwatch swatch;

        public SubController(BBrushSwatch s) {
            this.swatch = s;
        }

        @Override
        public void mousePressed(BMouseEvent event) {
            BBrushList.this.controller.swatchPressed(this.swatch);
        }
    }

    public static class Controller {
        public void swatchPressed(BBrushSwatch swatch) {
        }
    }
}

