/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BBrushList;
import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BHueBar;
import com.tridium.workbench.colorchooser.BPaletteManager;
import com.tridium.workbench.colorchooser.BSatBrightBox;
import com.tridium.workbench.colorchooser.ColorModel;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSlider;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="rgbModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="hsbModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="xmlModified"), @NiagaraAction(name="nameModified"), @NiagaraAction(name="alphaModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BColorChooser
extends BEdgePane
implements ColorModel.Agent {
    @Generated
    public static final Action rgbModified = BColorChooser.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action hsbModified = BColorChooser.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action xmlModified = BColorChooser.newAction((int)0, null);
    @Generated
    public static final Action nameModified = BColorChooser.newAction((int)0, null);
    @Generated
    public static final Action alphaModified = BColorChooser.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BColorChooser.class);
    private static BModule module = Sys.getModuleForClass(BColorChooser.class);
    private static Lexicon lex = Lexicon.make((String)"wbutil");
    private ColorModel model;
    private boolean ignoreEvents = false;
    private boolean fromHsb = false;
    private boolean fromRgb = false;
    private boolean fromXml = false;
    private boolean fromName = false;
    private boolean fromAlpha = false;
    private BBrushSwatch swatch;
    private BTextField redField;
    private BTextField greField;
    private BTextField bluField;
    private BSlider redSlider;
    private BSlider greSlider;
    private BSlider bluSlider;
    private BTextField hueField;
    private BTextField satField;
    private BTextField briField;
    private BSlider hueSlider;
    private BSlider satSlider;
    private BSlider briSlider;
    private BTextField alphaField;
    private BSlider alphaSlider;
    private BCheckBox nullColor;
    private BTextField xmlField;
    private BTextDropDown nameField;
    private ArrayList<BBrush> customBrushes = new ArrayList();
    private BBrushList customBrushList;
    private Add addCommand;
    private BBrush[] defaultBrushList = new BBrush[]{BColor.make((int)-65536).toBrush(), BColor.make((int)-12582912).toBrush(), BColor.make((int)-8388608).toBrush(), BColor.make((int)-4194304).toBrush(), BColor.make((int)-49088).toBrush(), BColor.make((int)-32640).toBrush(), BColor.make((int)-16192).toBrush(), BColor.make((int)-16777216).toBrush(), BColor.make((int)Short.MIN_VALUE).toBrush(), BColor.make((int)-12574720).toBrush(), BColor.make((int)-8372224).toBrush(), BColor.make((int)-4235264).toBrush(), BColor.make((int)-24512).toBrush(), BColor.make((int)-16256).toBrush(), BColor.make((int)-8257).toBrush(), BColor.make((int)-14671840).toBrush(), BColor.make((int)-256).toBrush(), BColor.make((int)-12566528).toBrush(), BColor.make((int)-8355840).toBrush(), BColor.make((int)-4145152).toBrush(), BColor.make((int)-192).toBrush(), BColor.make((int)-128).toBrush(), BColor.make((int)-64).toBrush(), BColor.make((int)-12566464).toBrush(), BColor.make((int)-16711936).toBrush(), BColor.make((int)-16760832).toBrush(), BColor.make((int)-16744448).toBrush(), BColor.make((int)-16728064).toBrush(), BColor.make((int)-12517568).toBrush(), BColor.make((int)-8323200).toBrush(), BColor.make((int)-4128832).toBrush(), BColor.make((int)-10461088).toBrush(), BColor.make((int)-16711681).toBrush(), BColor.make((int)-16760768).toBrush(), BColor.make((int)-16744320).toBrush(), BColor.make((int)-16727872).toBrush(), BColor.make((int)-12517377).toBrush(), BColor.make((int)-8323073).toBrush(), BColor.make((int)-4128769).toBrush(), BColor.make((int)-8355712).toBrush(), BColor.make((int)-16776961).toBrush(), BColor.make((int)-16777152).toBrush(), BColor.make((int)-16777088).toBrush(), BColor.make((int)-16777024).toBrush(), BColor.make((int)-12566273).toBrush(), BColor.make((int)-8355585).toBrush(), BColor.make((int)-4144897).toBrush(), BColor.make((int)-4144960).toBrush(), BColor.make((int)-8388353).toBrush(), BColor.make((int)-14811072).toBrush(), BColor.make((int)-12844928).toBrush(), BColor.make((int)-10878784).toBrush(), BColor.make((int)-6667777).toBrush(), BColor.make((int)-4488961).toBrush(), BColor.make((int)-2244609).toBrush(), BColor.make((int)-2039584).toBrush(), BColor.make((int)-65281).toBrush(), BColor.make((int)-12582848).toBrush(), BColor.make((int)-8388480).toBrush(), BColor.make((int)-4194112).toBrush(), BColor.make((int)-48897).toBrush(), BColor.make((int)-32513).toBrush(), BColor.make((int)-16129).toBrush(), BColor.make((int)-1).toBrush()};

    @Generated
    public void rgbModified(BWidgetEvent parameter) {
        this.invoke(rgbModified, (BValue)parameter, null);
    }

    @Generated
    public void hsbModified(BWidgetEvent parameter) {
        this.invoke(hsbModified, (BValue)parameter, null);
    }

    @Generated
    public void xmlModified() {
        this.invoke(xmlModified, null, null);
    }

    @Generated
    public void nameModified() {
        this.invoke(nameModified, null, null);
    }

    @Generated
    public void alphaModified(BWidgetEvent parameter) {
        this.invoke(alphaModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BColor openInDialog(BWidget owner) {
        return BColorChooser.openInDialog(owner, BColor.NULL);
    }

    public static BColor openInDialog(BWidget owner, BColor color) {
        return BColorChooser.openInDialog(owner, BColorChooser.text("title"), color);
    }

    public static BColor openInDialog(BWidget owner, String title, BColor color) {
        BColorChooser chooser = new BColorChooser(color);
        if (1 == BDialog.open((BWidget)owner, (String)title, (Object)new BBorderPane((BWidget)chooser), (int)3)) {
            return chooser.model.toRGB();
        }
        return null;
    }

    public BColorChooser() {
        this(BColor.NULL);
    }

    public BColorChooser(BColor c) {
        Object[] obj = this.getColors().getChildren(BBrush.class);
        for (int i = 0; i < obj.length; ++i) {
            this.customBrushes.add((BBrush)obj[i]);
        }
        this.model = new ColorModel();
        BSatBrightBox box = new BSatBrightBox(this.model);
        BHueBar bar = new BHueBar(this.model);
        this.swatch = new BBrushSwatch();
        this.swatch.setPreferredSize(48.0, 48.0);
        this.redSlider = new BSlider();
        this.greSlider = new BSlider();
        this.bluSlider = new BSlider();
        BGridPane all = new BGridPane(3);
        all.add(null, (BValue)new BLabel(BColorChooser.text("hue"), BHalign.right));
        this.hueField = new BTextField("", 4);
        all.add(null, (BValue)this.hueField);
        all.add(null, (BValue)new BLabel("\u00b0"));
        all.add(null, (BValue)new BLabel(BColorChooser.text("saturation"), BHalign.right));
        this.satField = new BTextField("", 4);
        all.add(null, (BValue)this.satField);
        all.add(null, (BValue)new BLabel("%"));
        all.add(null, (BValue)new BLabel(BColorChooser.text("brightness"), BHalign.right));
        this.briField = new BTextField("", 4);
        all.add(null, (BValue)this.briField);
        all.add(null, (BValue)new BLabel("%"));
        all.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 4.0, 0.0, 0.0, 0.0));
        all.add(null, (BValue)new BNullWidget());
        all.add(null, (BValue)new BNullWidget());
        all.add(null, (BValue)new BLabel(BColorChooser.text("red"), BHalign.right));
        this.redField = new BTextField("", 4);
        all.add(null, (BValue)this.redField);
        all.add(null, (BValue)new BNullWidget());
        all.add(null, (BValue)new BLabel(BColorChooser.text("green"), BHalign.right));
        this.greField = new BTextField("", 4);
        all.add(null, (BValue)this.greField);
        all.add(null, (BValue)new BNullWidget());
        all.add(null, (BValue)new BLabel(BColorChooser.text("blue"), BHalign.right));
        this.bluField = new BTextField("", 4);
        all.add(null, (BValue)this.bluField);
        all.add(null, (BValue)new BNullWidget());
        all.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 4.0, 0.0, 0.0, 0.0));
        all.add(null, (BValue)new BNullWidget());
        all.add(null, (BValue)new BNullWidget());
        all.add(null, (BValue)new BLabel(BColorChooser.text("alpha"), BHalign.right));
        this.alphaField = new BTextField("", 4);
        all.add(null, (BValue)this.alphaField);
        all.add(null, (BValue)new BLabel("%"));
        this.hueSlider = new BSlider();
        this.satSlider = new BSlider();
        this.briSlider = new BSlider();
        this.alphaSlider = new BSlider();
        BGridPane xml = new BGridPane(2);
        xml.add(null, (BValue)new BLabel(BColorChooser.text("hex")));
        this.xmlField = new BTextField("", 10);
        xml.add(null, (BValue)this.xmlField);
        xml.add(null, (BValue)new BLabel(BColorChooser.text("name")));
        this.nameField = new BTextDropDown("", 10, true);
        xml.add(null, (BValue)this.nameField);
        BList list = this.nameField.getList();
        list.setRenderer((ListRenderer)new ColorRenderer());
        BColor[] colors = BColor.getConstants();
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i].isNull()) continue;
            list.addItem((Object)colors[i].toString());
        }
        BToolBar customToolbar = new BToolBar();
        this.addCommand = new Add((BWidget)this);
        customToolbar.add(null, (Command)this.addCommand);
        customToolbar.add(null, (Command)new Manage((BWidget)this));
        this.customBrushList = new BBrushList(this.getCustomList());
        this.customBrushList.setController(new CustomBrushListController());
        BScrollPane scroll = new BScrollPane((BWidget)this.customBrushList);
        BBorderPane z = new BBorderPane((BWidget)scroll, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        BGridPane gridLists = new BGridPane(1);
        gridLists.setStretchRow(2);
        gridLists.setRowAlign(BValign.fill);
        gridLists.add(null, (BValue)BBrushList.makeScroll(this.defaultBrushList, new DefaultBrushListController()));
        gridLists.add(null, (BValue)customToolbar);
        BEdgePane lists = new BEdgePane();
        lists.setTop((BWidget)gridLists);
        lists.setCenter((BWidget)z);
        BGridPane controls = new BGridPane(1);
        controls.setValign(BValign.top);
        controls.setRowGap(10.0);
        controls.add(null, (BValue)new BBorderPane((BWidget)this.swatch, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        controls.add(null, (BValue)all);
        controls.add(null, (BValue)xml);
        this.nullColor = new BCheckBox((ToggleCommand)new NullCommand());
        controls.add(null, (BValue)this.nullColor);
        BGridPane top = new BGridPane(4);
        top.setColumnGap(20.0);
        top.setRowAlign(BValign.fill);
        top.add(null, (BValue)lists);
        top.add(null, (BValue)box);
        top.add(null, (BValue)bar);
        top.add(null, (BValue)controls);
        this.setCenter((BWidget)top);
        this.linkTo((BComponent)this.redField, (Slot)BTextField.textModified, (Slot)rgbModified);
        this.linkTo((BComponent)this.greField, (Slot)BTextField.textModified, (Slot)rgbModified);
        this.linkTo((BComponent)this.bluField, (Slot)BTextField.textModified, (Slot)rgbModified);
        this.linkTo((BComponent)this.hueField, (Slot)BTextField.textModified, (Slot)hsbModified);
        this.linkTo((BComponent)this.satField, (Slot)BTextField.textModified, (Slot)hsbModified);
        this.linkTo((BComponent)this.briField, (Slot)BTextField.textModified, (Slot)hsbModified);
        this.linkTo((BComponent)this.alphaField, (Slot)BTextField.textModified, (Slot)alphaModified);
        this.linkTo((BComponent)this.xmlField, (Slot)BTextField.textModified, (Slot)xmlModified);
        this.linkTo((BComponent)this.nameField.getEditor(), (Slot)BTextField.textModified, (Slot)nameModified);
        this.model.setWithAlpha(c);
        if (c.isNull()) {
            this.model.setAlpha(1.0f);
            this.model.setNull(true);
        }
        this.model.addAgent(this);
        this.colorChanged();
        if (this.customBrushes.size() >= 88) {
            this.addCommand.setEnabled(false);
        }
    }

    private BBrush[] getCustomList() {
        return this.customBrushes.toArray(new BBrush[0]);
    }

    @Override
    public void colorChanged() {
        this.ignoreEvents = true;
        this.swatch.setBrush(this.model.toRGB().toBrush());
        int h = Math.round(this.model.getHue() * 360.0f);
        int s = Math.round(this.model.getSat() * 100.0f);
        int b = Math.round(this.model.getBri() * 100.0f);
        this.hueSlider.setValue((double)h);
        this.satSlider.setValue((double)s);
        this.briSlider.setValue((double)b);
        if (!this.fromHsb) {
            this.hueField.setText(Integer.toString(h));
            this.satField.setText(Integer.toString(s));
            this.briField.setText(Integer.toString(b));
        }
        BColor c = this.model.toRGB();
        int r = c.getRed();
        int g = c.getGreen();
        b = c.getBlue();
        this.redSlider.setValue((double)r);
        this.greSlider.setValue((double)g);
        this.bluSlider.setValue((double)b);
        if (!this.fromRgb) {
            this.redField.setText(Integer.toString(r));
            this.greField.setText(Integer.toString(g));
            this.bluField.setText(Integer.toString(b));
        }
        int a = Math.round(this.model.getAlpha() * 100.0f);
        this.alphaSlider.setValue((double)a);
        if (!this.fromAlpha) {
            this.alphaField.setText(Integer.toString(a));
        }
        this.nullColor.setSelected(this.model.isNull());
        if (!this.fromXml) {
            String hex = Integer.toHexString(c.getRGB());
            if (hex.length() == 1) {
                hex = "00000000";
            } else if (hex.length() == 7) {
                hex = "0" + hex;
            } else if (hex.length() == 6) {
                hex = "00" + hex;
            }
            this.xmlField.setText("#" + hex);
        }
        if (!this.fromName) {
            String str = c.toString();
            this.nameField.getEditor().getSelection().deselect();
            this.nameField.setText(c.isNull() ? "" : (BColor.getConstant((String)str) == null ? "" : str));
        }
        this.ignoreEvents = false;
        this.fromHsb = false;
        this.fromRgb = false;
        this.fromXml = false;
        this.fromName = false;
        this.fromAlpha = false;
        this.repaint();
    }

    public void doRgbModified(BWidgetEvent event) {
        if (this.ignoreEvents) {
            return;
        }
        BWidget source = event.getWidget();
        BColor c = this.model.toRGB();
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        try {
            if (source == this.redSlider) {
                red = (int)this.redSlider.getValue();
            } else if (source == this.greSlider) {
                green = (int)this.greSlider.getValue();
            } else if (source == this.bluSlider) {
                blue = (int)this.bluSlider.getValue();
            } else if (source == this.redField) {
                red = Integer.parseInt(this.redField.getText());
                this.fromRgb = true;
            } else if (source == this.greField) {
                green = Integer.parseInt(this.greField.getText());
                this.fromRgb = true;
            } else if (source == this.bluField) {
                blue = Integer.parseInt(this.bluField.getText());
                this.fromRgb = true;
            }
            this.model.set(BColor.make((int)red, (int)green, (int)blue));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doHsbModified(BWidgetEvent event) {
        if (this.ignoreEvents) {
            return;
        }
        BWidget source = event.getWidget();
        float hue = this.model.getHue();
        float sat = this.model.getSat();
        float bri = this.model.getBri();
        try {
            if (source == this.hueSlider) {
                hue = (float)this.hueSlider.getValue() / 360.0f;
            } else if (source == this.satSlider) {
                sat = (float)this.satSlider.getValue() / 100.0f;
            } else if (source == this.briSlider) {
                bri = (float)this.briSlider.getValue() / 100.0f;
            } else if (source == this.hueField) {
                hue = (float)Integer.parseInt(this.hueField.getText()) / 360.0f;
                this.fromHsb = true;
            } else if (source == this.satField) {
                sat = (float)Integer.parseInt(this.satField.getText()) / 100.0f;
                this.fromHsb = true;
            } else if (source == this.briField) {
                bri = (float)Integer.parseInt(this.briField.getText()) / 100.0f;
                this.fromHsb = true;
            }
            this.model.set(hue, sat, bri);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doAlphaModified(BWidgetEvent event) {
        if (this.ignoreEvents) {
            return;
        }
        BWidget source = event.getWidget();
        if (source == this.alphaSlider) {
            float alpha = (float)this.alphaSlider.getValue() / 100.0f;
            this.model.setAlpha(alpha);
        } else if (source == this.alphaField) {
            try {
                float alpha = (float)Integer.parseInt(this.alphaField.getText()) / 100.0f;
                this.model.setAlpha(alpha);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doXmlModified() {
        if (this.ignoreEvents) {
            return;
        }
        try {
            String s = this.xmlField.getText();
            if (!s.startsWith("#")) {
                s = "#" + s;
            }
            BColor c = BColor.make((String)s);
            this.fromXml = true;
            this.model.setWithAlpha(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doNameModified() {
        if (this.ignoreEvents) {
            return;
        }
        try {
            String s = this.nameField.getText();
            BColor c = BColor.getConstant((String)s);
            if (c != null) {
                this.fromName = true;
                this.model.setWithAlpha(c);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BOptions getColors() {
        return BOptions.load((String)"colors", (Type)BOptions.TYPE);
    }

    private static String text(String s) {
        return lex.getText("colorChooser." + s);
    }

    class Manage
    extends Command {
        public Manage(BWidget owner) {
            super(owner, module, "colorChooser.manage");
        }

        public CommandArtifact doInvoke() {
            BBrush[] list = BPaletteManager.openInDialog(this.getOwner(), BColorChooser.this.getCustomList());
            if (list != null) {
                BColorChooser.this.customBrushes.clear();
                BOptions colors = BColorChooser.this.getColors();
                colors.removeAll();
                for (int i = 0; i < list.length; ++i) {
                    BColorChooser.this.customBrushes.add(list[i]);
                    colors.add(null, (BValue)list[i]);
                }
                colors.save();
                BColorChooser.this.customBrushList.setList(list);
                BColorChooser.this.customBrushList.relayout();
                if (BColorChooser.this.customBrushes.size() < 88) {
                    BColorChooser.this.addCommand.setEnabled(true);
                }
            }
            return null;
        }
    }

    class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, module, "colorChooser.add");
        }

        public CommandArtifact doInvoke() {
            BBrush b = BColorChooser.this.model.toRGB().toBrush();
            BColorChooser.this.getColors().add(null, (BValue)b);
            BColorChooser.this.getColors().save();
            BColorChooser.this.customBrushes.add(b);
            BColorChooser.this.customBrushList.setList(BColorChooser.this.getCustomList());
            if (BColorChooser.this.customBrushes.size() >= 88) {
                BColorChooser.this.addCommand.setEnabled(false);
            }
            return null;
        }
    }

    class CustomBrushListController
    extends BBrushList.Controller {
        CustomBrushListController() {
        }

        @Override
        public void swatchPressed(BBrushSwatch swatch) {
            BBrush b = swatch.getBrush();
            if (b.getPaint() instanceof BBrush.Solid) {
                BColorChooser.this.model.setWithAlpha(((BBrush.Solid)b.getPaint()).getColor());
            }
        }
    }

    class DefaultBrushListController
    extends BBrushList.Controller {
        DefaultBrushListController() {
        }

        @Override
        public void swatchPressed(BBrushSwatch swatch) {
            BBrush b = swatch.getBrush();
            if (b.getPaint() instanceof BBrush.Solid) {
                BColorChooser.this.model.set(((BBrush.Solid)b.getPaint()).getColor());
            }
        }
    }

    class NullCommand
    extends ToggleCommand {
        public NullCommand() {
            super((BWidget)BColorChooser.this, BColorChooser.text("useNullColor"));
        }

        public CommandArtifact doInvoke() {
            if (!BColorChooser.this.ignoreEvents) {
                BColorChooser.this.model.setNull(this.isSelected());
            }
            return null;
        }
    }

    class ColorRenderer
    extends ListRenderer {
        ColorRenderer() {
        }

        public void paintItem(Graphics g, ListRenderer.Item item) {
            double h;
            this.paintItemBackground(g, item);
            String s = (String)item.value;
            double w = h = this.getItemHeight();
            g.setBrush(BColor.getConstant((String)s).toBrush());
            g.fillRect(2.0, 2.0, w - 4.0, h - 4.0);
            g.setBrush(BColor.black);
            g.strokeRect(2.0, 2.0, w - 4.0, h - 4.0);
            BFont f = Theme.table().getCellFont();
            g.setFont(f);
            g.drawString(s, w + 3.0, f.getAscent() + 2.0);
        }

        public double getPreferredItemWidth(ListRenderer.Item item) {
            BFont f = Theme.table().getCellFont();
            return f.width(item.value.toString()) + this.getItemHeight() + 17.0;
        }
    }
}

