/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.workbench.fieldeditors.BOrdFE;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="tileChanged")
public class BImageEditor
extends BEdgePane {
    @Generated
    public static final Action tileChanged = BImageEditor.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BImageEditor.class);
    static Lexicon lexicon = Lexicon.make((String)"wbutil");
    static BBrush defaultBrush = BBrush.make((String)"image(source(null))");
    BBrush brush;
    BOrdFE source = new BOrdFE();
    BListDropDown tile = new BListDropDown();
    BListDropDown halign = new BListDropDown();
    BListDropDown valign = new BListDropDown();

    @Generated
    public void tileChanged() {
        this.invoke(tileChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BBrush openInDialog(BWidget owner, BBrush brush) {
        BImageEditor editor = new BImageEditor(brush);
        if (1 == BDialog.open((BWidget)owner, (String)BImageEditor.text("imageEditor"), (Object)new BBorderPane((BWidget)editor), (int)3)) {
            return editor.getBrush();
        }
        return null;
    }

    public BImageEditor() {
        this(BBrush.NULL);
    }

    public BImageEditor(BBrush b) {
        this.brush = b.isNull() ? defaultBrush : b;
        BBrush.Image paint = (BBrush.Image)this.brush.getPaint();
        BOrd ord = b.isNull() ? BOrd.NULL : paint.getImage().getOrdList().get(0);
        BFacets facets = BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:IFile"));
        this.source.loadValue((BObject)ord, (Context)facets);
        this.buildTile();
        this.buildHalign();
        this.buildValign();
        this.loadTile(paint);
        this.loadHalign(paint);
        this.loadValign(paint);
        BGridPane g1 = new BGridPane(2);
        g1.add(null, (BValue)BImageEditor.label("tile"));
        g1.add(null, (BValue)this.tile);
        BGridPane g2 = new BGridPane(2);
        g2.add(null, (BValue)BImageEditor.label("halign"));
        g2.add(null, (BValue)this.constrain((BWidget)this.halign));
        BGridPane g3 = new BGridPane(2);
        g3.add(null, (BValue)BImageEditor.label("valign"));
        g3.add(null, (BValue)this.constrain((BWidget)this.valign));
        BGridPane other = new BGridPane(3);
        other.setColumnGap(10.0);
        other.add(null, (BValue)g1);
        other.add(null, (BValue)g2);
        other.add(null, (BValue)g3);
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)this.source);
        grid.add(null, (BValue)other);
        this.setCenter((BWidget)grid);
        this.doTileChanged();
        this.linkTo(null, (BComponent)this.tile, (Slot)BListDropDown.valueModified, (Slot)tileChanged);
    }

    BConstrainedPane constrain(BWidget w) {
        w.computePreferredSize();
        BConstrainedPane cons = new BConstrainedPane(w);
        cons.setMinWidth(w.getPreferredWidth());
        return cons;
    }

    public void doTileChanged() {
        int n = this.tile.getList().getSelectedIndex();
        switch (n) {
            case 0: {
                this.halign.setEnabled(true);
                this.buildHalign();
                this.valign.setEnabled(true);
                this.buildValign();
                break;
            }
            case 1: {
                this.halign.setEnabled(false);
                this.halign.getList().removeAllItems();
                this.valign.setEnabled(false);
                this.valign.getList().removeAllItems();
                break;
            }
            case 2: {
                this.halign.getList().removeAllItems();
                this.halign.setEnabled(false);
                this.valign.setEnabled(true);
                this.buildValign();
                break;
            }
            case 3: {
                this.halign.setEnabled(true);
                this.buildHalign();
                this.valign.getList().removeAllItems();
                this.valign.setEnabled(false);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void buildTile() {
        this.tile.getList().addItem((Object)BImageEditor.text("tileFalse"));
        this.tile.getList().addItem((Object)BImageEditor.text("tileTrue"));
        this.tile.getList().addItem((Object)BImageEditor.text("tileX"));
        this.tile.getList().addItem((Object)BImageEditor.text("tileY"));
    }

    void buildHalign() {
        this.halign.getList().removeAllItems();
        this.halign.getList().addItem((Object)BImageEditor.text("halignLeft"));
        this.halign.getList().addItem((Object)BImageEditor.text("halignCenter"));
        this.halign.getList().addItem((Object)BImageEditor.text("halignRight"));
    }

    void buildValign() {
        this.valign.getList().removeAllItems();
        this.valign.getList().addItem((Object)BImageEditor.text("valignTop"));
        this.valign.getList().addItem((Object)BImageEditor.text("valignCenter"));
        this.valign.getList().addItem((Object)BImageEditor.text("valignBottom"));
    }

    void loadTile(BBrush.Image paint) {
        switch (paint.getTile()) {
            case 0: {
                this.tile.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.tile.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.tile.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.tile.setSelectedIndex(3);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void loadHalign(BBrush.Image paint) {
        switch (paint.getHalign()) {
            case 3: {
                this.halign.setSelectedIndex(0);
                break;
            }
            case 0: {
                this.halign.setSelectedIndex(1);
                break;
            }
            case 4: {
                this.halign.setSelectedIndex(2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void loadValign(BBrush.Image paint) {
        switch (paint.getValign()) {
            case 1: {
                this.valign.setSelectedIndex(0);
                break;
            }
            case 0: {
                this.valign.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.valign.setSelectedIndex(2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    int unloadHalign() {
        switch (this.halign.getSelectedIndex()) {
            case 0: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
        }
        throw new IllegalStateException();
    }

    int unloadValign() {
        switch (this.valign.getSelectedIndex()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalStateException();
    }

    public BBrush getBrush() {
        try {
            switch (this.tile.getSelectedIndex()) {
                case 0: {
                    return BBrush.makeImage((BImage)BImage.make((BOrd)((BOrd)this.source.saveValue())), (int)0, (int)this.unloadHalign(), (int)this.unloadValign());
                }
                case 1: {
                    return BBrush.makeImage((BImage)BImage.make((BOrd)((BOrd)this.source.saveValue())), (int)1, (int)0, (int)0);
                }
                case 2: {
                    return BBrush.makeImage((BImage)BImage.make((BOrd)((BOrd)this.source.saveValue())), (int)2, (int)0, (int)this.unloadValign());
                }
                case 3: {
                    return BBrush.makeImage((BImage)BImage.make((BOrd)((BOrd)this.source.saveValue())), (int)3, (int)this.unloadHalign(), (int)0);
                }
            }
            throw new IllegalStateException();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    static String text(String attr) {
        return lexicon.getText("imageEditor." + attr);
    }

    static BLabel label(String attr) {
        return new BLabel(lexicon.getText("imageEditor." + attr));
    }
}

