/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import java.awt.Color;
import java.util.ArrayList;
import javax.baja.gx.BColor;

public class ColorModel {
    private ArrayList<Agent> agents = new ArrayList();
    private float[] array = new float[3];
    private float hue = 0.0f;
    private float sat = 0.0f;
    private float bri = 0.0f;
    private float alpha = 1.0f;
    private boolean isNull = false;

    public float getHue() {
        return this.isNull ? 0.0f : this.hue;
    }

    public float getSat() {
        return this.isNull ? 0.0f : this.sat;
    }

    public float getBri() {
        return this.isNull ? 0.0f : this.bri;
    }

    public float getAlpha() {
        return this.isNull ? 0.0f : this.alpha;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public BColor toRGB() {
        if (this.isNull) {
            return BColor.NULL;
        }
        Color c = Color.getHSBColor(this.hue, this.sat, this.bri);
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = Math.round(this.alpha * 255.0f);
        return BColor.make((int)r, (int)g, (int)b, (int)a);
    }

    public void set(BColor c) {
        this.array = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), this.array);
        this.set(this.array[0], this.array[1], this.array[2]);
    }

    public void setWithAlpha(BColor c) {
        this.array = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), this.array);
        this.isNull = false;
        this.hue = this.array[0];
        this.sat = this.array[1];
        this.bri = this.array[2];
        this.alpha = (float)c.getAlpha() / 255.0f;
        this.fireColorChanged();
    }

    public void set(float h, float s, float b) {
        this.isNull = false;
        this.hue = h;
        this.sat = s;
        this.bri = b;
        this.fireColorChanged();
    }

    public void setAlpha(float a) {
        this.isNull = false;
        this.alpha = a;
        this.fireColorChanged();
    }

    public void setNull(boolean b) {
        this.isNull = b;
        this.fireColorChanged();
    }

    public void addAgent(Agent a) {
        this.agents.add(a);
    }

    public void removeAgent(Agent a) {
        this.agents.remove(a);
    }

    public void fireColorChanged() {
        for (int i = 0; i < this.agents.size(); ++i) {
            Agent a = this.agents.get(i);
            a.colorChanged();
        }
    }

    public static interface Agent {
        public void colorChanged();
    }
}

