/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BExpirationFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BExpirationFE.class);
    static final Lexicon lex = Lexicon.make(BExpirationFE.class);
    ToggleCommand cmdNever;
    ToggleCommand cmdDate;
    BAbsTimeFE editor;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BExpirationFE() {
        ToggleCommandGroup toggles = new ToggleCommandGroup();
        this.cmdNever = new NeverToggle((BWidget)this);
        toggles.add(this.cmdNever);
        this.cmdDate = new DateToggle((BWidget)this);
        toggles.add(this.cmdDate);
        BRadioButton never = new BRadioButton(this.cmdNever);
        BRadioButton date = new BRadioButton(this.cmdDate);
        this.editor = new BAbsTimeFE();
        BGridPane pane = new BGridPane(3);
        pane.add(null, (BValue)new BBorderPane((BWidget)never, 0.0, 10.0, 0.0, 0.0));
        pane.add(null, (BValue)date);
        pane.add(null, (BValue)this.editor);
        this.setContent((BWidget)pane);
        this.linkTo(null, (BComponent)never, (Slot)BRadioButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)date, (Slot)BRadioButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.editor, (Slot)BAbsTimeFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.editor, (Slot)BAbsTimeFE.actionPerformed, (Slot)actionPerformed);
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        BAbsTimeFE fe = new BAbsTimeFE();
        fe.computePreferredSize();
        this.setPreferredSize(this.getPreferredWidth(), fe.getPreferredHeight());
    }

    protected void doSetReadonly(boolean readonly) {
        this.cmdNever.setEnabled(!readonly);
        this.cmdDate.setEnabled(!readonly);
        this.updateEditorState();
    }

    protected void doLoadValue(BObject value, Context cx) {
        BAbsTime time = (BAbsTime)value;
        if (time.isNull()) {
            this.cmdNever.setSelected(true);
            BAbsTime now = Clock.time().timeOfDay(23, 59, 0, 0);
            this.editor.loadValue((BObject)now);
        } else {
            this.cmdDate.setSelected(true);
            this.editor.loadValue((BObject)time);
        }
        this.updateEditorState();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.cmdNever.isSelected()) {
            return BAbsTime.NULL;
        }
        BAbsTime time = (BAbsTime)this.editor.saveValue();
        return time;
    }

    void updateEditorState() {
        if (this.editor != null) {
            this.editor.setReadonly(this.isReadonly() || this.cmdNever.isSelected());
        }
    }

    class DateToggle
    extends ToggleCommand {
        DateToggle(BWidget owner) {
            super(owner, lex.getText("expiresOn"));
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BExpirationFE.this.updateEditorState();
        }
    }

    class NeverToggle
    extends ToggleCommand {
        NeverToggle(BWidget owner) {
            super(owner, lex.getText("neverExpires"));
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BExpirationFE.this.updateEditorState();
        }
    }
}

