/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.tag.Id;
import javax.baja.tagdictionary.TagRule;

public class TagRuleIndex {
    private final Map<Id, Set<TagRule>> index = new ConcurrentHashMap<Id, Set<TagRule>>();
    private static final Logger logger = Logger.getLogger("tagdictionary");

    public void put(Id id, Set<TagRule> rules) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(rules, "rules");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TagRuleIndex: replacing all tag rules for id " + id + " with " + Arrays.toString(rules.toArray()));
        }
        this.index.put(id, rules);
    }

    public void add(Id id, TagRule rule) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(rule, "rule");
        this.index.compute(id, (k, v) -> {
            if (v == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("TagRuleIndex: adding the first rule " + rule + " for " + id);
                }
                v = new HashSet<TagRule>();
                v.add(rule);
            } else {
                boolean isNew = v.add(rule);
                if (isNew && logger.isLoggable(Level.FINE)) {
                    logger.fine("TagRuleIndex: adding new rule " + rule + " for " + id);
                }
            }
            return v;
        });
    }

    public void clear() {
        logger.finer("TagRuleIndex: clearing all");
        this.index.clear();
    }

    public void remove(Id id) {
        Objects.requireNonNull(id, "id");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TagRuleIndex: removing " + id);
        }
        this.index.remove(id);
    }

    public Optional<Set<TagRule>> get(Id id) {
        Objects.requireNonNull(id, "id");
        return Optional.ofNullable(this.index.get(id));
    }

    public boolean contains(Id id) {
        Objects.requireNonNull(id, "id");
        return this.index.containsKey(id);
    }

    public Set<Id> getIndexedIds() {
        return new HashSet<Id>(this.index.keySet());
    }
}

