/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.tagdictionary.condition.BNever;
import com.tridium.tagdictionary.util.ImportUtil;
import com.tridium.tagdictionary.util.TagDictionaryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.collection.FilteredIterator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BRelationInfoList;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.tagdictionary.BTagRuleList;
import javax.baja.tagdictionary.TagRule;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="condition", type="BTagRuleCondition", defaultValue="new BNever()"), @NiagaraProperty(name="tagList", type="BTagInfoList", defaultValue="new BTagInfoList()"), @NiagaraProperty(name="tagGroupList", type="BTagGroupInfoList", defaultValue="new BTagGroupInfoList()"), @NiagaraProperty(name="relationList", type="BRelationInfoList", defaultValue="new BRelationInfoList()")})
public class BTagRule
extends BComponent
implements TagRule,
BIRestrictedComponent {
    @Generated
    public static final Property condition = BTagRule.newProperty((int)0, (BValue)new BNever(), null);
    @Generated
    public static final Property tagList = BTagRule.newProperty((int)0, (BValue)new BTagInfoList(), null);
    @Generated
    public static final Property tagGroupList = BTagRule.newProperty((int)0, (BValue)new BTagGroupInfoList(), null);
    @Generated
    public static final Property relationList = BTagRule.newProperty((int)0, (BValue)new BRelationInfoList(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTagRule.class);

    @Generated
    public BTagRuleCondition getCondition() {
        return (BTagRuleCondition)this.get(condition);
    }

    @Generated
    public void setCondition(BTagRuleCondition v) {
        this.set(condition, (BValue)v, null);
    }

    @Generated
    public BTagInfoList getTagList() {
        return (BTagInfoList)this.get(tagList);
    }

    @Generated
    public void setTagList(BTagInfoList v) {
        this.set(tagList, (BValue)v, null);
    }

    @Generated
    public BTagGroupInfoList getTagGroupList() {
        return (BTagGroupInfoList)this.get(tagGroupList);
    }

    @Generated
    public void setTagGroupList(BTagGroupInfoList v) {
        this.set(tagGroupList, (BValue)v, null);
    }

    @Generated
    public BRelationInfoList getRelationList() {
        return (BRelationInfoList)this.get(relationList);
    }

    @Generated
    public void setRelationList(BRelationInfoList v) {
        this.set(relationList, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTagRule() {
    }

    public BTagRule(BTagRuleCondition cond) {
        this.setCondition(cond);
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context context) {
        if (!(parent instanceof BTagRuleList)) {
            TagDictionaryUtil.handleIllegalParent(parent, this, context);
        }
    }

    @Override
    public Predicate<Entity> getRuleCondition() {
        return this.getCondition();
    }

    @Override
    public boolean containsTagId(Id id) {
        return this.getTag(id).isPresent();
    }

    @Override
    public Optional<TagInfo> getTag(Id id) {
        Optional<TagInfo> found = this.getTagList().getTag(id);
        if (found.isPresent()) {
            return found;
        }
        SlotCursor tagGroupInfos = this.getTagGroupList().getProperties();
        while (tagGroupInfos.next(TagGroupInfo.class)) {
            TagGroupInfo tagGroupInfo = (TagGroupInfo)tagGroupInfos.get();
            if (tagGroupInfo.getGroupId().equals((Object)id)) {
                return tagGroupInfo.getNameTagInfo();
            }
            Iterator tagInfos = tagGroupInfo.getTags();
            while (tagInfos.hasNext()) {
                TagInfo tagInfo = (TagInfo)tagInfos.next();
                if (!tagInfo.getTagId().equals((Object)id)) continue;
                return Optional.of(tagInfo);
            }
        }
        return Optional.empty();
    }

    @Override
    public Collection<TagInfo> getTags() {
        ArrayList<TagInfo> result = new ArrayList<TagInfo>();
        SlotCursor c = this.getTagList().getProperties();
        while (c.next(TagInfo.class)) {
            result.add((TagInfo)c.get());
        }
        return result;
    }

    @Override
    public Collection<TagGroupInfo> getTagGroups() {
        ArrayList<TagGroupInfo> result = new ArrayList<TagGroupInfo>();
        SlotCursor c = this.getTagGroupList().getProperties();
        while (c.next(TagGroupInfo.class)) {
            result.add((TagGroupInfo)c.get());
        }
        return result;
    }

    @Override
    public boolean containsRelationId(Id id) {
        SlotCursor c = this.getRelationList().getProperties();
        while (c.next(RelationInfo.class)) {
            RelationInfo rel = (RelationInfo)c.get();
            if (!rel.getRelationId().equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<RelationInfo> getRelations(Id id) {
        Predicate<RelationInfo> idFilter = rel -> rel.getRelationId().equals((Object)id);
        return new FilteredIterator(idFilter, this.getRelationList().iterator());
    }

    @Override
    public Collection<RelationInfo> getRelations() {
        ArrayList<RelationInfo> result = new ArrayList<RelationInfo>();
        SlotCursor c = this.getRelationList().getProperties();
        while (c.next(RelationInfo.class)) {
            result.add((RelationInfo)c.get());
        }
        return result;
    }

    public void encodeToJson(JSONWriter writer) {
        writer.key("condition");
        writer.object();
        BTagRuleCondition tagRuleCondition = this.getCondition();
        writer.key("type").value((Object)tagRuleCondition.getType());
        tagRuleCondition.encodeToJson(writer);
        writer.endObject();
        if (!this.getTags().isEmpty()) {
            writer.key("tags");
            this.getTagList().encodeToJson(writer);
        }
        if (!this.getTagGroups().isEmpty()) {
            writer.key("tagGroups");
            this.getTagGroupList().encodeToJson(writer);
        }
        if (!this.getRelations().isEmpty()) {
            writer.key("relations");
            this.getRelationList().encodeToJson(writer);
        }
    }

    public void decodeFromJson(JSONObject tagRuleJson) {
        JSONObject conditionJson = tagRuleJson.getJSONObject("condition");
        TypeInfo conditionType = ImportUtil.decodeType(conditionJson.getString("type"), BTagRuleCondition.TYPE);
        BTagRuleCondition tagRuleCondition = (BTagRuleCondition)conditionType.getInstance();
        tagRuleCondition.decodeFromJson(conditionJson);
        this.setCondition(tagRuleCondition);
        JSONArray jsonArray = tagRuleJson.optJSONArray("tags");
        BTagInfoList tagInfoList = new BTagInfoList();
        if (jsonArray != null) {
            tagInfoList.decodeFromJson(jsonArray);
        }
        this.setTagList(tagInfoList);
        jsonArray = tagRuleJson.optJSONArray("tagGroups");
        BTagGroupInfoList tagGroupInfoList = new BTagGroupInfoList();
        if (jsonArray != null) {
            tagGroupInfoList.decodeFromJson(jsonArray);
        }
        this.setTagGroupList(tagGroupInfoList);
        jsonArray = tagRuleJson.optJSONArray("relations");
        BRelationInfoList relationInfoList = new BRelationInfoList();
        if (jsonArray != null) {
            relationInfoList.decodeFromJson(jsonArray);
        }
        this.setRelationList(relationInfoList);
    }

    public String toString(Context context) {
        return this.getDisplayName(context);
    }
}

