/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio;

import com.tridium.nrio.BNrio34PriModule;
import com.tridium.nrio.BNrio34SecModule;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BIOutputDefaultValues;
import com.tridium.nrio.components.BIo34OutputDefaultValues;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.components.BOutputFailsafeConfig;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.PingMessage;
import com.tridium.nrio.messages.PingResponse;
import com.tridium.nrio.messages.ReadDefaultOutputStateMessage;
import com.tridium.nrio.messages.SetLogicalAddressMessage;
import com.tridium.nrio.messages.WriteIOStateMapStart;
import com.tridium.nrio.messages.WriteOutputConfigMessage;
import com.tridium.nrio.util.DualModuleUtils;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="outputDefaultValues", type="BComponent", defaultValue="new BIo34OutputDefaultValues()", override=true), @NiagaraProperty(name="io34Sec", type="BNrio34SecModule", defaultValue="new BNrio34SecModule()", flags=4)})
public class BNrio34Module
extends BNrio34PriModule {
    @Generated
    public static final Property outputDefaultValues = BNrio34Module.newProperty((int)0, (BValue)new BIo34OutputDefaultValues(), null);
    @Generated
    public static final Property io34Sec = BNrio34Module.newProperty((int)4, (BValue)new BNrio34SecModule(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNrio34Module.class);
    private Clock.Ticket wrOutputConfigTicket;

    @Generated
    public BNrio34SecModule getIo34Sec() {
        return (BNrio34SecModule)this.get(io34Sec);
    }

    @Generated
    public void setIo34Sec(BNrio34SecModule v) {
        this.set(io34Sec, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(readOutputDefaultInfo) || action.equals(writeOutputDefaultInfo) || action.equals(setAddressAndPing)) {
            return this.postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    @Override
    public boolean isDualModule() {
        return true;
    }

    @Override
    public boolean isFirmwareUptodate() {
        return super.isFirmwareUptodate() && this.getIo34Sec().isFirmwareUptodate();
    }

    @Override
    public void doEnablePolling() {
        super.doEnablePolling();
        this.getIo34Sec().siblingEnablePolling();
    }

    @Override
    public void doDisablePolling() {
        super.doDisablePolling();
        this.getIo34Sec().siblingDisablePolling();
    }

    @Override
    public void doPing() {
        boolean needsInitialized;
        if (this.isDisabled()) {
            return;
        }
        boolean bl = needsInitialized = this.isDown() || this.firstPing;
        if (DualModuleUtils.sendPing(this) != 0) {
            return;
        }
        if (DualModuleUtils.sendPing(this.getIo34Sec()) != 0) {
            ((BNrioNetwork)this.getNetwork()).sendReset(this.getAddress());
            return;
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (needsInitialized) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (DualModuleUtils.processPostPing(this, needsInitialized)) {
            DualModuleUtils.processPostPing(this.getIo34Sec(), needsInitialized);
        }
    }

    @Override
    public void doSetAddressAndPing() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        int priLogicalAddress = this.getAddress();
        int secLogicalAddress = this.getIo34Sec().getAddress();
        byte[] uid = this.getUid().copyBytes();
        this.addressAndPing(network, secLogicalAddress, uid, 12);
        this.addressAndPing(network, priLogicalAddress, uid, 11);
        this.doPing();
    }

    private void addressAndPing(BNrioNetwork network, int address, byte[] uid, int type) {
        SetLogicalAddressMessage setAddrMsg = new SetLogicalAddressMessage(address, uid, type);
        NrioMessage rsp = network.sendNrioMessage(setAddrMsg);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PingMessage pReq = new PingMessage(address, uid, type);
        PingResponse pRsp = (PingResponse)network.sendNrioMessage(pReq);
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readBuildInfo() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        network.getLog().trace(">>> BNrioDevice(" + this.getName() + ").readBuildInfo");
        String version = network.readBuildInfo(this.getAddress());
        network.getLog().trace(">>> BNrioDevice(" + this.getName() + ").device version =" + version);
        this.setInstalledVersion(version);
        BNrio34SecModule io34Sec = this.getIo34Sec();
        network.getLog().trace(">>> BNrioDevice(" + io34Sec.getName() + ").readBuildInfo");
        String secVersion = network.readBuildInfo(io34Sec.getAddress());
        network.getLog().trace(">>> BNrioDevice(" + this.getName() + ").device version =" + secVersion);
        io34Sec.setInstalledVersion(secVersion);
    }

    @Override
    public void setUiConfig(int instance, int uiType) {
        if (instance <= 8) {
            super.setUiConfig(instance, uiType);
        } else {
            this.getIo34Sec().setUiConfig(instance - 8, uiType);
        }
    }

    @Override
    public void doWriteIo() {
        super.doWriteIo();
        this.getIo34Sec().doWriteIo();
    }

    @Override
    public int setAoValue(int value, int instance) {
        if (instance <= 0) {
            return 1;
        }
        if (instance > 4) {
            return this.getIo34Sec().setAoValue(value, instance - 4);
        }
        return super.setAoValue(value, instance);
    }

    @Override
    public int setDoValue(boolean value, int instance) {
        if (instance <= 0) {
            return 1;
        }
        if (instance > 5) {
            return this.getIo34Sec().setDoValue(value, instance - 5);
        }
        return super.setDoValue(value, instance);
    }

    @Override
    public int doWriteDoValues() {
        int rtnValue = this.doWriteIoValues();
        return this.getIo34Sec().doWriteDoValues();
    }

    @Override
    public BNrioLearnDeviceEntry makeLearnDeviceEntry() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getInstalledVersion());
        sb.append(";");
        sb.append(this.getIo34Sec().getInstalledVersion());
        int secAddr = this.getIo34Sec().getAddress();
        return new BNrioLearnDeviceEntry(this.getAddress(), this.getDeviceType(), this.getUid().copyBytes(), sb.toString(), this.getDisplayName(null), secAddr);
    }

    @Override
    public void started() throws Exception {
        super.started();
        BValue t2102 = this.getNetwork().get("T2102");
        if (t2102 != null && t2102 instanceof BString) {
            this.setAvailableVersion(t2102.toString());
            this.getIo34Sec().setAvailableVersion(t2102.toString());
            if (this.isRunning()) {
                BLink link = this.makeLink((BComponent)this.getIo34Sec(), (Slot)ioStatus, (Slot)secIoStatus, null);
                this.add(null, (BValue)link, 3);
                BLink link1 = this.makeLink((BComponent)this.getIo34Sec(), (Slot)installedVersion, (Slot)secVersion, null);
                this.add(null, (BValue)link1, 3);
            }
        }
    }

    @Override
    public void stopped() throws Exception {
        this.getIo34Sec().stopped();
        super.stopped();
    }

    @Override
    public void pingFail(String cause) {
        super.pingFail(cause);
        this.getIo34Sec().siblingPingFail(cause);
        this.doDisablePolling();
    }

    public void siblingPingFail(String cause) {
        super.pingFail(cause);
        this.doDisablePolling();
    }

    @Override
    public void doClearInfoMemory() {
        super.doClearInfoMemory();
        this.getIo34Sec().doClearInfoMemory();
    }

    @Override
    public int sendWriteConfig() {
        int priRtnValue = super.sendWriteConfig();
        int secRtnValue = this.getIo34Sec().sendWriteConfig();
        if (priRtnValue != 0) {
            return priRtnValue;
        }
        if (secRtnValue == 0) {
            this.postWriteOutputDefaults();
        }
        return secRtnValue;
    }

    @Override
    public int sendOutputConfig() {
        this.postWriteOutputDefaults();
        return 0;
    }

    @Override
    public boolean isWriteOutputDefaultsInProgress() {
        return this.isWriteDefaultOutputInProcess;
    }

    @Override
    public void doWriteOutputDefaultInfo() {
        if (this.isDisabled() || this.isDown()) {
            return;
        }
        try {
            byte[] bytes;
            byte[] bytes2;
            this.getConfigLog().trace(this.getName() + ": writeOutputDefaults");
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            BNrio34SecModule io34Sec = this.getIo34Sec();
            this.doDisablePolling();
            this.firstPing = false;
            io34Sec.firstPing = false;
            this.isWriteDefaultOutputInProcess = true;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            WriteIOStateMapStart req = new WriteIOStateMapStart(this.getAddress());
            NrioMessage rsp = network.sendNrioMessage(req);
            if (this.getConfigLog().isTraceOn()) {
                bytes2 = req.getByteArray();
                this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes2, (int)0, (int)bytes2.length));
                bytes2 = rsp.getByteArray();
                this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes2, (int)0, (int)bytes2.length));
            }
            if (rsp.getStatus() != 0) {
                this.getConfigLog().trace("WriteIOStateMapStart pri response error: " + rsp.getStatus());
            }
            req = new WriteIOStateMapStart(io34Sec.getAddress());
            rsp = network.sendNrioMessage(req);
            if (this.getConfigLog().isTraceOn()) {
                bytes2 = req.getByteArray();
                this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes2, (int)0, (int)bytes2.length));
                bytes2 = rsp.getByteArray();
                this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes2, (int)0, (int)bytes2.length));
            }
            if (rsp.getStatus() != 0) {
                this.getConfigLog().trace("WriteIOStateMapStart sec response error: " + rsp.getStatus());
            }
            BOutputFailsafeConfig failsafeConfig = network.getOutputFailsafeConfig();
            WriteOutputConfigMessage wrReq = new WriteOutputConfigMessage(this.getAddress(), failsafeConfig.getStartupTimeout(), failsafeConfig.getCommLossTimeout(), (BIOutputDefaultValues)this.getOutputDefaultValues(), true);
            NrioMessage wrRsp = network.sendNrioMessage(wrReq);
            if (this.getConfigLog().isTraceOn()) {
                bytes = wrReq.getByteArray();
                this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
                bytes = wrRsp.getByteArray();
                this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            }
            if (wrRsp.getStatus() != 0) {
                this.getConfigLog().trace("WriteOutputConfigMessage primary response error: " + wrRsp.getStatus());
            }
            wrReq = new WriteOutputConfigMessage(io34Sec.getAddress(), failsafeConfig.getStartupTimeout(), failsafeConfig.getCommLossTimeout(), (BIOutputDefaultValues)this.getOutputDefaultValues(), false);
            wrRsp = network.sendNrioMessage(wrReq);
            if (this.getConfigLog().isTraceOn()) {
                bytes = wrReq.getByteArray();
                this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
                bytes = wrRsp.getByteArray();
                this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            }
            if (wrRsp.getStatus() != 0) {
                this.getConfigLog().trace("WriteOutputConfigMessage secondary response error: " + wrRsp.getStatus());
            }
            this.doEnablePolling();
            io34Sec.doEnablePolling();
        }
        catch (Exception e) {
            this.getConfigLog().trace("doReadOutputDefaultInfo caught exception: " + e);
        }
        this.isWriteDefaultOutputInProcess = false;
    }

    @Override
    public BComponent doReadOutputDefaultInfo() {
        try {
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            ReadDefaultOutputStateMessage req = new ReadDefaultOutputStateMessage(this.getAddress());
            NrioMessage rsp = network.sendNrioMessage(req);
            if (this.getConfigLog().isTraceOn()) {
                byte[] bytes = req.getByteArray();
                this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
                bytes = rsp.getByteArray();
                this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            }
            if (rsp.getStatus() != 0) {
                return null;
            }
            byte[] priInfoData = rsp.getData();
            req = new ReadDefaultOutputStateMessage(this.getIo34Sec().getAddress());
            rsp = network.sendNrioMessage(req);
            if (this.getConfigLog().isTraceOn()) {
                byte[] bytes = req.getByteArray();
                this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
                bytes = rsp.getByteArray();
                this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length));
            }
            if (rsp.getStatus() != 0) {
                return null;
            }
            byte[] secInfoData = rsp.getData();
            BIo34OutputDefaultValues defaultValues = new BIo34OutputDefaultValues(priInfoData, secInfoData);
            return defaultValues;
        }
        catch (Exception e) {
            this.getConfigLog().trace("doReadOutputDefaultInfo caught exception: " + e);
            return null;
        }
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        BComponent info = this.getIo34Sec().doReadScaleOffset();
        out.startProps("Sec Calibration Info");
        if (info != null) {
            for (Property property : info.getProperties()) {
                out.prop((Object)property.getName(), (Object)info.get(property));
            }
        }
        out.endProps();
        BComponent priInfo = this.doReadInfoMemory();
        BComponent secInfo = this.getIo34Sec().doReadInfoMemory();
        out.startProps("IO-34-Pri CPU Info Memory");
        for (Property property : priInfo.getProperties()) {
            out.prop((Object)property.getName(), (Object)priInfo.get(property));
        }
        out.endProps();
        out.startProps("IO-34-Sec CPU Info Memory");
        for (Property property : secInfo.getProperties()) {
            out.prop((Object)property.getName(), (Object)secInfo.get(property));
        }
        out.endProps();
    }
}

