/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioOutputStream;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.NrioResponse;
import java.io.OutputStream;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;

public class NrioMessage
extends Message
implements NrioMessageConst {
    protected int address;
    protected int length;
    protected int type;
    protected int status;
    protected byte[] data = new byte[0];

    public NrioMessage() {
    }

    public NrioMessage(int address, int type, byte[] data) {
        this.address = address;
        this.type = type;
        this.status = 0;
        this.data = data;
    }

    public int getAddress() {
        return this.address;
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isOk() {
        return this.status == 0;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void write(OutputStream out) {
        try {
            byte[] ba = this.getByteArray();
            out.write(ba);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getByteArray() {
        NrioOutputStream packet = new NrioOutputStream();
        packet.write(this.address);
        packet.write(2 + this.data.length);
        packet.write(this.type);
        packet.write(this.status);
        for (int i = 0; i < this.data.length; ++i) {
            packet.write(this.data[i]);
        }
        return packet.toByteArray();
    }

    public Message toResponse(ReceivedMessage resp) {
        NrioReceivedMessage accessResp = (NrioReceivedMessage)resp;
        NrioResponse respMessage = new NrioResponse();
        respMessage.readResponse(accessResp.getBytes(), accessResp.getLength());
        return respMessage;
    }

    public NrioInputStream readResponse(NrioReceivedMessage message) {
        return this.decodeFromBytes(message.getBytes(), message.getLength());
    }

    public NrioInputStream decodeFromBytes(byte[] dataBytes, int nbytes) {
        NrioInputStream inStream = new NrioInputStream(dataBytes, 0, nbytes);
        this.address = inStream.read() & 0xFF;
        this.length = inStream.read() & 0xFF;
        this.type = inStream.read() & 0xFF;
        this.status = inStream.read() & 0xFF;
        this.data = new byte[inStream.available()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)(inStream.read() & 0xFF);
        }
        inStream = new NrioInputStream(this.data);
        return inStream;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NrioMessage       = " + TextUtil.getClassName(this.getClass()));
        sb.append("\n  address = " + Integer.toHexString(this.address));
        sb.append("\n  length  = " + Integer.toHexString(this.length));
        sb.append("\n  type    = " + Integer.toHexString(this.type));
        sb.append("\n  status  = " + Integer.toHexString(this.status));
        sb.append("\n  data    = " + ByteArrayUtil.toHexString((byte[])this.data));
        return sb.toString();
    }
}

