/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.points;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.nrio.BIWritable;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.points.BNrio16ProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNrio16WriteProxyExt
extends BNrio16ProxyExt
implements BIBasicPollable,
BIWritable,
NrioMessageConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BNrio16WriteProxyExt.class);
    public static final byte[] ACTIVE_DATA = new byte[]{1};
    public static final byte[] INACTIVE_DATA = new byte[]{0};
    private int undoInstance = -1;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            this.undoInstance = this.getInstance();
        }
    }

    @Override
    public void stopped() throws Exception {
        if (this.isRunning()) {
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            network.getPollScheduler().unsubscribe((BIPollable)this);
        }
        super.stopped();
    }

    @Override
    public boolean requiresPointSubscription() {
        return false;
    }

    @Override
    public void readSubscribed(Context cx) throws Exception {
    }

    @Override
    public void readUnsubscribed(Context cx) throws Exception {
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning() && context != Context.decoding) {
            if (prop.equals(instance)) {
                BControlPoint conflictPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                if (conflictPoint != null) {
                    this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + " " + conflictPoint.getName());
                    this.setInstance(this.undoInstance);
                } else {
                    this.undoInstance = this.getInstance();
                }
                this.device().updateProxyValues();
            } else if (prop.equals(enabled) && this.getEnabled()) {
                BControlPoint conflictPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                if (conflictPoint != null) {
                    this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + " " + conflictPoint.getName());
                    this.setEnabled(false);
                } else {
                    this.readOk(this.getReadValue());
                }
                this.device().updateProxyValues();
            }
        }
    }

    public void poll() {
        BNrioNetwork network = this.network();
        if (network.getLog().isTraceOn()) {
            network.getLog().trace(this + ".poll()");
        }
        this.read();
        if (!this.getStatus().isStale()) {
            network.getPollScheduler().unsubscribe((BIPollable)this);
        }
    }

    private void read() {
        if (this.getParentPoint().isWritablePoint()) {
            this.readOk(this.getWriteValue());
        } else {
            this.device().updateProxyValues();
        }
    }

    public boolean write(Context cx) throws Exception {
        BStatusValue out = this.getWriteValue();
        if (out.getStatus().isNull()) {
            return false;
        }
        BNrioNetwork network = this.network();
        this.readOk(out);
        this.writeData(out);
        return false;
    }

    @Override
    public void writeData(BStatusValue out) {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        if (network == null) {
            return;
        }
        if (!(this.device() instanceof BNrio16Module)) {
            return;
        }
        int wrStatus = 1;
        if (this.isBoolean()) {
            wrStatus = this.device().setDoValue(((BStatusBoolean)out).getValue(), this.getInstance());
        } else {
            network.getLog().message("**** subclass should override writeData *******");
        }
        if (wrStatus == 0) {
            this.writeOk(out);
        } else {
            this.writeFail("writeError: " + wrStatus);
        }
    }

    public String toString(Context cx) {
        return super.toString(cx);
    }

    protected BNrioDevice device() {
        return (BNrioDevice)this.getDevice();
    }

    protected BNrioNetwork network() {
        return (BNrioNetwork)this.getDevice().getNetwork();
    }

    @Override
    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    @Override
    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }
}

