/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.points;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.nrio.BIWritable;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioInputOutputModule;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioWriteAsyncRequest;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.point.conv.BReversePolarityConversion;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="conversion", type="BProxyConversion", defaultValue="BDefaultProxyConversion.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"nrio:NrioProxyConversionFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"nrio:NrioProxyConversionEditor\"")}, override=true), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="instance", type="int", defaultValue="0"), @NiagaraProperty(name="isStrike", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="isSdi", type="boolean", defaultValue="false", flags=5)})
@NiagaraAction(name="postChangeTimeout", flags=4)
public class BNrioProxyExt
extends BProxyExt
implements BIBasicPollable,
BIWritable,
NrioMessageConst {
    @Generated
    public static final Property conversion = BNrioProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"nrio:NrioProxyConversionFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"nrio:NrioProxyConversionEditor")));
    @Generated
    public static final Property pollFrequency = BNrioProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property instance = BNrioProxyExt.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property isStrike = BNrioProxyExt.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property isSdi = BNrioProxyExt.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Action postChangeTimeout = BNrioProxyExt.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNrioProxyExt.class);
    Clock.Ticket postChangeTicket = null;
    public static final byte[] ACTIVE_DATA = new byte[]{1};
    public static final byte[] INACTIVE_DATA = new byte[]{0};
    private int undoInstance = -1;

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public int getInstance() {
        return this.getInt(instance);
    }

    @Generated
    public void setInstance(int v) {
        this.setInt(instance, v, null);
    }

    @Generated
    public boolean getIsStrike() {
        return this.getBoolean(isStrike);
    }

    @Generated
    public void setIsStrike(boolean v) {
        this.setBoolean(isStrike, v, null);
    }

    @Generated
    public boolean getIsSdi() {
        return this.getBoolean(isSdi);
    }

    @Generated
    public void setIsSdi(boolean v) {
        this.setBoolean(isSdi, v, null);
    }

    @Generated
    public void postChangeTimeout() {
        this.invoke(postChangeTimeout, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BControlPoint conflictPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
            if (conflictPoint != null) {
                this.setEnabled(false);
                this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + " " + conflictPoint.getName());
            }
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            this.undoInstance = this.getInstance();
            if (this.getEnabled()) {
                network.getPollScheduler().subscribe((BIPollable)this);
            }
        }
    }

    public void stopped() throws Exception {
        if (this.isRunning()) {
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            network.getPollScheduler().unsubscribe((BIPollable)this);
        }
        super.stopped();
    }

    public boolean requiresPointSubscription() {
        return false;
    }

    public Type getDeviceExtType() {
        return BNrioPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.writeonly : BReadWriteMode.readonly;
    }

    public void doReadPoint() {
        this.read();
    }

    public void readSubscribed(Context cx) throws Exception {
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning() && context != Context.decoding) {
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            if (prop.equals(instance)) {
                BControlPoint conflictPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                if (conflictPoint != null) {
                    this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + " " + conflictPoint.getName());
                    this.setEnabled(false);
                } else {
                    if (this.getParentPoint().isWritablePoint()) {
                        this.device().setDoValue(false, this.undoInstance);
                        try {
                            this.write(null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.undoInstance = this.getInstance();
                }
                this.device().updateProxyValues();
            } else if (prop.equals(enabled)) {
                if (this.getEnabled()) {
                    BControlPoint conflictPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                    if (conflictPoint != null) {
                        this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + " " + conflictPoint.getName());
                        this.setEnabled(false);
                        this.device().updateProxyValues();
                    } else {
                        this.device().updateProxyValues();
                        this.setPostChangeTicket();
                        if (this.getParentPoint().isWritablePoint()) {
                            try {
                                this.write(null);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else if (prop.equals(conversion)) {
                this.device().updateProxyValues();
                this.setPostChangeTicket();
            }
        }
    }

    protected void convertDeviceToProxy(BStatusValue deviceValue, BStatusValue proxyValue) {
        if (deviceValue.getStatus().isFault() && this.getIsSdi() && this.getConversion().getType().is(BReversePolarityConversion.TYPE) && deviceValue.getStatus().isFault()) {
            ((BStatusBoolean)deviceValue).setValue(true);
        }
        super.convertDeviceToProxy(deviceValue, proxyValue);
    }

    public void poll() {
        BNrioNetwork network = this.network();
        if (network.getLog().isTraceOn()) {
            network.getLog().trace(this + ".poll()");
        }
        this.read();
        if (!this.getStatus().isStale()) {
            network.getPollScheduler().unsubscribe((BIPollable)this);
        }
    }

    private void read() {
        if (this.getParentPoint() instanceof BBooleanWritable) {
            this.readOk(this.getWriteValue());
        } else {
            this.device().updateProxyValues();
        }
    }

    public boolean write(Context cx) throws Exception {
        BStatusValue out = this.getWriteValue();
        if (out.getStatus().isNull()) {
            return false;
        }
        BNrioNetwork network = this.network();
        this.readOk(out);
        if (network.isDownLoadInProcess()) {
            return false;
        }
        network.postWrite(new NrioWriteAsyncRequest(this, out));
        return true;
    }

    @Override
    public void writeData(BStatusValue out) {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        if (network == null) {
            return;
        }
        if (this.device() instanceof BNrioInputOutputModule) {
            int wrStatus = this.device().setDoValue(((BStatusBoolean)out).getValue(), this.getInstance());
            if (wrStatus == 0) {
                this.writeOk(out);
            } else {
                this.writeFail("writeError: " + wrStatus);
            }
        } else if (this.device() instanceof BNrio16Module) {
            int wrStatus = this.device().setDoValue(((BStatusBoolean)out).getValue(), this.getInstance());
            if (wrStatus == 0) {
                this.writeOk(out);
            } else {
                this.writeFail("writeError: " + wrStatus);
            }
        }
    }

    public String toString(Context cx) {
        return super.toString(cx);
    }

    private BNrioDevice device() {
        return (BNrioDevice)this.getDevice();
    }

    private BNrioNetwork network() {
        return (BNrioNetwork)this.getDevice().getNetwork();
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    public void doPostChangeTimeout() {
        BControlPoint pp = this.getParentPoint();
        if (pp != null) {
            pp.execute();
        }
    }

    private void setPostChangeTicket() {
        if (this.postChangeTicket != null) {
            this.postChangeTicket.cancel();
        }
        this.postChangeTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)500L), (Action)postChangeTimeout, null);
    }
}

