/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.util;

import com.tridium.nrio.messages.NrioMessageConst;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.nre.util.TextUtil;

public class IntelHexFile
implements NrioMessageConst {
    private BIFile file;
    private InputStream inStream;

    public static IntelHexFile make(BIFile file) {
        return new IntelHexFile(file);
    }

    private IntelHexFile(BIFile file) {
        this.file = file;
        try {
            this.inStream = file.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector<MemoryBlock> readMemoryBlocks() {
        try {
            Vector<MemoryBlock> v = new Vector<MemoryBlock>();
            int nextAddress = -1;
            IntelHexLine hexLine = this.readHexLine();
            if (hexLine == null) {
                return null;
            }
            MemoryBlock memBlock = new MemoryBlock(hexLine.getBaseAddress());
            memBlock.write(hexLine.getData());
            nextAddress = hexLine.getBaseAddress() + hexLine.getData().length;
            boolean done = false;
            while (!done) {
                hexLine = this.readHexLine();
                if (hexLine == null || hexLine.isEndOfFile()) {
                    v.addElement(memBlock);
                    done = true;
                    break;
                }
                while (hexLine.getBaseAddress() == nextAddress) {
                    memBlock.write(hexLine.getData());
                    nextAddress = hexLine.getBaseAddress() + hexLine.getData().length;
                    hexLine = this.readHexLine();
                }
                v.addElement(memBlock);
                memBlock = new MemoryBlock(hexLine.getBaseAddress());
                memBlock.write(hexLine.getData());
                nextAddress = hexLine.getBaseAddress() + hexLine.getData().length;
            }
            return v;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public IntelHexLine readHexLine() {
        IntelHexLine line = new IntelHexLine();
        int colon = 0;
        try {
            int length;
            while (true) {
                if (colon != 58) {
                    colon = this.inStream.read();
                    continue;
                }
                length = this.readByte();
                int baseAddress = this.readWord();
                line.setBaseAddress(baseAddress);
                boolean endOfFile = this.readByte() == 1;
                line.setEndOfFile(endOfFile);
                line.setDataSize(length);
                if (endOfFile) {
                    return line;
                }
                if (length != 0) break;
            }
            byte[] data = line.getData();
            for (int i = 0; i < length; ++i) {
                data[i] = (byte)this.readByte();
            }
            return line;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int readByte() throws Exception {
        int hexChar = this.inStream.read();
        int value = TextUtil.hexCharToInt((char)((char)hexChar));
        hexChar = this.inStream.read();
        value = value << 4 | TextUtil.hexCharToInt((char)((char)hexChar));
        return value;
    }

    private int readWord() throws Exception {
        int value = this.readByte();
        value = value << 8 | this.readByte();
        return value;
    }

    private class IntelHexLine {
        boolean endOfFile = false;
        int address = 0;
        byte[] data;

        IntelHexLine() {
        }

        void setDataSize(int size) {
            this.data = new byte[size];
        }

        void setBaseAddress(int address) {
            this.address = address;
        }

        void setData(byte[] data) {
            this.data = data;
        }

        void setEndOfFile(boolean endOfFile) {
            this.endOfFile = endOfFile;
        }

        int getBaseAddress() {
            return this.address;
        }

        byte[] getData() {
            return this.data;
        }

        boolean isEndOfFile() {
            return this.endOfFile;
        }
    }

    public class MemoryBlock {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int baseAddress;

        public MemoryBlock(int baseAddress) {
            this.baseAddress = baseAddress;
        }

        private void writeByte(int value) {
            this.out.write(value);
        }

        private void write(byte[] data) {
            this.out.write(data, 0, data.length);
        }

        public String toString() {
            return "baseAddress = " + Integer.toHexString(this.baseAddress) + " size = " + Integer.toHexString(this.out.size());
        }
    }
}

