/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.ui;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.ui.videoStream.IVideoImagePainter;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.io.BufferedInputStream;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.rtsp.RtpPacket;
import javax.baja.rtsp.RtpStream;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import org.baja.ffmpeg.enums.BCodecIdEnum;
import org.baja.ffmpeg.videoDriver.FfmpegVideoDecoder;

public class AxisFfmpegMpeg4Decoder
extends FfmpegVideoDecoder
implements IVideoImagePainter {
    BAxisVideoCamera camera;
    protected boolean done = false;
    protected boolean lastMarker = false;
    public static final Logger dataLog = Logger.getLogger("axisipcamera.mp4Decoder.driverData");
    public static final Logger videoLog = Logger.getLogger("axisipcamera.mpeg4.rtsp.networkinfo");
    public static final BFacets SHOW_SECONDS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    byte[] buffer = new byte[12];
    byte[] buf1 = new byte[12];
    ByteBuffer videoFrameBuffer = new ByteBuffer();
    ByteBuffer tmpVideoFrameBuffer = new ByteBuffer();
    ByteBuffer dataHeaderBuffer = new ByteBuffer();
    ByteBuffer helper1 = new ByteBuffer();
    boolean readyReturn = false;
    BufferedInputStream bufferedInput;
    protected int bgAlpha = 180;
    protected int fgAlpha = 250;
    private static final byte[] START_CODE_PREFIX = new byte[]{0, 0, 0, 1};
    private static final byte FRAGMENTED_UNIT_TYPE_A = 28;
    private static final int MAX_NULL_PACKETS = 10;
    private int numNullPackets = 0;
    private String sdpString;
    byte[] sequenceParamaterSet = new byte[0];
    byte[] pictureParameterSet = new byte[0];

    public AxisFfmpegMpeg4Decoder(BAxisVideoCamera cam) {
        super(cam.getHighCompressionCodec());
        this.camera = cam;
    }

    private RtpStream helpGetInputStream() {
        return (RtpStream)this.videoIn;
    }

    public void readFrameData(VidFrame vf) throws Exception {
        this.videoFrameBuffer.reset();
        RtpStream stream = this.helpGetInputStream();
        if (this.decoderCodecToUse.equals((Object)BCodecIdEnum.ffmpeg_CODEC_ID_MPEG4)) {
            this.videoFrameBuffer.write(stream.readFrame());
        } else if (this.decoderCodecToUse.equals((Object)BCodecIdEnum.ffmpeg_CODEC_ID_H264)) {
            this.numNullPackets = 0;
            int nal_header = 0;
            boolean nal_header_extracted = false;
            if (this.sdpString == null) {
                this.extractParamaterSets();
            }
            this.videoFrameBuffer.write(START_CODE_PREFIX);
            this.videoFrameBuffer.write(this.sequenceParamaterSet);
            this.videoFrameBuffer.write(START_CODE_PREFIX);
            this.videoFrameBuffer.write(this.pictureParameterSet);
            while (true) {
                boolean isMarker;
                RtpPacket packet;
                if ((packet = stream.readPacket()) == null) {
                    if (this.numNullPackets++ <= 10) continue;
                    this.videoFrameBuffer.reset();
                    break;
                }
                byte[] rtpPayload = packet.payload;
                if (rtpPayload == null || rtpPayload.length == 0) {
                    if (this.numNullPackets++ <= 10) continue;
                    this.videoFrameBuffer.reset();
                    break;
                }
                int firstPayloadByte = rtpPayload[0];
                int payloadLength = packet.pay_length;
                if ((firstPayloadByte & 0x1F) == 28 && rtpPayload.length >= 2) {
                    this.numNullPackets = 0;
                    if (!nal_header_extracted) {
                        byte secondPayloadByte = rtpPayload[1];
                        int fragment_indicator = firstPayloadByte;
                        byte fragment_header = secondPayloadByte;
                        int nal_ref_idc = (fragment_indicator >>>= 5) & 3;
                        int forbidden_zero_bit = (fragment_indicator >>>= 2) & 1;
                        int nal_type = fragment_header & 0x1F;
                        nal_header = (forbidden_zero_bit << 1 | nal_ref_idc) << 5 | nal_type;
                        this.videoFrameBuffer.write(START_CODE_PREFIX);
                        this.videoFrameBuffer.writeByte(nal_header);
                        nal_header_extracted = true;
                    }
                    this.videoFrameBuffer.write(rtpPayload, 2, payloadLength - 2);
                }
                if (isMarker = packet.marker) break;
            }
        }
        vf.rawData = this.videoFrameBuffer;
    }

    private void extractParamaterSets() {
        RtpStream stream = this.helpGetInputStream();
        this.sdpString = stream.session.sdpString;
        if (!this.sdpString.equals("")) {
            String[] sdpTokens = TextUtil.splitAndTrim((String)this.sdpString, (char)'\n');
            for (int i = 0; i < sdpTokens.length; ++i) {
                String sdpToken = sdpTokens[i];
                String[] subTokens = TextUtil.splitAndTrim((String)sdpToken, (char)';');
                boolean found = false;
                for (int j = 0; j < subTokens.length; ++j) {
                    int index = subTokens[j].indexOf("sprop-parameter-sets");
                    if (index == -1) continue;
                    String subToken = subTokens[j];
                    String sprop_value = subToken.substring(subToken.indexOf("=") + 1);
                    String spsString = sprop_value.substring(0, sprop_value.indexOf(","));
                    String ppsString = sprop_value.substring(sprop_value.indexOf(",") + 1);
                    this.sequenceParamaterSet = Base64.getDecoder().decode(spsString);
                    this.pictureParameterSet = Base64.getDecoder().decode(ppsString);
                    found = true;
                    break;
                }
                if (found) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintImage(Graphics g, BWidget vp) {
        if (this.helpGetInputStream() != null && videoLog.isLoggable(Level.FINE)) {
            String message = "This video is using " + this.helpGetInputStream().getBandwidth() + " bandwidth, when we got a total of " + this.helpGetInputStream().getFrameCount();
            message = message + " frames \r\n in " + this.helpGetInputStream().getPacketCount() + " packets with a approximate loss of " + this.helpGetInputStream().getPacketLoss() + "%.\r\nWe are using " + (this.helpGetInputStream().getPort() - 1) + "/" + this.helpGetInputStream().getPort() + " ports with " + this.helpGetInputStream().getUdpBufferSize() / 1024;
            message = message + " kilo bytes of buffer size and we lost " + this.helpGetInputStream().numPacketLost() + " packets";
            try {
                g.push();
                int fontSize = 16;
                if (vp.getWidth() < 200.0) {
                    fontSize = 2;
                } else if (vp.getWidth() < 250.0) {
                    fontSize = 4;
                } else if (vp.getWidth() < 500.0) {
                    fontSize = 10;
                } else if (vp.getWidth() < 800.0) {
                    fontSize = 12;
                }
                BBrush background = BBrush.makeSolid((BColor)BColor.make((int)20, (int)50, (int)50, (int)this.bgAlpha));
                BBrush foreground = BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)255, (int)this.fgAlpha));
                BFont font = BFont.make((String)Theme.label().getTextFont().getName(), (double)fontSize, (int)1);
                BLabel messageLabel = new BLabel();
                BBorderPane borderPane = new BBorderPane((BWidget)messageLabel, BBorder.dashed);
                messageLabel.setHalign(BHalign.left);
                messageLabel.setValign(BValign.bottom);
                messageLabel.setText(message);
                messageLabel.setBackground(background);
                messageLabel.setForeground(foreground);
                messageLabel.setFont(font);
                messageLabel.computePreferredSize();
                messageLabel.setBounds(2.0, 2.0, messageLabel.getPreferredWidth(), messageLabel.getPreferredHeight());
                messageLabel.doLayout(null);
                double fromLeft = vp.getWidth() / 2.0 - messageLabel.getPreferredWidth() / 2.0;
                double fromBottom = vp.getHeight() - messageLabel.getPreferredHeight() - 10.0;
                g.transform(BTransform.makeTranslate((double)fromLeft, (double)fromBottom));
                borderPane.paint(g);
                g.setBrush(background);
                g.setPen(BPen.make((double)4.0, (int)103, (int)202, null));
                g.strokeRect(0.0, 0.0, messageLabel.getPreferredWidth() + 4.0, messageLabel.getPreferredHeight() + 4.0);
            }
            catch (Exception exception) {
            }
            finally {
                g.pop();
            }
        }
        super.paintImage(g, vp);
    }
}

