/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.propMigration.converters;

import java.util.ArrayList;
import java.util.List;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BNewTypeConverter
extends BObject
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BNewTypeConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typespecName, Version sourceVersion) {
        XElem[] props;
        if (!typespecName.equals("oldMig:OrigType")) {
            return x;
        }
        log.finer("Migrate a PropNameChange! typespecName=" + typespecName + ", xelem=" + x);
        String xName = x.get("n");
        x.setAttr("m", "propMigration=propMigration");
        x.setAttr("t", "propMigration:NewType");
        log.info("Changing type of " + xName + " to propMigration:NewType");
        for (XElem p : props = x.elems("p")) {
            String n = p.get("n", "-");
            if (!n.equals("oldBoolProp")) continue;
            log.info("Changing name of " + xName + ":oldBoolProp to newBoolProp");
            p.setAttr("n", "newBoolProp");
        }
        log.finer("migrated: new x is " + x);
        return x;
    }

    public BValue newInstance(String moduleName, String typeName) {
        log.finest("PropNameChangeConverter.newInstance is stubbed!");
        return (BValue)BTypeSpec.make((String)"propMigration:NewType").getInstance();
    }

    public String newTypeSpec(String typeSpecName) {
        if (typeSpecName.equals("oldMig:OrigType")) {
            return "propMigration:NewType";
        }
        return typeSpecName;
    }

    public BOrd fixOrd(BOrd originalOrd) {
        String ordS = originalOrd.toString(null);
        if (ordS.contains("oldBoolProp")) {
            ordS = ordS.replace("oldBoolProp", "newBoolProp");
        } else if (ordS.contains("oldAction")) {
            ordS = ordS.replace("oldAction", "newAction");
        } else if (ordS.contains("oldTopic")) {
            ordS = ordS.replace("oldTopic", "newTopic");
        } else {
            return null;
        }
        return BOrd.make((String)ordS);
    }

    static {
        convertTypes.add("oldMig:OrigType");
        convertTypes.add("propMigration:NewType");
    }
}

