/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platIEEE8021X;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.platIEEE8021X.IEEE8021XUtil;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.security.IX509CertificateEntry;

public class TrustStoreCertInfo {
    private String alias;
    private IX509CertificateEntry cert;
    private boolean isDateInvalid;
    private boolean isSelfSigned;
    public static final TrustStoreCertInfo BLANK_CA_CERTIFICATE = new TrustStoreCertInfo();
    public static final TrustStoreCertInfo[] EMPTY_TRUST_STORE_LIST = new TrustStoreCertInfo[0];
    public static final int CERT_USAGE_CERT_SIGN = 5;
    public static final int BLANK_CA_CERTIFICATE_INDEX = 0;
    public static final Comparator<TrustStoreCertInfo> TRUST_STORE_CERT_INFO_COMPARATOR = (certA, certB) -> {
        String alias1 = certA.toString();
        String alias2 = certB.toString();
        return alias1.compareTo(alias2);
    };
    private static final Logger LOG = Logger.getLogger("platIEEE8021X");

    public static TrustStoreCertInfo[] list(ICoreTrustStore trustStore) throws Exception {
        return TrustStoreCertInfo.make(trustStore);
    }

    public static TrustStoreCertInfo[] make(ICoreTrustStore trustStore) throws Exception {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Making new TrustStoreCertInfo list from provided trust store");
        }
        if (trustStore == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Provided trust store is null, returning empty list");
            }
            return EMPTY_TRUST_STORE_LIST;
        }
        ArrayList<TrustStoreCertInfo> certsAsArray = new ArrayList<TrustStoreCertInfo>();
        for (IX509CertificateEntry currentCertificateEntry : trustStore.getCertificateEntries()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Considering trust store certificate entry '" + currentCertificateEntry.getAlias() + "' for IEEE 802.1X usage...");
            }
            X509Certificate[] certificates = currentCertificateEntry.getCertificates();
            boolean caCertificate = false;
            boolean isSelfSigned = false;
            boolean isDateInvalid = false;
            for (X509Certificate current : certificates) {
                if (current.getBasicConstraints() != -1) {
                    caCertificate = true;
                }
                if (NX509Certificate.make((X509Certificate)current).isSelfSigned()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Certificate entry '" + currentCertificateEntry.getAlias() + "', determined to be self signed");
                    }
                    isSelfSigned = true;
                }
                try {
                    current.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Certificate entry '" + currentCertificateEntry.getAlias() + "', determined to have invalid date (" + e + ")");
                    }
                    isDateInvalid = true;
                }
            }
            if (!caCertificate) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Skipping certificate entry '" + currentCertificateEntry.getAlias() + "', Basic Constraints not valid for CA usage ");
                continue;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Adding trust store certificate entry '" + currentCertificateEntry.getAlias() + "' for 802.1X usage (isSelfSigned = " + isSelfSigned + ", isInvalid = " + isDateInvalid + ")");
            }
            certsAsArray.add(new TrustStoreCertInfo(currentCertificateEntry, isDateInvalid, isSelfSigned));
        }
        return certsAsArray.toArray(EMPTY_TRUST_STORE_LIST);
    }

    public TrustStoreCertInfo() {
    }

    public TrustStoreCertInfo(IX509CertificateEntry certificate, boolean isDateInvalid, boolean isSelfSigned) {
        this.cert = certificate;
        this.alias = certificate.getAlias();
        this.isDateInvalid = isDateInvalid;
        this.isSelfSigned = isSelfSigned;
    }

    public String toString() {
        if (this == BLANK_CA_CERTIFICATE) {
            return IEEE8021XUtil.NO_CERTIFICATE;
        }
        return this.alias;
    }

    public String alias() {
        return this.alias;
    }

    public IX509CertificateEntry cert() {
        return this.cert;
    }

    public boolean dateInvalid() {
        return this.isDateInvalid;
    }

    public boolean selfSigned() {
        return this.isSelfSigned;
    }
}

