/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.tags.px;

import com.tridium.exporttags.tags.px.BPxViewTag;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.nd.ui.px.BAbstractSubstitutePxView;
import javax.baja.control.BControlPoint;
import javax.baja.history.HistoryQuery;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.util.BConverter;
import javax.baja.workbench.view.BWbViewBinding;

@NiagaraType
public final class BPxViewTagValidationJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BPxViewTagValidationJob.class);
    private BPxViewTag tag;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPxViewTagValidationJob() {
    }

    public BPxViewTagValidationJob(BPxViewTag tag) {
        this.tag = tag;
    }

    public void run(Context cx) throws Exception {
        BComponent base = (BComponent)this.tag.getParent();
        base.lease();
        ValidatePxOrdVisitor v = new ValidatePxOrdVisitor(base);
        this.tag.startProcessPx(v);
        if (v.failureCount > 0) {
            throw new ExportTagException("pxValJob.valFailed", String.valueOf(v.failureCount));
        }
    }

    private class ValidatePxOrdVisitor
    implements BAbstractSubstitutePxView.IPxOrdVisitor {
        private BComponent base;
        private int failureCount = 0;

        ValidatePxOrdVisitor(BComponent base) {
            this.base = base;
        }

        public boolean handlePreprocessOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            return true;
        }

        public void handleVirtualOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            try {
                BBinding binding;
                BObject obj = ord.get((BObject)this.base);
                BPxViewTagValidationJob.this.log().success(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.resolvedOrd", ord.toString());
                if (clx instanceof BWbViewBinding) {
                    BPxViewTagValidationJob.this.log().message(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.wbViewBindingWarning", ord.toString());
                } else if (obj instanceof BComponent && !(obj instanceof BControlPoint) && clx instanceof BBinding && ((BConverter[])(binding = (BBinding)clx).getChildren(BConverter.class)).length > 0) {
                    BPxViewTagValidationJob.this.log().message(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.virtualOrdWarning", ord.toString());
                }
            }
            catch (Exception e) {
                ++this.failureCount;
                BPxViewTagValidationJob.this.log().failed(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.unableResolveOrd", ord.toString(), (Throwable)e);
            }
        }

        public void handleHyperlinkOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
        }

        public void handleFileOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
            try {
                ord.resolve((BObject)this.base);
                BPxViewTagValidationJob.this.log().success(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.resolvedFileOrd", ord.toString());
            }
            catch (Exception e) {
                ++this.failureCount;
                BPxViewTagValidationJob.this.log().failed(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.unableResolveFileOrd", ord.toString(), (Throwable)e);
            }
        }

        public void handleModuleOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
            try {
                ord.resolve();
                BPxViewTagValidationJob.this.log().success(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.resolveModuleOrd", ord.toString());
            }
            catch (Exception e) {
                ++this.failureCount;
                BPxViewTagValidationJob.this.log().failed(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.unableResolveModuleOrd", ord.toString(), (Throwable)e);
            }
        }

        public void handleHistoryOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
            try {
                HistoryQuery query = (HistoryQuery)queries[queryIndex];
                BOrd.make((OrdQuery)query).resolve((BObject)this.base);
                BPxViewTagValidationJob.this.log().success(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.resolvedHistoryOrd", ord.toString());
            }
            catch (Exception e) {
                ++this.failureCount;
                BPxViewTagValidationJob.this.log().failed(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.unableResolveHistoryOrd", ord.toString(), (Throwable)e);
            }
        }

        public void handleUnknownOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            ++this.failureCount;
            BPxViewTagValidationJob.this.log().failed(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.unsupportedOrd", ord.toString());
        }

        public void handleOverrideOrd(BComplex clx, Property prop, BOrd ord, BOrd overrideOrd) throws Exception {
            BPxViewTagValidationJob.this.log().success(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.overridingOldOrd", ord.toString());
            BPxViewTagValidationJob.this.log().success(BPxViewTagValidationJob.this.getType().getModule().getModuleName(), "pxValJob.overridingNewOrd", overrideOrd.toString());
        }
    }
}

