/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.ui;

import com.tridium.exporttags.BJoinProfile;
import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.exporttags.util.ExportTagUtil;
import com.tridium.nd.BNiagaraStation;
import com.tridium.ui.BOptionDialog;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.io.ValueDocDecoder;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditorOptions;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeController;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

@NiagaraType
public class BStationCompSelFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BStationCompSelFE.class);
    private BTextField stationOrdField = new BTextField("", 60);
    private BButton stationOrdButton = new BButton((Command)new EditStationOrd());
    private BButton linkToStationBogButton = new BButton((Command)new HyperlinkToStationBogFile());
    private BString handleOrd;
    private static final Lexicon lex = Lexicon.make(BStationCompSelFE.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStationCompSelFE() {
        BGridPane pane = new BGridPane(3);
        pane.setStretchColumn(0);
        this.stationOrdField.setRenderer((TextRenderer)new Renderer());
        this.stationOrdField.setParser((TextParser)new FormatParser());
        pane.add(null, (BValue)this.stationOrdField);
        this.linkTo((BComponent)this.stationOrdField, (Slot)BTextField.textModified, (Slot)BWbFieldEditor.setModified);
        this.stationOrdButton.setButtonStyle(BButtonStyle.toolBar);
        pane.add(null, (BValue)this.stationOrdButton);
        this.linkToStationBogButton.setButtonStyle(BButtonStyle.toolBar);
        pane.add(null, (BValue)this.linkToStationBogButton);
        this.setContent((BWidget)pane);
    }

    protected void doSetReadonly(boolean readonly) {
        this.stationOrdField.setEnabled(!readonly);
        this.stationOrdButton.setEnabled(!readonly);
        this.linkToStationBogButton.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        if (cx != null) {
            this.handleOrd = (BString)cx.getFacet("handleOrd");
            if (this.handleOrd == null) {
                this.stationOrdButton.setEnabled(false);
                this.linkToStationBogButton.setEnabled(false);
            }
        }
        this.stationOrdField.setText(value.toString());
        this.relayout();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        String str = this.stationOrdField.getText();
        return str.length() <= 0 ? BOrd.NULL : BOrd.make((String)str);
    }

    private NavTreeNode findTreeNode(NavTreeNode node, BINavNode selection) {
        if (node.getNavNode().equals(selection)) {
            return node;
        }
        NavTreeNode[] kids = node.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            NavTreeNode newNode = this.findTreeNode(kids[i], selection);
            if (newNode == null) continue;
            return newNode;
        }
        return null;
    }

    private BNiagaraStation findSupervisorStation(BNiagaraExportTag tag) {
        if (tag.getSupervisorStation().getNames().length == 0) {
            return null;
        }
        BITable table = (BITable)BOrd.make((String)("service:niagaraDriver:NiagaraNetwork|bql:select handleOrd from niagaraDriver:NiagaraStation stop where name='" + tag.getSupervisorStation().getNames()[0] + "'")).get((BObject)tag);
        BNiagaraStation station = null;
        try (TableCursor cur = table.cursor();){
            if (!cur.next()) {
                BNiagaraStation bNiagaraStation = null;
                return bNiagaraStation;
            }
            try {
                BObject obj = (BObject)cur.cell(table.getColumns().get(0));
                station = (BNiagaraStation)BOrd.make((String)obj.toString()).get((BObject)tag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return station;
    }

    private static class FormatParser
    extends TextParser {
        private FormatParser() {
        }

        protected Segment nextSegment() {
            Segment whitespace = this.parseWhitespace();
            if (whitespace != null) {
                return whitespace;
            }
            if (this.current == 37) {
                while (this.advance()) {
                    if (this.current != 37) continue;
                    this.advance();
                    return this.newSegment(6);
                }
                return this.newSegment(6);
            }
            this.advance();
            return this.newSegment(0);
        }
    }

    private static class Renderer
    extends TextRenderer {
        private Renderer() {
        }

        public BBrush getForeground(Segment seg) {
            return BTextEditorOptions.make().getColorCoding().getColor(seg).toBrush();
        }
    }

    private class TreeController
    extends NavTreeController {
        private TreeController() {
        }

        public void nodeDoubleClicked(BMouseEvent event, TreeNode node) {
            BWidgetShell shell = this.getShell();
            if (shell != null && shell instanceof BOptionDialog) {
                BOptionDialog d = (BOptionDialog)shell;
                d.getOkButton().invokeAction();
                BStationCompSelFE.this.stationOrdButton.mouseExited(new BMouseEvent());
            }
        }
    }

    private class HyperlinkToStationBogFile
    extends Command {
        public HyperlinkToStationBogFile() {
            super((BWidget)BStationCompSelFE.this, BStationCompSelFE.this.getType().getModule(), "commands.hyperlink");
        }

        public CommandArtifact doInvoke() throws Exception {
            BStationCompSelFE owner = BStationCompSelFE.this;
            BNiagaraExportTag tag = null;
            try {
                tag = (BNiagaraExportTag)BOrd.make((BOrd)BStationCompSelFE.this.getWbShell().getActiveOrd(), (String)BStationCompSelFE.this.handleOrd.toString()).get();
            }
            catch (Exception e) {
                throw new BajaException("Cannot find Niagara Export Tag Parent Component!", (Throwable)e);
            }
            tag.lease();
            if (tag.getSupervisorStation().getNames().length == 0) {
                BDialog.error((BWidget)owner, (Object)lex.getText("profileInfoFe.selectSupervisorStation"));
                return null;
            }
            BNiagaraStation supervisorStation = BStationCompSelFE.this.findSupervisorStation(tag);
            supervisorStation.lease();
            BJoinProfile profile = (BJoinProfile)supervisorStation.getMixIn(BJoinProfile.TYPE);
            profile.lease();
            profile.getComponentSpace().sync();
            BOrd stationFileOrd = profile.getProcessedStationFileOrd();
            if (stationFileOrd.isNull()) {
                BDialog.error((BWidget)owner, (Object)lex.getText("profileInfoFe.profileNoBogSelected"));
                return null;
            }
            BStationCompSelFE.this.getWbShell().hyperlink(BOrd.make((String)(stationFileOrd.toString() + "|bog:|slot:/")));
            return null;
        }
    }

    private class EditStationOrd
    extends Command {
        public EditStationOrd() {
            super((BWidget)BStationCompSelFE.this, BStationCompSelFE.this.getType().getModule(), "commands.editStation");
        }

        public CommandArtifact doInvoke() throws Exception {
            NavTreeNode treeNode;
            BComponent root;
            BStationCompSelFE owner = BStationCompSelFE.this;
            BNiagaraExportTag tag = (BNiagaraExportTag)BOrd.make((BOrd)BStationCompSelFE.this.getWbShell().getActiveOrd(), (String)BStationCompSelFE.this.handleOrd.toString()).get();
            tag.lease();
            if (tag.getSupervisorStation().getNames().length == 0) {
                BDialog.error((BWidget)owner, (Object)lex.getText("profileInfoFe.selectSupervisorStation"));
                return null;
            }
            BNiagaraStation supervisorStation = BStationCompSelFE.this.findSupervisorStation(tag);
            if (supervisorStation == null) {
                BDialog.error((BWidget)owner, (Object)lex.getText("profileInfoFe.selectSupervisorStation"));
                return null;
            }
            supervisorStation.lease();
            BJoinProfile profile = (BJoinProfile)supervisorStation.getMixIn(BJoinProfile.TYPE);
            profile.lease();
            BOrd stationFileOrd = profile.getProcessedStationFileOrd();
            if (stationFileOrd.isNull()) {
                BDialog.error((BWidget)owner, (Object)lex.getText("profileInfoFe.profileNoBogSelected"));
                return null;
            }
            BIFile stationFile = (BIFile)stationFileOrd.get((BObject)profile);
            try (ValueDocDecoder decoder = new ValueDocDecoder(stationFile);){
                root = (BComponent)decoder.decodeDocument();
            }
            BNiagaraStation[] stats = (BNiagaraStation[])root.getChildren(BNiagaraStation.class);
            if (stats.length == 0) {
                BDialog.error((BWidget)owner, (Object)lex.getText("profileInfoFe.bogNoNiagaraStation"));
                return null;
            }
            String str = BStationCompSelFE.this.stationOrdField.getText();
            BOrd stationOrd = str.length() <= 0 ? BOrd.NULL : BOrd.make((String)str);
            BNiagaraStation station = stats[0];
            BINavNode selection = null;
            if (!stationOrd.isNull()) {
                try {
                    selection = (BINavNode)stationOrd.get((BObject)station);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            BNavTree navTree = new BNavTree((NavTreeModel)new DefaultNavTreeModel((BINavNode)root));
            navTree.setController((javax.baja.ui.tree.TreeController)new TreeController());
            if (selection != null) {
                treeNode = BStationCompSelFE.this.findTreeNode((NavTreeNode)navTree.getModel().getRoot(0), selection);
                if (treeNode != null) {
                    navTree.expandToNode((TreeNode)treeNode);
                    navTree.getSelection().select((TreeNode)treeNode);
                }
            } else {
                treeNode = BStationCompSelFE.this.findTreeNode((NavTreeNode)navTree.getModel().getRoot(0), (BINavNode)((BComponent[])station.getChildren(BComponent.class))[0]);
                if (treeNode != null) {
                    navTree.expandToNode((TreeNode)treeNode);
                }
            }
            BConstrainedPane navPane = new BConstrainedPane((BWidget)new BScrollPane((BWidget)new BBorderPane((BWidget)navTree, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0))));
            navPane.setMinSize(BSize.make((double)300.0, (double)400.0));
            if (BDialog.open((BWidget)owner, (String)lex.getText("profileInfoFe.selectParentTarget"), (Object)navPane, (int)3) == 1) {
                NavTreeNode selectedNode = (NavTreeNode)navTree.getSelection().getNode();
                if (selectedNode == null) {
                    BStationCompSelFE.this.stationOrdField.setText("");
                } else {
                    BComponent sel = (BComponent)selectedNode.getNavNode();
                    BStationCompSelFE.this.stationOrdField.setText(ExportTagUtil.getRelativeSlotPath((BComponent)station, (BComponent)sel));
                }
            }
            return null;
        }
    }
}

