/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.ui;

import com.tridium.exporttags.tags.px.BPxViewTag;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.nd.ui.px.BAbstractSubstitutePxView;
import com.tridium.nd.util.BSimpleMap;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import javax.baja.gx.BSize;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public final class BSubstituteOrdsFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BSubstituteOrdsFE.class);
    private BButton viewButton = new BButton((Command)new ViewSubOrds());
    private BButton editButton;
    private BButton deleteButton;
    private Model tableModel;
    private Array<OrdData> ordDataArray = new Array(OrdData.class);
    private Context cx;
    private static final Lexicon lex = Lexicon.make(BSubstituteOrdsFE.class);
    private static final UiLexicon uilex = UiLexicon.bajaui();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSubstituteOrdsFE() {
        this.setContent((BWidget)this.viewButton);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.cx = cx;
        BSimpleMap ordMap = (BSimpleMap)value;
        BSimple[] keys = ordMap.list();
        this.ordDataArray.clear();
        for (int i = 0; i < keys.length; ++i) {
            this.ordDataArray.add((Object)new OrdData((BOrd)keys[i], (BOrd)ordMap.get(keys[i])));
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        LinkedHashMap<BOrd, BOrd> map = new LinkedHashMap<BOrd, BOrd>();
        OrdData[] datas = (OrdData[])this.ordDataArray.trim();
        for (int i = 0; i < datas.length; ++i) {
            map.put(datas[i].oldOrd, datas[i].newOrd);
        }
        return BSimpleMap.make(map);
    }

    private static BDialog findDialog(BWidget w) {
        if (w == null) {
            return null;
        }
        if (w instanceof BDialog) {
            return (BDialog)w;
        }
        return BSubstituteOrdsFE.findDialog((BWidget)w.getParent());
    }

    private boolean isOrdOldPresent(OrdData newData) {
        for (OrdData data : this.ordDataArray) {
            if (!data.oldOrd.equals((Object)newData.oldOrd)) continue;
            return true;
        }
        return false;
    }

    private static class OrdData {
        BOrd oldOrd = BOrd.NULL;
        BOrd newOrd = BOrd.NULL;

        OrdData(BOrd oldOrd, BOrd newOrd) {
            this.oldOrd = oldOrd;
            this.newOrd = newOrd;
        }

        public String toString() {
            return this.oldOrd.toString() + this.newOrd.toString();
        }
    }

    private class Selection
    extends TableSelection {
        private Selection() {
        }

        public void updateTable() {
            TableSelection sel = BSubstituteOrdsFE.this.tableModel.getSelection();
            if (BSubstituteOrdsFE.this.editButton != null && BSubstituteOrdsFE.this.deleteButton != null) {
                if (!BSubstituteOrdsFE.this.isReadonly() && sel != null && sel.getRow() > -1) {
                    BSubstituteOrdsFE.this.editButton.setEnabled(true);
                    BSubstituteOrdsFE.this.deleteButton.setEnabled(true);
                } else {
                    BSubstituteOrdsFE.this.editButton.setEnabled(false);
                    BSubstituteOrdsFE.this.deleteButton.setEnabled(false);
                }
            }
            super.updateTable();
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            if (event.getModifiersEx() != 0) {
                return;
            }
            if (event.getKeyCode() == 127) {
                this.handleDelete(event);
            }
        }

        protected void handleEscape(BKeyEvent event) {
            BDialog dlg = BSubstituteOrdsFE.findDialog((BWidget)this.getTable());
            dlg.close();
            super.handleEscape(event);
        }

        protected void handleEnter(BKeyEvent event) {
            if (BSubstituteOrdsFE.this.editButton != null && BSubstituteOrdsFE.this.editButton.isEnabled() && !BSubstituteOrdsFE.this.isReadonly()) {
                BSubstituteOrdsFE.this.editButton.invokeAction();
            }
            super.handleEnter(event);
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (BSubstituteOrdsFE.this.editButton != null && BSubstituteOrdsFE.this.editButton.isEnabled() && !BSubstituteOrdsFE.this.isReadonly()) {
                BSubstituteOrdsFE.this.editButton.invokeAction();
            }
        }

        private void handleDelete(BKeyEvent event) {
            if (BSubstituteOrdsFE.this.deleteButton != null && BSubstituteOrdsFE.this.deleteButton.isEnabled() && !BSubstituteOrdsFE.this.isReadonly()) {
                BSubstituteOrdsFE.this.deleteButton.invokeAction();
            }
        }
    }

    private class Model
    extends TableModel {
        private Model() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            return col == 0 ? lex.getText("substituteOrdsFe.oldOrds") : lex.getText("substituteOrdsFe.newOrds");
        }

        public int getRowCount() {
            return BSubstituteOrdsFE.this.ordDataArray.size();
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ((OrdData)((BSubstituteOrdsFE)BSubstituteOrdsFE.this).ordDataArray.get((int)row)).oldOrd;
            }
            return ((OrdData)((BSubstituteOrdsFE)BSubstituteOrdsFE.this).ordDataArray.get((int)row)).newOrd;
        }
    }

    private static class Visitor
    implements BAbstractSubstitutePxView.IPxOrdVisitor {
        Array<BOrd> ordArray = new Array(BOrd.class);

        private Visitor() {
        }

        public boolean handlePreprocessOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            if (this.ordArray.indexOf((Object)ord) == -1) {
                this.ordArray.add((Object)ord);
            }
            return true;
        }

        public void handleFileOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
        }

        public void handleHistoryOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
        }

        public void handleModuleOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
        }

        public void handleVirtualOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
        }

        public void handleHyperlinkOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
        }

        public void handleUnknownOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
        }

        public void handleOverrideOrd(BComplex clx, Property prop, BOrd ord, BOrd overrideOrd) throws Exception {
        }
    }

    private class Choose
    extends Command {
        public Choose() {
            super((BWidget)BSubstituteOrdsFE.this, lex.getText("commands.chooseSubstituteOrds.label"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BOrd[] ords;
            try {
                BSubstituteOrdsFE.this.enterBusy();
                BWbShell shell = BSubstituteOrdsFE.this.getWbShell();
                BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (String)BSubstituteOrdsFE.this.cx.getFacet("handleOrd").toString());
                BPxViewTag tag = (BPxViewTag)ord.get();
                tag.lease();
                Visitor v = new Visitor();
                tag.startProcessPx(v);
                ords = (BOrd[])v.ordArray.filter(new IFilter(){

                    public boolean accept(Object obj) {
                        BOrd ord = (BOrd)obj;
                        ListIterator it = BSubstituteOrdsFE.this.ordDataArray.iterator();
                        while (it.hasNext()) {
                            if (!((OrdData)it.next()).oldOrd.equals((Object)ord)) continue;
                            return false;
                        }
                        return true;
                    }
                }).trim();
            }
            catch (ExportTagException e) {
                throw new BajaException(BFormat.format((String)e.getMessage(), (Object)((Object)this)));
            }
            finally {
                BSubstituteOrdsFE.this.exitBusy();
            }
            if (ords != null && ords.length > 0) {
                BCheckList list = new BCheckList();
                list.setMultipleSelection(false);
                for (int i = 0; i < ords.length; ++i) {
                    list.addItem((Object)ords[i]);
                }
                BConstrainedPane pane = new BConstrainedPane();
                pane.setMinSize(BSize.make((double)400.0, (double)300.0));
                pane.setContent((BWidget)list);
                if (BDialog.open((BWidget)BSubstituteOrdsFE.this, (String)lex.getText("commands.chooseSubstituteOrds.label"), (Object)pane, (int)3) == 1) {
                    Object[] selection = list.getSelectedItems();
                    if (selection.length > 0) {
                        for (int i = 0; i < selection.length; ++i) {
                            BSubstituteOrdsFE.this.ordDataArray.add((Object)new OrdData((BOrd)selection[i], BOrd.NULL));
                        }
                        BSubstituteOrdsFE.this.setModified();
                        BSubstituteOrdsFE.this.tableModel.updateTable(true);
                    }
                    if (selection.length == 1) {
                        BSubstituteOrdsFE.this.tableModel.getSelection().select(BSubstituteOrdsFE.this.ordDataArray.size() - 1, true);
                        BSubstituteOrdsFE.this.editButton.invokeAction();
                    }
                }
            } else {
                BDialog.error((BWidget)BSubstituteOrdsFE.this, (Object)lex.getText("commands.chooseSubstituteOrds.noMoreOrds"));
            }
            return null;
        }
    }

    private class Delete
    extends Command {
        public Delete() {
            super((BWidget)BSubstituteOrdsFE.this, lex.getText("commands.deleteSubstituteOrds.label"));
        }

        public CommandArtifact doInvoke() throws Exception {
            TableSelection sel = BSubstituteOrdsFE.this.tableModel.getSelection();
            int[] rows = sel.getRows();
            if (rows.length == 0) {
                return null;
            }
            Array removeOrdDataArray = new Array(OrdData.class);
            for (int i = 0; i < rows.length; ++i) {
                removeOrdDataArray.add(BSubstituteOrdsFE.this.ordDataArray.get(rows[i]));
            }
            BSubstituteOrdsFE.this.ordDataArray = BSubstituteOrdsFE.this.ordDataArray.removeAll(removeOrdDataArray.trim());
            sel.deselectAll();
            BSubstituteOrdsFE.this.tableModel.updateTable(true);
            BSubstituteOrdsFE.this.setModified();
            return null;
        }
    }

    private class Edit
    extends Command {
        public Edit() {
            super((BWidget)BSubstituteOrdsFE.this, lex.getText("commands.editSubstituteOrds.label"));
        }

        public CommandArtifact doInvoke() throws Exception {
            TableSelection sel = BSubstituteOrdsFE.this.tableModel.getSelection();
            Object[] vals = BSubstituteOrdsFE.this.tableModel.getRowValues(sel.getRow());
            BOrd oldOrd = (BOrd)vals[0];
            BOrd newOrd = (BOrd)vals[1];
            BWbFieldEditor ed1 = BWbFieldEditor.makeFor((BObject)BOrd.NULL);
            ed1.loadValue((BObject)oldOrd);
            BWbFieldEditor ed2 = BWbFieldEditor.makeFor((BObject)BOrd.NULL);
            ed2.loadValue((BObject)newOrd);
            BGridPane gridPane = new BGridPane(2);
            gridPane.add(null, (BValue)new BLabel(lex.getText("substituteOrdsFe.oldOrd")));
            gridPane.add(null, (BValue)ed1);
            gridPane.add(null, (BValue)new BLabel(lex.getText("substituteOrdsFe.newOrd")));
            gridPane.add(null, (BValue)ed2);
            if (BDialog.open((BWidget)this.getOwner(), (String)lex.getText("commands.editSubstituteOrds.label"), (Object)gridPane, (int)3) == 1) {
                OrdData data = new OrdData((BOrd)ed1.saveValue(), (BOrd)ed2.saveValue());
                if (oldOrd.equals((Object)data.oldOrd) || !BSubstituteOrdsFE.this.isOrdOldPresent(data)) {
                    BSubstituteOrdsFE.this.ordDataArray.set(sel.getRow(), (Object)data);
                    BSubstituteOrdsFE.this.tableModel.updateTable();
                    BSubstituteOrdsFE.this.setModified();
                } else {
                    BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("substituteOrdsFe.oldOrdAlreadyPresent", new Object[]{data.oldOrd.toString()}));
                }
            }
            return null;
        }
    }

    private class New
    extends Command {
        public New() {
            super((BWidget)BSubstituteOrdsFE.this, lex.getText("commands.newSubstituteOrds.label"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbFieldEditor ed1 = BWbFieldEditor.makeFor((BObject)BOrd.NULL);
            ed1.loadValue((BObject)BOrd.NULL);
            BWbFieldEditor ed2 = BWbFieldEditor.makeFor((BObject)BOrd.NULL);
            ed2.loadValue((BObject)BOrd.NULL);
            BGridPane gridPane = new BGridPane(2);
            gridPane.add(null, (BValue)new BLabel(lex.getText("substituteOrdsFe.oldOrd")));
            gridPane.add(null, (BValue)ed1);
            gridPane.add(null, (BValue)new BLabel(lex.getText("substituteOrdsFe.newOrd")));
            gridPane.add(null, (BValue)ed2);
            if (BDialog.open((BWidget)this.getOwner(), (String)lex.getText("commands.newSubstituteOrds.label"), (Object)gridPane, (int)3) == 1) {
                OrdData data = new OrdData((BOrd)ed1.saveValue(), (BOrd)ed2.saveValue());
                if (!BSubstituteOrdsFE.this.isOrdOldPresent(data)) {
                    BSubstituteOrdsFE.this.ordDataArray.add((Object)data);
                    BSubstituteOrdsFE.this.tableModel.updateTable(true);
                    BSubstituteOrdsFE.this.setModified();
                } else {
                    BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("substituteOrdsFe.oldOrdAlreadyPresent", new Object[]{data.oldOrd.toString()}));
                }
            }
            return null;
        }
    }

    private class Ok
    extends Command {
        public Ok(BWidget owner, String text) {
            super(owner, text);
        }

        public CommandArtifact doInvoke() throws Exception {
            BDialog dlg = BSubstituteOrdsFE.findDialog(this.getOwner());
            dlg.close();
            return null;
        }
    }

    private class ViewSubOrds
    extends Command {
        public ViewSubOrds() {
            super((BWidget)BSubstituteOrdsFE.this, BSubstituteOrdsFE.this.getType().getModule(), "commands.viewSubstituteOrds");
        }

        public CommandArtifact doInvoke(CommandEvent event) throws Exception {
            BEdgePane edgePane = new BEdgePane();
            BSubstituteOrdsFE.this.tableModel = new Model();
            BTable table = new BTable((TableModel)BSubstituteOrdsFE.this.tableModel, (TableController)new Controller());
            table.setSelection((TableSelection)new Selection());
            edgePane.setCenter((BWidget)table);
            BGridPane buttonPane = new BGridPane();
            Ok okCmd = new Ok((BWidget)buttonPane, uilex.getText("dialog.ok"));
            BButton okButton = new BButton((Command)okCmd);
            buttonPane.add(null, (BValue)okButton);
            if (!BSubstituteOrdsFE.this.isReadonly()) {
                BButton newButton = new BButton((Command)new New());
                buttonPane.add(null, (BValue)newButton);
                if (BSubstituteOrdsFE.this.cx != null && BSubstituteOrdsFE.this.cx.getFacet("handleOrd") != null) {
                    BButton chooseButton = new BButton((Command)new Choose());
                    buttonPane.add(null, (BValue)chooseButton);
                }
                BSubstituteOrdsFE.this.editButton = new BButton((Command)new Edit());
                BSubstituteOrdsFE.this.editButton.setEnabled(false);
                buttonPane.add(null, (BValue)BSubstituteOrdsFE.this.editButton);
                BSubstituteOrdsFE.this.deleteButton = new BButton((Command)new Delete());
                BSubstituteOrdsFE.this.deleteButton.setEnabled(false);
                buttonPane.add(null, (BValue)BSubstituteOrdsFE.this.deleteButton);
            }
            buttonPane.setColumnCount(((BButton[])buttonPane.getChildren(BButton.class)).length);
            edgePane.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 5.0, 5.0, 0.0, 5.0));
            BConstrainedPane pane = new BConstrainedPane();
            pane.setMinSize(BSize.make((double)640.0, (double)480.0));
            pane.setMaxSize(BSize.make((double)1024.0, (double)768.0));
            pane.setContent((BWidget)edgePane);
            BDialog.open((BWidget)BSubstituteOrdsFE.this, (String)lex.getText("commands.viewSubstituteOrds.label"), (Object)pane, (int)0);
            return null;
        }
    }
}

