/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp;

import com.tridium.nSnmp.BSnmpAgent;
import com.tridium.nSnmp.datatypes.BCreateMibParameters;
import com.tridium.nSnmp.datatypes.BSnmpVersions;
import com.tridium.nSnmp.util.LocalToMib;
import java.io.OutputStreamWriter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;

@NiagaraType
@NiagaraProperty(name="servletName", type="String", defaultValue="snmp", flags=1, override=true)
public class BSnmpMibServer
extends BWebServlet {
    @Generated
    public static final Property servletName = BSnmpMibServer.newProperty((int)1, (String)"snmp", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpMibServer.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doGet(WebOp op) throws Exception {
        op.setContentType("text/plain");
        OutputStreamWriter os = new OutputStreamWriter(op.getOutputStream());
        os.write(this.getMib(op));
        os.flush();
    }

    String getMib(WebOp op) {
        String enterprise;
        BSnmpAgent locDev = (BSnmpAgent)this.getParent();
        BCreateMibParameters p = new BCreateMibParameters();
        p.setFileName("TRIDIUMR3-MIB.my");
        if (op.getViewParameter("version", "v1").equals("v2")) {
            p.setVersion(BSnmpVersions.v2);
        }
        if ((enterprise = op.getViewParameter("enterprise", null)) != null) {
            p.setEnterprise(Integer.parseInt(enterprise));
        }
        return LocalToMib.createMib(locDev, p);
    }
}

