/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.messages;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.datatypes.BNetworkManagerConfiguration;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.services.BSnmpRecipient;
import com.tridium.nSnmp.snmptypes.SnmpInt;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpString;
import com.tridium.nSnmp.snmptypes.SnmpTimeticks;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import java.net.InetAddress;
import javax.baja.sys.Sys;

public class SnmpTrap
extends SnmpPDU {
    protected BSnmpNetwork snmp;
    private int port = 162;
    private InetAddress managerIp;
    private int snmpVersion;
    protected int genericType;
    private int specificType;
    private String community;
    public static final int COLD_START = 0;
    public static final int WARM_START = 1;
    public static final int LINK_DOWN = 2;
    public static final int AUTHENTICATION_FAILURE = 4;
    public static final int LINK_UP = 3;
    public static final int EGP_NEIGHBOR_LOSS = 5;
    public static final int ENTERPRISE_SPECIFIC = 6;

    public SnmpTrap(BSnmpNetwork snmp, int genericType, int specificType) {
        this.genericType = genericType;
        this.specificType = specificType;
        this.snmp = snmp;
        this.managerIp = snmp.getManagerIp();
        this.port = snmp.getDefaultNetworkManagerTrapsPort();
        this.snmpVersion = snmp.getDefaultNetworkManagerSnmpVersion();
        this.community = snmp.getDefaultNetworkManagerTrapsCommunity();
        this.init();
    }

    public SnmpTrap(BSnmpRecipient recipient, int genericType, int specificType) {
        this.genericType = genericType;
        this.specificType = specificType;
        this.snmp = recipient.snmp();
        BNetworkManagerConfiguration cnfig = recipient.getNetworkManagerConfig();
        this.managerIp = cnfig.getManagerIp();
        this.port = cnfig.getNetworkManagerTrapsPort();
        this.snmpVersion = cnfig.getNetworkManagerSnmpVersion();
        this.community = cnfig.getNetworkManagerTrapsCommunity();
        this.init();
    }

    private void init() {
        block9: {
            if (this.snmpVersion == 2 || this.snmpVersion == 3) {
                this.addVariableBinding(new SnmpVarBind(new SnmpOID("1.3.6.1.2.1.1.3.0"), new SnmpTimeticks(this.snmp.getTimeTick())));
                if (this.genericType != 6) {
                    this.addVariableBinding(new SnmpVarBind(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0"), new SnmpOID("1.3.6.1.6.3.1.1.5.1")));
                } else {
                    this.addVariableBinding(new SnmpVarBind(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0"), new SnmpOID("1.3.6.1.4.1.4131.1.8.1")));
                }
            }
            switch (this.snmpVersion) {
                case 3: {
                    this.setVersion(3);
                    this.setCommand(167);
                    break;
                }
                case 2: {
                    this.setVersion(1);
                    this.setCommand(167);
                    break;
                }
                default: {
                    this.setVersion(0);
                    this.setCommand(164);
                }
            }
            this.setCommunity(this.community);
            try {
                this.setEnterprise(new SnmpOID(this.genericType >= 0 && this.genericType <= 5 ? "1.3.6.1.2.1.11" : "1.3.6.1.4.1.4131.1"));
                this.setSourceIp(Sys.getLocalHost((InetAddress)this.managerIp));
                this.setDestinationIp(this.managerIp);
                this.setTrapType(this.genericType);
                this.setSpecificType(this.specificType);
            }
            catch (Exception e) {
                if (this.snmp == null) break block9;
                this.snmp.log().severe("Unable to create SnmpTrap - " + e.toString());
            }
        }
    }

    public synchronized void send() {
        block2: {
            try {
                this.setRemotePort(this.port);
                this.setUpTime(this.snmp.getTimeTick());
                this.snmp.sendTraps(this);
            }
            catch (Exception e) {
                if (this.snmp == null) break block2;
                this.snmp.log().severe("Unable to send SnmpTrap - " + e.toString());
            }
        }
    }

    public void addStringVariable(String sOid, String value) {
        SnmpOID oid = new SnmpOID(sOid);
        SnmpString var = new SnmpString(value);
        this.addVariableBinding(new SnmpVarBind(oid, var));
    }

    public void addIntegerVariable(String sOid, int value) {
        SnmpOID oid = new SnmpOID(sOid);
        SnmpInt var = new SnmpInt(value);
        this.addVariableBinding(new SnmpVarBind(oid, var));
    }
}

