/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.mib;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.mib.MibConst;
import com.tridium.nSnmp.mib.MibObject;
import com.tridium.nSnmp.snmptypes.SnmpConst;
import com.tridium.nSnmp.snmptypes.SnmpInt;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpString;
import com.tridium.nSnmp.snmptypes.SnmpTimeticks;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;

public class MibIISystem
implements MibObject,
SnmpConst,
MibConst {
    private BSnmpNetwork snmp;
    public static final int LEVEL = 7;
    public static final int DESCR = 1;
    public static final int OBJECT_ID = 2;
    public static final int UP_TIME = 3;
    public static final int CONTACT = 4;
    public static final int NAME = 5;
    public static final int LOCATION = 6;
    public static final int SERVICES = 7;

    public MibIISystem(BSnmpNetwork snmp) {
        this.snmp = snmp;
    }

    public BSnmpNetwork snmp() {
        return this.snmp;
    }

    @Override
    public SnmpVar getValue(SnmpOID oid) {
        long[] aOid = oid.toLongArray();
        SnmpVar var = null;
        switch ((int)aOid[7]) {
            case 1: {
                var = new SnmpString("Tridium station");
                break;
            }
            case 2: {
                var = new SnmpOID("1.3.6.1.4.1.4131.1");
                break;
            }
            case 3: {
                var = new SnmpTimeticks(this.snmp().getTimeTick());
                break;
            }
            case 4: {
                var = new SnmpString(this.snmp().getContact());
                break;
            }
            case 5: {
                var = new SnmpString(this.snmp().getSystemName());
                break;
            }
            case 6: {
                var = new SnmpString(this.snmp().getLocation());
                break;
            }
            case 7: {
                var = new SnmpInt(72);
                break;
            }
            default: {
                return null;
            }
        }
        return var;
    }

    @Override
    public int validateForSet(SnmpVarBind varbind) {
        SnmpOID oid = varbind.getObjectID();
        long[] aOid = oid.toLongArray();
        try {
            switch ((int)aOid[7]) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    return 17;
                }
                case 4: {
                    ((SnmpString)varbind.getVariable()).toValue();
                    break;
                }
                case 5: {
                    ((SnmpString)varbind.getVariable()).toValue();
                    break;
                }
                case 6: {
                    ((SnmpString)varbind.getVariable()).toValue();
                    break;
                }
                default: {
                    return 6;
                }
            }
        }
        catch (Exception e) {
            return 7;
        }
        return 0;
    }

    @Override
    public int setValue(SnmpVarBind varbind, SnmpPDU resp) {
        SnmpOID oid = varbind.getObjectID();
        long[] aOid = oid.toLongArray();
        SnmpString var = null;
        try {
            switch ((int)aOid[7]) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    return 4;
                }
                case 4: {
                    this.snmp().setContact(((SnmpString)varbind.getVariable()).toValue());
                    var = new SnmpString(this.snmp().getContact());
                    break;
                }
                case 5: {
                    this.snmp().setSystemName(((SnmpString)varbind.getVariable()).toValue());
                    var = new SnmpString(this.snmp().getSystemName());
                    break;
                }
                case 6: {
                    this.snmp().setLocation(((SnmpString)varbind.getVariable()).toValue());
                    var = new SnmpString(this.snmp().getLocation());
                    break;
                }
                default: {
                    return 2;
                }
            }
        }
        catch (Exception e) {
            return 3;
        }
        resp.addVariableBinding(new SnmpVarBind(oid, var));
        return 0;
    }

    @Override
    public SnmpOID getNextOid(SnmpOID oid) {
        long[] aOid = oid.toLongArray();
        if (aOid.length <= 8) {
            return new SnmpOID("1.3.6.1.2.1.1.1.0.0");
        }
        if (aOid[7] >= 7L) {
            return null;
        }
        aOid[7] = aOid[7] + 1L;
        return new SnmpOID(aOid);
    }
}

