/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.mib;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.mib.MibObject;
import com.tridium.nSnmp.mib.table.PointEntry;
import com.tridium.nSnmp.mib.table.PointTable;
import com.tridium.nSnmp.object.BSnmpObjectExt;
import com.tridium.nSnmp.snmptypes.SnmpConst;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;

public class NiagObject
implements MibObject,
SnmpConst {
    public static final int LEVEL = 9;
    PointTable pt;

    public NiagObject(BSnmpNetwork snmp, PointTable pt) {
        this.pt = pt;
    }

    @Override
    public SnmpVar getValue(SnmpOID oid) {
        try {
            int ndx = this.getIndex(oid);
            if (ndx == -1) {
                return null;
            }
            PointEntry entry = (PointEntry)this.pt.getObject(ndx);
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int getIndex(SnmpOID oid) {
        long[] aOid = oid.toLongArray();
        if (aOid.length <= 9) {
            return -1;
        }
        return (int)aOid[9];
    }

    @Override
    public SnmpOID getNextOid(SnmpOID oid) {
        try {
            long[] aOid = oid.toLongArray();
            if (aOid.length <= 9) {
                return new SnmpOID("1.3.6.1.4.1.4131.1.1.0.0");
            }
            PointEntry entry = (PointEntry)this.pt.getNextEntry((int)aOid[9]);
            if (entry == null) {
                return null;
            }
            return new SnmpOID(((BSnmpObjectExt)entry).getObjectIdentifier());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int validateForSet(SnmpVarBind varbind) {
        SnmpOID oid = varbind.getObjectID();
        int ndx = this.getIndex(oid);
        PointEntry entry = (PointEntry)this.pt.getObject(ndx);
        if (entry == null) {
            return 6;
        }
        if (!entry.isSettablePoint()) {
            return 17;
        }
        try {
            entry.tryDecodeForSet(varbind.getVariable());
        }
        catch (Throwable e) {
            return 7;
        }
        return 0;
    }

    @Override
    public int setValue(SnmpVarBind varbind, SnmpPDU resp) {
        try {
            SnmpOID oid = varbind.getObjectID();
            int ndx = this.getIndex(oid);
            PointEntry entry = (PointEntry)this.pt.getObject(ndx);
            if (entry == null) {
                return 2;
            }
            if (!entry.isSettablePoint()) {
                return 4;
            }
            SnmpVar s = entry.setValue(varbind.getVariable());
            if (s == null) {
                return 3;
            }
            resp.addVariableBinding(new SnmpVarBind(oid, s));
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 3;
        }
    }
}

