/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.snmptypes;

import com.tridium.nSnmp.snmptypes.ASNOutput;
import com.tridium.nSnmp.snmptypes.SnmpConst;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SnmpDate
extends SnmpVar
implements SnmpConst {
    private byte[] value;
    public static SimpleDateFormat CALFORMAT = new SimpleDateFormat("yyyy-M-d,HH:mm:ss.SS,z");

    public SnmpDate(byte[] a) {
        this.type = 4;
        this.value = a;
    }

    public SnmpDate(String val) {
        this.type = 4;
        this.value = val.getBytes();
    }

    @Override
    public String toTagString() {
        return "STRING: " + new String(this.value);
    }

    @Override
    public void encode(ASNOutput out) {
        out.addOctetString(this.value);
    }

    public String toValue() {
        return new String(this.value);
    }

    public String toString() {
        return new String(this.value);
    }

    @Override
    public String toStringValue() {
        return new String(this.value);
    }

    public String toCalendar() throws RuntimeException {
        Calendar cal = this.getCalendar();
        Date date = cal.getTime();
        return CALFORMAT.format(date);
    }

    public Calendar getCalendar() throws RuntimeException {
        Calendar cal = Calendar.getInstance();
        if (this.value.length == 8 || this.value.length == 11) {
            int year = (int)(this.getPositiveValue(0) * 256L + this.getPositiveValue(1));
            int month = this.value[2] - 1;
            byte day = this.value[3];
            byte hour = this.value[4];
            byte min = this.value[5];
            byte sec = this.value[6];
            int msec = this.value[7] * 100;
            cal.set(year, month, day, hour, min, sec);
            cal.set(14, msec);
            if (this.value.length == 11) {
                char dir = (char)this.value[8];
                byte hourUTC = this.value[9];
                byte minUTC = this.value[10];
                int secUTC = hourUTC * 60 * 60;
                int msecGMT = secUTC * 1000;
                if (dir == '-') {
                    msecGMT *= -1;
                }
                cal.set(15, msecGMT);
            }
        } else {
            throw new RuntimeException("Octets is not DateAndTime");
        }
        return cal;
    }

    private long getPositiveValue(int index) {
        long val = this.value[index];
        if (val < 0L) {
            val += 256L;
        }
        return val;
    }
}

