/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.comm.SnmpListener;
import com.tridium.nSnmp.version3.dispatcher.SnmpDispatcher;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.nSnmp.version3.messageProcessingModel.SnmpMessageProcessingModel;
import com.tridium.nSnmp.version3.messageProcessingModel.SnmpMessageProcessingModelFactory;
import java.util.HashMap;
import java.util.Map;

public class SnmpV3Communicator {
    private BSnmpNetwork snmpNetwork;
    private static Map<BSnmpNetwork, SnmpV3Communicator> mapBSnmpV3Communicator = new HashMap<BSnmpNetwork, SnmpV3Communicator>();

    private SnmpV3Communicator(BSnmpNetwork snmpNet) {
        this.snmpNetwork = snmpNet;
    }

    public static SnmpV3Communicator getBSnmpV3CommunicatorInstance(BSnmpNetwork snmpNetwork) {
        SnmpV3Communicator communicator = mapBSnmpV3Communicator.get(snmpNetwork);
        if (communicator == null) {
            communicator = new SnmpV3Communicator(snmpNetwork);
            mapBSnmpV3Communicator.put(snmpNetwork, communicator);
        }
        return communicator;
    }

    public SnmpV3Message sendMessage(SnmpV3Message msg) throws Exception {
        SnmpV3Message responseMessage = null;
        SnmpMessageProcessingModel messageProcessingModel = SnmpMessageProcessingModelFactory.getBSnmpMessageProcessingModelInstance(3);
        SnmpDispatcher dispatcher = SnmpDispatcher.getBSnmpDispatcherInstance(messageProcessingModel, this.snmpNetwork);
        responseMessage = dispatcher.sendPDU(msg);
        return responseMessage;
    }

    public void sendResponseMessage(SnmpV3Message msg, SnmpListener listener) {
        SnmpMessageProcessingModel messageProcessingModel = SnmpMessageProcessingModelFactory.getBSnmpMessageProcessingModelInstance(3);
        SnmpDispatcher dispatcher = SnmpDispatcher.getBSnmpDispatcherInstance(messageProcessingModel, this.snmpNetwork);
        dispatcher.listenAndRespondSNMPMessage(msg, listener);
    }
}

