/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.securityModel.usm;

import com.tridium.nSnmp.messages.SnmpV3AlarmTrap;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.nSnmp.version3.securityModel.usm.authentication.UsmAuthUtil;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.AES128;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.AES192;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.AES256;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.DESPrivacy;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.UsmPrivacy;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUser;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUserTable;
import java.security.AccessController;
import javax.baja.security.BPassword;

public class UsmSecurity {
    private static final int MAXLEN_USMUSERNAME = 32;
    private static UsmSecurity usmSecurityInstance;

    private UsmSecurity() {
    }

    public static UsmSecurity getUsmSecurityInstance() {
        if (usmSecurityInstance == null) {
            usmSecurityInstance = new UsmSecurity();
        }
        return usmSecurityInstance;
    }

    private byte[] buildWhoelMsg(SnmpV3Message outGoingMsg) {
        byte[] wholeMsg = outGoingMsg.encodeData();
        return wholeMsg;
    }

    private byte[] buildWhoelMsg(SnmpV3AlarmTrap outGoingMsg) {
        byte[] wholeMsg = outGoingMsg.encodeData();
        return wholeMsg;
    }

    public int generateRequestMsg(SnmpV3Message outGoingMessage) {
        int msgAuthoritativeEngineBoots = outGoingMessage.getMsgAuthoritativeEngineBoots();
        int msgAuthoritativeEngineTime = outGoingMessage.getMsgAuthoritativeEngineTime();
        byte[] engineId = outGoingMessage.getMsgAuthoritativeEngineID();
        int securityLevel = outGoingMessage.getMsgFlag() & 3;
        if (securityLevel == 3) {
            String authProtocol = outGoingMessage.getAuthProtocol().toUpperCase();
            String privacyProtcol = outGoingMessage.getPrivacyProtocol().toUpperCase();
            UsmPrivacy privProtocol = UsmSecurity.getPrivacyProtocolInstance(privacyProtcol);
            if (securityLevel >= 1 && authProtocol == null || securityLevel == 3 && privacyProtcol == null) {
                return 1403;
            }
            String privPass = outGoingMessage.getPrivacykey();
            byte[] privKey = UsmAuthUtil.passwordTokey(authProtocol.toUpperCase(), privPass.getBytes(), engineId, privacyProtcol);
            byte[] praivacyParam = new byte[]{};
            outGoingMessage.setMsgAuthenticationParameters(new byte[0]);
            outGoingMessage.setMsgPrivacyParameter(new byte[0]);
            byte[] scopedPduBytes = outGoingMessage.encodeScopedPduData();
            byte[] encryptedScopedData = privProtocol.encryptMsg(scopedPduBytes, privKey, msgAuthoritativeEngineBoots, msgAuthoritativeEngineTime, praivacyParam);
            if (encryptedScopedData == null) {
                return 1405;
            }
            praivacyParam = privProtocol.getPrivacyParam();
            outGoingMessage.setEncryptedPdu(encryptedScopedData);
            outGoingMessage.setMsgPrivacyParameter(praivacyParam);
        } else {
            outGoingMessage.setMsgPrivacyParameter(new byte[0]);
        }
        byte[] blankDigest = new byte[12];
        if (securityLevel >= 1) {
            String authProtocol = outGoingMessage.getAuthProtocol().toUpperCase();
            String authPass = outGoingMessage.getAuthKey();
            outGoingMessage.setMsgAuthenticationParameters(blankDigest);
            byte[] wholeMsg = this.buildWhoelMsg(outGoingMessage);
            byte[] authKey = UsmAuthUtil.passwordTokey(authProtocol.toUpperCase(), authPass.getBytes(), engineId);
            byte[] macDigest = UsmAuthUtil.authenticateOutgoingMsg(authProtocol, authKey, wholeMsg);
            outGoingMessage.setMsgAuthenticationParameters(macDigest);
        } else {
            outGoingMessage.setMsgAuthenticationParameters(new byte[0]);
            outGoingMessage.setMsgPrivacyParameter(new byte[0]);
        }
        return 0;
    }

    public int generateResponseMsg(SnmpV3Message responseMsg) {
        int securityLevel = responseMsg.getMsgFlag() & 3;
        byte[] securityEngineID = responseMsg.getMsgAuthoritativeEngineID();
        String userSecurityName = responseMsg.getUserSecurityName();
        byte[] secEngineId = null;
        if (securityEngineID.length != 0) {
            secEngineId = securityEngineID;
        }
        String securityName = new String(userSecurityName);
        BUsmUser user = null;
        if (secEngineId == null || secEngineId.length == 0) {
            return 1410;
        }
        user = UsmSecurity.getUser(securityName);
        if (user == null) {
            return 1404;
        }
        if (userSecurityName.length() > 32) {
            return 1401;
        }
        String authProtocol = user.getAuthenticationProtocol().getTag().toUpperCase();
        String privacyProtcol = user.getPrivacyProtocol().getTag().toUpperCase();
        UsmPrivacy privProtocol = UsmSecurity.getPrivacyProtocolInstance(privacyProtcol);
        if (securityLevel >= 1 && authProtocol == null || securityLevel == 3 && privacyProtcol == null) {
            return 1403;
        }
        String authPass = AccessController.doPrivileged(() -> ((BPassword)user.getAuthenticationPassphrase()).getValue());
        byte[] engineId = UsmSecurity.hexStringToByteArray(user.getEngineID());
        byte[] authKey = UsmAuthUtil.passwordTokey(authProtocol.toUpperCase(), authPass.getBytes(), engineId);
        String privPass = AccessController.doPrivileged(() -> ((BPassword)user.getPrivacyPassphrase()).getValue());
        byte[] privKey = UsmAuthUtil.passwordTokey(authProtocol.toUpperCase(), privPass.getBytes(), engineId, privacyProtcol);
        if (securityLevel == 3) {
            if (privacyProtcol == null) {
                return 1403;
            }
            int msgAuthoritativeEngineBoots = responseMsg.getMsgAuthoritativeEngineBoots();
            int msgAuthoritativeEngineTime = responseMsg.getMsgAuthoritativeEngineTime();
            byte[] praivacyParam = new byte[]{};
            responseMsg.setMsgAuthenticationParameters(new byte[0]);
            responseMsg.setMsgPrivacyParameter(new byte[0]);
            byte[] scopedPduBytes = responseMsg.encodeScopedPduData();
            byte[] encryptedScopedData = privProtocol.encryptMsg(scopedPduBytes, privKey, msgAuthoritativeEngineBoots, msgAuthoritativeEngineTime, praivacyParam);
            if (encryptedScopedData == null) {
                return 1405;
            }
            praivacyParam = privProtocol.getPrivacyParam();
            responseMsg.setEncryptedPdu(encryptedScopedData);
            responseMsg.setMsgPrivacyParameter(praivacyParam);
        } else {
            responseMsg.setMsgPrivacyParameter(new byte[0]);
        }
        byte[] blankDigest = new byte[12];
        if (securityLevel >= 1) {
            responseMsg.setMsgAuthenticationParameters(blankDigest);
            byte[] wholeMsg = this.buildWhoelMsg(responseMsg);
            byte[] macDigest = UsmAuthUtil.authenticateOutgoingMsg(authProtocol, authKey, wholeMsg);
            responseMsg.setMsgAuthenticationParameters(macDigest);
        } else {
            responseMsg.setMsgAuthoritativeEngineBoots(0);
            responseMsg.setMsgAuthoritativeEngineTime(0);
            responseMsg.setMsgAuthenticationParameters(new byte[0]);
        }
        return 0;
    }

    public int processingIncomingMsg(SnmpV3Message incomingMsg) {
        String secName;
        String securityName = incomingMsg.getUserSecurityName();
        BUsmUser user = UsmSecurity.getUser(securityName);
        int securityLevel = incomingMsg.getMsgFlag() & 3;
        byte[] securityEngineID = incomingMsg.getMsgAuthoritativeEngineID();
        int msgAuthoritativeEngineBoots = incomingMsg.getMsgAuthoritativeEngineBoots();
        int msgAuthoritativeEngineTime = incomingMsg.getMsgAuthoritativeEngineTime();
        if (securityEngineID.length == 0) {
            securityEngineID = UsmSecurity.hexStringToByteArray(user.getEngineID());
            return 1410;
        }
        if ((securityName.length() > 0 || securityLevel >= 1) && (secName = this.getSecurityName(securityName)) == null) {
            return 1404;
        }
        if (securityName.length() > 0) {
            String authProtocol = user.getAuthenticationProtocol().getTag().toUpperCase();
            String privacyProtcol = user.getPrivacyProtocol().getTag().toUpperCase();
            UsmPrivacy privProtocol = UsmSecurity.getPrivacyProtocolInstance(privacyProtcol);
            if (securityLevel == 1 && authProtocol == null || securityLevel == 3 && privacyProtcol == null) {
                return 1403;
            }
            byte[] engineId = UsmSecurity.hexStringToByteArray(user.getEngineID());
            String authpass = AccessController.doPrivileged(() -> ((BPassword)user.getAuthenticationPassphrase()).getValue());
            byte[] authKey = UsmAuthUtil.passwordTokey(authProtocol.toUpperCase(), authpass.getBytes(), engineId);
            String privPass = AccessController.doPrivileged(() -> ((BPassword)user.getPrivacyPassphrase()).getValue());
            byte[] privKey = UsmAuthUtil.passwordTokey(authProtocol.toUpperCase(), privPass.getBytes(), engineId, privacyProtcol);
            if (securityLevel >= 1) {
                byte[] orignalDigest = incomingMsg.getMsgAuthenticationParameters();
                incomingMsg.setMsgAuthenticationParameters(new byte[12]);
                byte[] wholeMsg = this.buildWhoelMsg(incomingMsg);
                boolean isAutneticMessage = UsmAuthUtil.authenticateIncomingMsg(authProtocol, authKey, wholeMsg, orignalDigest);
                if (!isAutneticMessage) {
                    return 1408;
                }
                if (securityLevel == 3) {
                    byte[] privParam = incomingMsg.getMsgPrivacyParameter();
                    byte[] encyptedScopedPduData = incomingMsg.getEncryptedPdu();
                    byte[] decryptedMsg = privProtocol.decryptMsg(encyptedScopedPduData, privKey, msgAuthoritativeEngineBoots, msgAuthoritativeEngineTime, privParam);
                    if (decryptedMsg == null) {
                        return 1406;
                    }
                }
            }
        } else {
            return 1404;
        }
        return 0;
    }

    public static UsmPrivacy getPrivacyProtocolInstance(String protocolName) {
        UsmPrivacy privProtocol = null;
        if (protocolName.equalsIgnoreCase("AES128")) {
            privProtocol = new AES128();
        }
        if (protocolName.equalsIgnoreCase("AES192")) {
            privProtocol = new AES192();
        }
        if (protocolName.equalsIgnoreCase("AES256")) {
            privProtocol = new AES256();
        }
        if (protocolName.equalsIgnoreCase("DES")) {
            privProtocol = new DESPrivacy();
        }
        return privProtocol;
    }

    public static BUsmUser getUser(String secName) {
        BUsmUserTable usmUserTable = BUsmUserTable.getUsmUserTable();
        BUsmUser user = null;
        if (usmUserTable != null) {
            user = usmUserTable.getUser(secName);
        }
        return user;
    }

    public static byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
        }
        return b;
    }

    private String getSecurityName(String userName) {
        BUsmUser user;
        BUsmUserTable usmUserTable;
        if (userName.length() > 0 && (usmUserTable = BUsmUserTable.getUsmUserTable()) != null && (user = usmUserTable.getUser(userName)) != null) {
            return user.getName();
        }
        return null;
    }

    public int generateTrapMsg(SnmpV3AlarmTrap outGoingTrap) {
        int msgAuthoritativeEngineBoots = outGoingTrap.getMsgAuthoritativeEngineBoots();
        int msgAuthoritativeEngineTime = outGoingTrap.getMsgAuthoritativeEngineTime();
        byte[] engineId = outGoingTrap.getMsgAuthoritativeEngineID();
        int securityLevel = outGoingTrap.getSecurityLevel();
        if (securityLevel == 3) {
            String authProtocol = outGoingTrap.getAuthProtocol().toUpperCase();
            String privacyProtcol = outGoingTrap.getPrivacyProtocol().toUpperCase();
            UsmPrivacy privProtocol = UsmSecurity.getPrivacyProtocolInstance(privacyProtcol);
            if (securityLevel >= 1 && authProtocol == null || securityLevel == 3 && privacyProtcol == null) {
                return 1403;
            }
            String privPass = outGoingTrap.getPrivacykey();
            byte[] privKey = UsmAuthUtil.passwordTokey(authProtocol.toUpperCase(), privPass.getBytes(), engineId, privacyProtcol);
            byte[] praivacyParam = new byte[]{};
            outGoingTrap.setMsgAuthenticationParameters(new byte[0]);
            outGoingTrap.setMsgPrivacyParameter(new byte[0]);
            byte[] scopedPduBytes = outGoingTrap.encodeScopedPduData();
            byte[] encryptedScopedData = privProtocol.encryptMsg(scopedPduBytes, privKey, msgAuthoritativeEngineBoots, msgAuthoritativeEngineTime, praivacyParam);
            if (encryptedScopedData == null) {
                return 1405;
            }
            praivacyParam = privProtocol.getPrivacyParam();
            outGoingTrap.setEncryptedPdu(encryptedScopedData);
            outGoingTrap.setMsgPrivacyParameter(praivacyParam);
        } else {
            outGoingTrap.setMsgPrivacyParameter(new byte[0]);
        }
        byte[] blankDigest = new byte[12];
        if (securityLevel >= 1) {
            String authProtocol = outGoingTrap.getAuthProtocol().toUpperCase();
            String authPass = outGoingTrap.getAuthKey();
            outGoingTrap.setMsgAuthenticationParameters(blankDigest);
            byte[] wholeMsg = this.buildWhoelMsg(outGoingTrap);
            byte[] authKey = UsmAuthUtil.passwordTokey(authProtocol.toUpperCase(), authPass.getBytes(), engineId);
            byte[] macDigest = UsmAuthUtil.authenticateOutgoingMsg(authProtocol, authKey, wholeMsg);
            outGoingTrap.setMsgAuthenticationParameters(macDigest);
        } else {
            outGoingTrap.setMsgAuthenticationParameters(new byte[0]);
            outGoingTrap.setMsgPrivacyParameter(new byte[0]);
        }
        return 0;
    }
}

