/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.securityModel.usm.privacy;

import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.Salt;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.UsmPrivacy;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DESPrivacy
implements UsmPrivacy {
    public static final SnmpOID OID = new SnmpOID("1.3.6.1.6.3.10.1.2.2");
    private static final int DECRYPT_PARAMS_LENGTH = 8;
    protected Salt salt = Salt.getInstance();
    private byte[] privacyParameter;

    @Override
    public byte[] encryptMsg(byte[] unencryptedMsg, byte[] encryptionKey, int engineBootTime, int engineTime, byte[] privacyParam) {
        if (encryptionKey.length < 16) {
            throw new IllegalArgumentException("encryptionKey has illegal length ");
        }
        if (privacyParam == null || privacyParam.length < 8) {
            privacyParam = new byte[8];
        }
        long my_salt = this.salt.getNext();
        privacyParam[0] = (byte)(engineBootTime >> 24 & 0xFF);
        privacyParam[1] = (byte)(engineBootTime >> 16 & 0xFF);
        privacyParam[2] = (byte)(engineBootTime >> 8 & 0xFF);
        privacyParam[3] = (byte)(engineBootTime >> 0 & 0xFF);
        privacyParam[4] = (byte)(my_salt >> 24 & 0xFFL);
        privacyParam[5] = (byte)(my_salt >> 16 & 0xFFL);
        privacyParam[6] = (byte)(my_salt >> 8 & 0xFFL);
        privacyParam[7] = (byte)(my_salt >> 0 & 0xFFL);
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(encryptionKey[8 + i] ^ privacyParam[i]);
        }
        byte[] encryptedData = null;
        try {
            Cipher algorithm = Cipher.getInstance("DES/CBC/NoPadding");
            SecretKeySpec key = new SecretKeySpec(encryptionKey, 0, 8, "DES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            algorithm.init(1, (Key)key, ivSpec);
            if (unencryptedMsg.length % 8 == 0) {
                encryptedData = algorithm.doFinal(unencryptedMsg);
            } else {
                encryptedData = new byte[8 * (unencryptedMsg.length / 8 + 1)];
                byte[] tmp = new byte[8];
                int encryptedLength = algorithm.update(unencryptedMsg, 0, unencryptedMsg.length, encryptedData);
                encryptedLength += algorithm.doFinal(tmp, 0, 8 - unencryptedMsg.length % 8, encryptedData, encryptedLength);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.privacyParameter = privacyParam;
        return encryptedData;
    }

    @Override
    public byte[] decryptMsg(byte[] cryptedMsg, byte[] decryptionKey, int engineBootTime, int engineTime, byte[] privacyParam) {
        if (decryptionKey.length < 16) {
            throw new IllegalArgumentException("encryptionKey has illegal length ");
        }
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(decryptionKey[8 + i] ^ privacyParam[i]);
        }
        byte[] decryptedData = null;
        try {
            Cipher alg = Cipher.getInstance("DES/CBC/NoPadding");
            SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, 8, "DES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            alg.init(2, (Key)key, ivSpec);
            decryptedData = alg.doFinal(cryptedMsg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return decryptedData;
    }

    @Override
    public int getEncryptedMsgLength(byte[] scopedPDU) {
        return scopedPDU.length;
    }

    @Override
    public int getKeyLength() {
        return 16;
    }

    @Override
    public byte[] getPrivacyParam() {
        return this.privacyParameter;
    }
}

