/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signingService.niagaraProv;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.signing.BCombinedSignedCertConfig;
import com.tridium.signing.fox.BFoxSigningRequester;
import com.tridium.signingService.niagaraProv.BExistingBehavior;
import com.tridium.signingService.niagaraProv.BInstallIndividualSignedCertJobStep;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="applyToFoxService", type="boolean", defaultValue="false"), @NiagaraProperty(name="applyToWebService", type="boolean", defaultValue="false"), @NiagaraProperty(name="applyToPlatform", type="boolean", defaultValue="false"), @NiagaraProperty(name="signingServiceStation", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="autoCertAliasFormat", type="BFormat", defaultValue="BFormat.make(\"%sys().station.stationName%-combined\")"), @NiagaraProperty(name="autoCertPassword", type="BPassword", defaultValue="BPassword.DEFAULT", flags=64, facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:DefaultPasswordFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:DefaultPasswordEditor\")"), @Facet(name="BPassword.PLACEHOLDER_TEXT", value="\"%lexicon(workbench:default.password.placeholder.label)%\"")}), @NiagaraProperty(name="signingServiceOnboardingComment", type="String", defaultValue="BString.make(DEFAULT_COMMENT)"), @NiagaraProperty(name="behaviorIfConfigAlreadyExists", type="BExistingBehavior", defaultValue="BExistingBehavior.skipExisting")})
public class BInstallCombinedSignedCertJobStep
extends BDeviceJobStep {
    private static final String DEFAULT_COMMENT = Lexicon.make((String)"platCrypto").getText("signingRequester.defaultOnboardingComment");
    @Generated
    public static final Property applyToFoxService = BInstallCombinedSignedCertJobStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property applyToWebService = BInstallCombinedSignedCertJobStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property applyToPlatform = BInstallCombinedSignedCertJobStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property signingServiceStation = BInstallCombinedSignedCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property autoCertAliasFormat = BInstallCombinedSignedCertJobStep.newProperty((int)0, (BValue)BFormat.make((String)"%sys().station.stationName%-combined"), null);
    @Generated
    public static final Property autoCertPassword = BInstallCombinedSignedCertJobStep.newProperty((int)64, (BValue)BPassword.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:DefaultPasswordFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:DefaultPasswordEditor"))), (BFacets)BFacets.make((String)"placeholderText", (String)"%lexicon(workbench:default.password.placeholder.label)%")));
    @Generated
    public static final Property signingServiceOnboardingComment = BInstallCombinedSignedCertJobStep.newProperty((int)0, (BValue)BString.make((String)DEFAULT_COMMENT), null);
    @Generated
    public static final Property behaviorIfConfigAlreadyExists = BInstallCombinedSignedCertJobStep.newProperty((int)0, (BValue)BExistingBehavior.skipExisting, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInstallCombinedSignedCertJobStep.class);
    private static final Lexicon LEX = Lexicon.make(BInstallCombinedSignedCertJobStep.class);
    private static final String LEX_MODULE = "signingService";
    private static final Logger LOG = Logger.getLogger("signingService.niagara.provisioning");

    @Generated
    public boolean getApplyToFoxService() {
        return this.getBoolean(applyToFoxService);
    }

    @Generated
    public void setApplyToFoxService(boolean v) {
        this.setBoolean(applyToFoxService, v, null);
    }

    @Generated
    public boolean getApplyToWebService() {
        return this.getBoolean(applyToWebService);
    }

    @Generated
    public void setApplyToWebService(boolean v) {
        this.setBoolean(applyToWebService, v, null);
    }

    @Generated
    public boolean getApplyToPlatform() {
        return this.getBoolean(applyToPlatform);
    }

    @Generated
    public void setApplyToPlatform(boolean v) {
        this.setBoolean(applyToPlatform, v, null);
    }

    @Generated
    public String getSigningServiceStation() {
        return this.getString(signingServiceStation);
    }

    @Generated
    public void setSigningServiceStation(String v) {
        this.setString(signingServiceStation, v, null);
    }

    @Generated
    public BFormat getAutoCertAliasFormat() {
        return (BFormat)this.get(autoCertAliasFormat);
    }

    @Generated
    public void setAutoCertAliasFormat(BFormat v) {
        this.set(autoCertAliasFormat, (BValue)v, null);
    }

    @Generated
    public BPassword getAutoCertPassword() {
        return (BPassword)this.get(autoCertPassword);
    }

    @Generated
    public void setAutoCertPassword(BPassword v) {
        this.set(autoCertPassword, (BValue)v, null);
    }

    @Generated
    public String getSigningServiceOnboardingComment() {
        return this.getString(signingServiceOnboardingComment);
    }

    @Generated
    public void setSigningServiceOnboardingComment(String v) {
        this.setString(signingServiceOnboardingComment, v, null);
    }

    @Generated
    public BExistingBehavior getBehaviorIfConfigAlreadyExists() {
        return (BExistingBehavior)this.get(behaviorIfConfigAlreadyExists);
    }

    @Generated
    public void setBehaviorIfConfigAlreadyExists(BExistingBehavior v) {
        this.set(behaviorIfConfigAlreadyExists, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        String signingServiceStation = this.getSigningServiceStation();
        BInstallIndividualSignedCertJobStep.validate(signingServiceStation);
        BFormat autoAlias = this.getAutoCertAliasFormat();
        if (BFormat.DEFAULT.equals((Object)autoAlias) || autoAlias.getFormat().trim().isEmpty()) {
            throw new LocalizableRuntimeException(LEX_MODULE, "signedCertConfig.invalid.alias");
        }
        boolean applyToFox = this.getApplyToFoxService();
        boolean applyToWeb = this.getApplyToWebService();
        boolean applyToPlatform = this.getApplyToPlatform();
        BPassword autoPassword = this.getAutoCertPassword().isDefault() ? BPassword.DEFAULT : BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getAutoCertPassword()).getValue()));
        String autoOnboardComment = this.getSigningServiceOnboardingComment();
        BExistingBehavior existingBehavior = this.getBehaviorIfConfigAlreadyExists();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(() -> String.format("Installing Combined Signed Cert Config with the following settings:\n  Target Station = %s\n  ApplyToFoxService = %s\n  ApplyToWebService = %s\n  ApplyToPlatform = %s\n  SigningServiceStation = %s\n  AutoCertAliasFormat = %s\n  SigningServiceOnboardingComment = %s\n  behaviorIfConfigAlreadyExists = %s", device.getName(), applyToFox, applyToWeb, applyToPlatform, signingServiceStation, autoAlias.getFormat(), autoOnboardComment, existingBehavior.getDisplayTag(null)));
        }
        String settingSummary = LEX.getText("InstallCombinedSignedCertConfig.settingSummary", new Object[]{BBoolean.make((boolean)applyToFox).getDisplayTag(null), BBoolean.make((boolean)applyToWeb).getDisplayTag(null), BBoolean.make((boolean)applyToPlatform).getDisplayTag(null), signingServiceStation, autoAlias.getFormat(), autoOnboardComment, existingBehavior.getDisplayTag(null)});
        details.message(LEX_MODULE, "signedCertProvisioning.installConfigJobSummary", new String[]{BCombinedSignedCertConfig.TYPE.getDisplayName(null), device.getName(), settingSummary});
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BFoxSession session = util.getEngagedFoxSession();
            try {
                BStation remoteStation = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)session);
                BInstallCombinedSignedCertJobStep.performConfigInstall(details, remoteStation, applyToFox, applyToWeb, applyToPlatform, signingServiceStation, autoAlias, autoPassword, autoOnboardComment, existingBehavior);
            }
            finally {
                util.disengageFoxSession();
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "An unexpected error occurred provisioning device " + device.getName() + ": " + e.getMessage(), LOG.isLoggable(Level.FINE) ? e : null);
            details.failed(LEX_MODULE, "signedCertProvisioning.installConfigJobFailure", new String[]{BCombinedSignedCertConfig.TYPE.getDisplayName(null), device.getName()});
            throw e;
        }
        details.success(LEX_MODULE, "signedCertProvisioning.installConfigJobComplete", new String[]{BCombinedSignedCertConfig.TYPE.getDisplayName(null), device.getName()});
    }

    private static void performConfigInstall(BDeviceStepDetails details, BStation remoteStation, boolean applyToFox, boolean applyToWeb, boolean applyToPlatform, String signingServiceStation, BFormat autoAlias, BPassword autoPassword, String autoOnboardComment, BExistingBehavior existingBehavior) {
        BAbsTime lastFailureBeforeProcessing;
        BAbsTime lastSuccessBeforeProcessing;
        BFoxSigningRequester requester;
        BCombinedSignedCertConfig combinedSignedCertConfig;
        BComponent targetComponent;
        String remoteStationName = remoteStation.getStationName();
        BInstallIndividualSignedCertJobStep.syncProxySpace((BComponent)remoteStation);
        remoteStation.lease();
        remoteStation.getServices().lease();
        try {
            targetComponent = BInstallCombinedSignedCertJobStep.getRemoteSecurityService(remoteStation);
        }
        catch (Throwable t) {
            Object[] arguments = new String[]{remoteStationName};
            details.failed(LEX_MODULE, "InstallCombinedSignedCertConfig.targetResolutionFailure", (String[])arguments);
            throw new LocalizableRuntimeException(LEX_MODULE, "InstallCombinedSignedCertConfig.targetResolutionFailure", arguments, t);
        }
        String combinedSignedCertConfigTypeName = BCombinedSignedCertConfig.TYPE.getDisplayName(null);
        try {
            targetComponent.lease();
            String targetComponentPath = targetComponent.toDisplayPathString(null);
            BCombinedSignedCertConfig[] existingConfigs = (BCombinedSignedCertConfig[])targetComponent.getChildren(BCombinedSignedCertConfig.class);
            boolean configExisted = false;
            if (existingConfigs != null && existingConfigs.length > 0) {
                if (BExistingBehavior.skipExisting.equals((Object)existingBehavior)) {
                    details.message(LEX_MODULE, "signedCertProvisioning.skippedConfig", new String[]{combinedSignedCertConfigTypeName, remoteStationName, targetComponentPath});
                    return;
                }
                configExisted = true;
                combinedSignedCertConfig = existingConfigs[0];
            } else {
                if (BExistingBehavior.onboardExisting.equals((Object)existingBehavior) || BExistingBehavior.renewExisting.equals((Object)existingBehavior)) {
                    details.message(LEX_MODULE, "signedCertProvisioning.noConfigToProcess", new String[]{combinedSignedCertConfigTypeName, remoteStationName, targetComponentPath});
                    return;
                }
                combinedSignedCertConfig = new BCombinedSignedCertConfig();
                targetComponent.add("CombinedSignedCertConfig?", (BValue)combinedSignedCertConfig);
                BInstallIndividualSignedCertJobStep.syncProxySpace(targetComponent);
                combinedSignedCertConfig = ((BCombinedSignedCertConfig[])targetComponent.getChildren(BCombinedSignedCertConfig.class))[0];
            }
            combinedSignedCertConfig.lease();
            if (BExistingBehavior.onboardExisting.equals((Object)existingBehavior) || BExistingBehavior.renewExisting.equals((Object)existingBehavior)) {
                details.message(LEX_MODULE, "signedCertProvisioning.preserveExistingConfig", new String[]{combinedSignedCertConfigTypeName, remoteStationName, targetComponentPath});
                requester = combinedSignedCertConfig.getSigningRequester();
                requester.lease();
                lastSuccessBeforeProcessing = requester.getLastSuccess();
                lastFailureBeforeProcessing = requester.getLastFailure();
                if (BExistingBehavior.renewExisting.equals((Object)existingBehavior)) {
                    combinedSignedCertConfig.renew();
                    details.message(LEX_MODULE, "signedCertProvisioning.renewedConfig", new String[]{combinedSignedCertConfig.toDisplayPathString(null), remoteStationName});
                } else {
                    combinedSignedCertConfig.autoOnboard(BFormat.DEFAULT);
                }
            } else {
                BFoxSigningRequester foxSigningRequester;
                if (!(combinedSignedCertConfig.getSigningRequester() instanceof BFoxSigningRequester)) {
                    combinedSignedCertConfig.setSigningRequesterType(BFoxSigningRequester.TYPE.getTypeSpec());
                    BInstallIndividualSignedCertJobStep.syncProxySpace(targetComponent);
                }
                requester = foxSigningRequester = (BFoxSigningRequester)combinedSignedCertConfig.getSigningRequester();
                requester.lease();
                lastSuccessBeforeProcessing = requester.getLastSuccess();
                lastFailureBeforeProcessing = requester.getLastFailure();
                combinedSignedCertConfig.setApplyToFoxService(applyToFox);
                combinedSignedCertConfig.setApplyToWebService(applyToWeb);
                combinedSignedCertConfig.setApplyToPlatform(applyToPlatform);
                foxSigningRequester.setSigningServiceStation(signingServiceStation);
                combinedSignedCertConfig.setAutoOnboardComment(autoOnboardComment);
                combinedSignedCertConfig.getCertToSignAndApply().setPassword(autoPassword);
                details.message(LEX_MODULE, configExisted ? "signedCertProvisioning.overrodeConfig" : "signedCertProvisioning.installedNewConfig", new String[]{combinedSignedCertConfigTypeName, remoteStationName, targetComponentPath});
                combinedSignedCertConfig.autoOnboard(autoAlias);
            }
            if (!BExistingBehavior.renewExisting.equals((Object)existingBehavior)) {
                details.message(LEX_MODULE, "signedCertProvisioning.autoOnboardedConfig", new String[]{combinedSignedCertConfig.toDisplayPathString(null), remoteStationName});
            }
        }
        catch (Throwable t) {
            Object[] arguments = new String[]{combinedSignedCertConfigTypeName, remoteStationName, targetComponent.toDisplayPathString(null)};
            details.failed(LEX_MODULE, "signedCertProvisioning.failedConfigInstall", (String[])arguments);
            throw new LocalizableRuntimeException(LEX_MODULE, "signedCertProvisioning.failedConfigInstall", arguments, t);
        }
        BInstallIndividualSignedCertJobStep.checkSignedCertConfigStatus((BComponent)combinedSignedCertConfig, (BAbstractSigningRequester)requester, lastSuccessBeforeProcessing, lastFailureBeforeProcessing, remoteStationName, existingBehavior, details);
    }

    private static BComponent getRemoteSecurityService(BStation remoteStation) {
        return (BComponent)BOrd.make((String)"service:baja:ISecurityService").get((BObject)remoteStation);
    }
}

