/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signingService.niagaraProv;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BRequesterState;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.signing.BIndividualSignedCertConfig;
import com.tridium.signing.fox.BFoxSigningRequester;
import com.tridium.signingService.niagaraProv.BExistingBehavior;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="targetTypeToPerformInstall", type="BTypeSpec", defaultValue="BTypeSpec.make(\"web:WebService\")", facets={@Facet(name="BFacets.ALLOW_NULL", value="false"), @Facet(value="BFacets.make(\"showAbstract\", true)"), @Facet(value="BFacets.make(\"showInterface\", false)"), @Facet(name="BFacets.TARGET_TYPE", value="\"baja:ICertificateAliasAndPasswordContainer\"")}), @NiagaraProperty(name="optionalRemoteTargetBaseOrd", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(\"rootNode\", \"station:|slot:/\")")}), @NiagaraProperty(name="signingServiceStation", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="autoCertAliasFormat", type="BFormat", defaultValue="BFormat.DEFAULT"), @NiagaraProperty(name="autoCertPassword", type="BPassword", defaultValue="BPassword.DEFAULT", flags=64, facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:DefaultPasswordFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:DefaultPasswordEditor\")"), @Facet(name="BPassword.PLACEHOLDER_TEXT", value="\"%lexicon(workbench:default.password.placeholder.label)%\"")}), @NiagaraProperty(name="signingServiceOnboardingComment", type="String", defaultValue="BString.make(DEFAULT_COMMENT)"), @NiagaraProperty(name="behaviorIfConfigAlreadyExists", type="BExistingBehavior", defaultValue="BExistingBehavior.skipExisting")})
public class BInstallIndividualSignedCertJobStep
extends BDeviceJobStep {
    private static final String DEFAULT_COMMENT = Lexicon.make((String)"platCrypto").getText("signingRequester.defaultOnboardingComment");
    @Generated
    public static final Property targetTypeToPerformInstall = BInstallIndividualSignedCertJobStep.newProperty((int)0, (BValue)BTypeSpec.make((String)"web:WebService"), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"allowNull", (boolean)false), (BFacets)BFacets.make((String)"showAbstract", (boolean)true)), (BFacets)BFacets.make((String)"showInterface", (boolean)false)), (BFacets)BFacets.make((String)"targetType", (String)"baja:ICertificateAliasAndPasswordContainer")));
    @Generated
    public static final Property optionalRemoteTargetBaseOrd = BInstallIndividualSignedCertJobStep.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"rootNode", (String)"station:|slot:/"));
    @Generated
    public static final Property signingServiceStation = BInstallIndividualSignedCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property autoCertAliasFormat = BInstallIndividualSignedCertJobStep.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    @Generated
    public static final Property autoCertPassword = BInstallIndividualSignedCertJobStep.newProperty((int)64, (BValue)BPassword.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:DefaultPasswordFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:DefaultPasswordEditor"))), (BFacets)BFacets.make((String)"placeholderText", (String)"%lexicon(workbench:default.password.placeholder.label)%")));
    @Generated
    public static final Property signingServiceOnboardingComment = BInstallIndividualSignedCertJobStep.newProperty((int)0, (BValue)BString.make((String)DEFAULT_COMMENT), null);
    @Generated
    public static final Property behaviorIfConfigAlreadyExists = BInstallIndividualSignedCertJobStep.newProperty((int)0, (BValue)BExistingBehavior.skipExisting, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInstallIndividualSignedCertJobStep.class);
    private static final Lexicon LEX = Lexicon.make(BInstallIndividualSignedCertJobStep.class);
    private static final String LEX_MODULE = "signingService";
    private static final BFormat DEFAULT_AUTO_CERT_ALIAS_FORMAT = BFormat.make((String)LEX.getText("InstallIndividualSignedCertConfig.defaultAutoCertAliasFormat"));
    private static final Logger LOG = Logger.getLogger("signingService.niagara.provisioning");
    private static final long WAIT_TIME_FOR_SIGNED_CERT_STATUS = 5000L;

    @Generated
    public BTypeSpec getTargetTypeToPerformInstall() {
        return (BTypeSpec)this.get(targetTypeToPerformInstall);
    }

    @Generated
    public void setTargetTypeToPerformInstall(BTypeSpec v) {
        this.set(targetTypeToPerformInstall, (BValue)v, null);
    }

    @Generated
    public BOrd getOptionalRemoteTargetBaseOrd() {
        return (BOrd)this.get(optionalRemoteTargetBaseOrd);
    }

    @Generated
    public void setOptionalRemoteTargetBaseOrd(BOrd v) {
        this.set(optionalRemoteTargetBaseOrd, (BValue)v, null);
    }

    @Generated
    public String getSigningServiceStation() {
        return this.getString(signingServiceStation);
    }

    @Generated
    public void setSigningServiceStation(String v) {
        this.setString(signingServiceStation, v, null);
    }

    @Generated
    public BFormat getAutoCertAliasFormat() {
        return (BFormat)this.get(autoCertAliasFormat);
    }

    @Generated
    public void setAutoCertAliasFormat(BFormat v) {
        this.set(autoCertAliasFormat, (BValue)v, null);
    }

    @Generated
    public BPassword getAutoCertPassword() {
        return (BPassword)this.get(autoCertPassword);
    }

    @Generated
    public void setAutoCertPassword(BPassword v) {
        this.set(autoCertPassword, (BValue)v, null);
    }

    @Generated
    public String getSigningServiceOnboardingComment() {
        return this.getString(signingServiceOnboardingComment);
    }

    @Generated
    public void setSigningServiceOnboardingComment(String v) {
        this.setString(signingServiceOnboardingComment, v, null);
    }

    @Generated
    public BExistingBehavior getBehaviorIfConfigAlreadyExists() {
        return (BExistingBehavior)this.get(behaviorIfConfigAlreadyExists);
    }

    @Generated
    public void setBehaviorIfConfigAlreadyExists(BExistingBehavior v) {
        this.set(behaviorIfConfigAlreadyExists, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInstallIndividualSignedCertJobStep() {
        this.setAutoCertAliasFormat(DEFAULT_AUTO_CERT_ALIAS_FORMAT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        String signingServiceStation = this.getSigningServiceStation();
        BInstallIndividualSignedCertJobStep.validate(signingServiceStation);
        BTypeSpec targetType = this.getTargetTypeToPerformInstall();
        BOrd remoteTargetBaseOrd = this.getOptionalRemoteTargetBaseOrd();
        BFormat format = this.getAutoCertAliasFormat();
        if (format.equals((Object)DEFAULT_AUTO_CERT_ALIAS_FORMAT) || format.getFormat().trim().isEmpty()) {
            format = BFormat.DEFAULT;
        }
        BFormat autoAlias = format;
        BPassword autoPassword = this.getAutoCertPassword().isDefault() ? BPassword.DEFAULT : BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getAutoCertPassword()).getValue()));
        String autoOnboardComment = this.getSigningServiceOnboardingComment();
        BExistingBehavior existingBehavior = this.getBehaviorIfConfigAlreadyExists();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(() -> String.format("Installing Individual Signed Cert Config with the following settings:\n  Target Station = %s\n  TargetTypeToPerformInstall = %s\n  OptionalRemoteTargetBaseOrd = %s\n  SigningServiceStation = %s\n  AutoCertAliasFormat = %s\n  SigningServiceOnboardingComment = %s\n  behaviorIfConfigAlreadyExists = %s", device.getName(), targetType.getResolvedType().getDisplayName(null), remoteTargetBaseOrd, signingServiceStation, autoAlias.getFormat(), autoOnboardComment, existingBehavior.getDisplayTag(null)));
        }
        String settingSummary = LEX.getText("InstallIndividualSignedCertConfig.settingSummary", new Object[]{targetType.getResolvedType().getDisplayName(null), remoteTargetBaseOrd, signingServiceStation, autoAlias.getFormat(), autoOnboardComment, existingBehavior.getDisplayTag(null)});
        details.message(LEX_MODULE, "signedCertProvisioning.installConfigJobSummary", new String[]{BIndividualSignedCertConfig.TYPE.getDisplayName(null), device.getName(), settingSummary});
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BFoxSession session = util.getEngagedFoxSession();
            try {
                BStation remoteStation = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)session);
                BInstallIndividualSignedCertJobStep.performConfigInstall(details, remoteStation, targetType, remoteTargetBaseOrd, signingServiceStation, autoAlias, autoPassword, autoOnboardComment, existingBehavior);
            }
            finally {
                util.disengageFoxSession();
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "An unexpected error occurred provisioning device " + device.getName() + ": " + e.getMessage(), LOG.isLoggable(Level.FINE) ? e : null);
            details.failed(LEX_MODULE, "signedCertProvisioning.installConfigJobFailure", new String[]{BIndividualSignedCertConfig.TYPE.getDisplayName(null), device.getName()});
            throw e;
        }
        details.success(LEX_MODULE, "signedCertProvisioning.installConfigJobComplete", new String[]{BIndividualSignedCertConfig.TYPE.getDisplayName(null), device.getName()});
    }

    private static void performConfigInstall(BDeviceStepDetails details, BStation remoteStation, BTypeSpec targetType, BOrd remoteTargetBaseOrd, String signingServiceStation, BFormat autoAlias, BPassword autoPassword, String autoOnboardComment, BExistingBehavior existingBehavior) {
        Set<BComponent> targetComponents;
        String remoteStationName = remoteStation.getStationName();
        BInstallIndividualSignedCertJobStep.syncProxySpace((BComponent)remoteStation);
        try {
            targetComponents = BInstallIndividualSignedCertJobStep.getTargetComponents(remoteStation, targetType, remoteTargetBaseOrd);
        }
        catch (Throwable t) {
            Object[] arguments = new String[]{remoteStationName};
            details.failed(LEX_MODULE, "InstallIndividualSignedCertConfig.targetResolutionFailure", (String[])arguments);
            throw new LocalizableRuntimeException(LEX_MODULE, "InstallIndividualSignedCertConfig.targetResolutionFailure", arguments, t);
        }
        String individualSignedCertConfigTypeName = BIndividualSignedCertConfig.TYPE.getDisplayName(null);
        details.message(LEX_MODULE, "InstallIndividualSignedCertConfig.foundTargetComponents", new String[]{String.valueOf(targetComponents.size()), individualSignedCertConfigTypeName, remoteStationName});
        Object ex = null;
        for (BComponent targetComponent : targetComponents) {
            try {
                BAbsTime lastFailureBeforeProcessing;
                BAbsTime lastSuccessBeforeProcessing;
                BFoxSigningRequester requester;
                BIndividualSignedCertConfig individualSignedCertConfig;
                targetComponent.lease();
                String targetComponentPath = targetComponent.toDisplayPathString(null);
                BIndividualSignedCertConfig[] existingConfigs = (BIndividualSignedCertConfig[])targetComponent.getChildren(BIndividualSignedCertConfig.class);
                boolean configExisted = false;
                if (existingConfigs != null && existingConfigs.length > 0) {
                    if (BExistingBehavior.skipExisting.equals((Object)existingBehavior)) {
                        details.message(LEX_MODULE, "signedCertProvisioning.skippedConfig", new String[]{individualSignedCertConfigTypeName, remoteStationName, targetComponentPath});
                        continue;
                    }
                    configExisted = true;
                    individualSignedCertConfig = existingConfigs[0];
                } else {
                    if (BExistingBehavior.onboardExisting.equals((Object)existingBehavior) || BExistingBehavior.renewExisting.equals((Object)existingBehavior)) {
                        details.message(LEX_MODULE, "signedCertProvisioning.noConfigToProcess", new String[]{individualSignedCertConfigTypeName, remoteStationName, targetComponentPath});
                        continue;
                    }
                    individualSignedCertConfig = new BIndividualSignedCertConfig();
                    targetComponent.add("IndividualSignedCertConfig?", (BValue)individualSignedCertConfig);
                    BInstallIndividualSignedCertJobStep.syncProxySpace(targetComponent);
                    individualSignedCertConfig = ((BIndividualSignedCertConfig[])targetComponent.getChildren(BIndividualSignedCertConfig.class))[0];
                }
                individualSignedCertConfig.lease();
                if (BExistingBehavior.onboardExisting.equals((Object)existingBehavior) || BExistingBehavior.renewExisting.equals((Object)existingBehavior)) {
                    details.message(LEX_MODULE, "signedCertProvisioning.preserveExistingConfig", new String[]{individualSignedCertConfigTypeName, remoteStationName, targetComponentPath});
                    requester = individualSignedCertConfig.getSigningRequester();
                    requester.lease();
                    lastSuccessBeforeProcessing = requester.getLastSuccess();
                    lastFailureBeforeProcessing = requester.getLastFailure();
                    if (BExistingBehavior.renewExisting.equals((Object)existingBehavior)) {
                        individualSignedCertConfig.renew();
                        details.message(LEX_MODULE, "signedCertProvisioning.renewedConfig", new String[]{individualSignedCertConfig.toDisplayPathString(null), remoteStationName});
                    } else {
                        individualSignedCertConfig.autoOnboard(BFormat.DEFAULT);
                    }
                } else {
                    BFoxSigningRequester foxSigningRequester;
                    if (!(individualSignedCertConfig.getSigningRequester() instanceof BFoxSigningRequester)) {
                        individualSignedCertConfig.setSigningRequesterType(BFoxSigningRequester.TYPE.getTypeSpec());
                        BInstallIndividualSignedCertJobStep.syncProxySpace(targetComponent);
                    }
                    requester = foxSigningRequester = (BFoxSigningRequester)individualSignedCertConfig.getSigningRequester();
                    requester.lease();
                    lastSuccessBeforeProcessing = requester.getLastSuccess();
                    lastFailureBeforeProcessing = requester.getLastFailure();
                    foxSigningRequester.setSigningServiceStation(signingServiceStation);
                    individualSignedCertConfig.setAutoOnboardComment(autoOnboardComment);
                    individualSignedCertConfig.getCertToSignAndApply().setPassword(autoPassword);
                    details.message(LEX_MODULE, configExisted ? "signedCertProvisioning.overrodeConfig" : "signedCertProvisioning.installedNewConfig", new String[]{individualSignedCertConfigTypeName, remoteStationName, targetComponentPath});
                    BFormat adjustedAutoAlias = configExisted && autoAlias.equals((Object)BFormat.DEFAULT) ? BIndividualSignedCertConfig.USE_RECOMMENDED_AUTO_ALIAS : autoAlias;
                    individualSignedCertConfig.autoOnboard(adjustedAutoAlias);
                }
                if (!BExistingBehavior.renewExisting.equals((Object)existingBehavior)) {
                    details.message(LEX_MODULE, "signedCertProvisioning.autoOnboardedConfig", new String[]{individualSignedCertConfig.toDisplayPathString(null), remoteStationName});
                }
                try {
                    BInstallIndividualSignedCertJobStep.checkSignedCertConfigStatus((BComponent)individualSignedCertConfig, (BAbstractSigningRequester)requester, lastSuccessBeforeProcessing, lastFailureBeforeProcessing, remoteStationName, existingBehavior, details);
                }
                catch (RuntimeException e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
            catch (Throwable t) {
                Object[] arguments = new String[]{individualSignedCertConfigTypeName, remoteStationName, targetComponent.toDisplayPathString(null)};
                details.failed(LEX_MODULE, "signedCertProvisioning.failedConfigInstall", (String[])arguments);
                if (ex != null) continue;
                ex = new LocalizableRuntimeException(LEX_MODULE, "signedCertProvisioning.failedConfigInstall", arguments, t);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private static Set<BComponent> getTargetComponents(BStation remoteStation, BTypeSpec targetType, BOrd remoteTargetBaseOrd) {
        HashSet<BComponent> targetComponents = new HashSet<BComponent>();
        BStation base = remoteStation;
        if (!remoteTargetBaseOrd.isNull()) {
            try {
                BObject remoteTargetBase = remoteTargetBaseOrd.get((BObject)remoteStation);
                if (remoteTargetBase != null) {
                    base = remoteTargetBase;
                    if (remoteTargetBase.getType().is(targetType.getTypeInfo())) {
                        targetComponents.add(remoteTargetBase.asComponent());
                    }
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, String.format("Remote Target Base ORD '%s' cannot be resolved to a component on station %s", remoteTargetBaseOrd, remoteStation.getStationName()), LOG.isLoggable(Level.FINE) ? t : null);
                throw t;
            }
        }
        BITable targetComponentOrds = (BITable)BOrd.make((String)("bql:select ordInSession from " + targetType)).get((BObject)base);
        Column ordColumn = targetComponentOrds.getColumns().get(0);
        try (TableCursor cursor = targetComponentOrds.cursor();){
            while (cursor.next()) {
                targetComponents.add(BOrd.make((String)cursor.cell(ordColumn).toString()).get((BObject)remoteStation).asComponent());
            }
        }
        return targetComponents;
    }

    static void validate(String signingServiceStation) {
        if (signingServiceStation.isEmpty()) {
            throw new LocalizableRuntimeException(LEX_MODULE, "signedCertProvisioning.noSigningServiceStation");
        }
    }

    static void syncProxySpace(BComponent proxyComponent) {
        try {
            proxyComponent.getComponentSpace().sync();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "An unexpected error occurred updating the proxy space: " + e.getMessage(), LOG.isLoggable(Level.FINE) ? e : null);
        }
    }

    static void checkSignedCertConfigStatus(BComponent signedCertConfig, BAbstractSigningRequester requester, BAbsTime lastSuccessBeforeProcessing, BAbsTime lastFailureBeforeProcessing, String remoteStationName, BExistingBehavior existingBehavior, BDeviceStepDetails details) {
        requester.lease();
        long startTicks = Clock.ticks();
        while (requester.getLastSuccess().getMillis() <= lastSuccessBeforeProcessing.getMillis() && requester.getLastFailure().getMillis() <= lastFailureBeforeProcessing.getMillis() && !requester.getRequesterState().equals((Object)BRequesterState.approvalInProgress) && Clock.ticks() - startTicks < 5000L) {
            try {
                Thread.sleep(250L);
                requester.getComponentSpace().sync();
            }
            catch (Exception exception) {}
        }
        BAbsTime currentSuccess = requester.getLastSuccess();
        BAbsTime currentFailure = requester.getLastFailure();
        boolean renewal = BExistingBehavior.renewExisting.equals((Object)existingBehavior);
        if (currentSuccess.getMillis() > lastSuccessBeforeProcessing.getMillis()) {
            String lexKey = renewal ? "signedCertProvisioning.renewSuccess" : "signedCertProvisioning.onboardSuccess";
            details.message(LEX_MODULE, lexKey, new String[]{signedCertConfig.toDisplayPathString(null), remoteStationName, requester.getRequesterState().getDisplayTag(null)});
        } else {
            if (currentFailure.getMillis() > lastFailureBeforeProcessing.getMillis()) {
                String lexKey = renewal ? "signedCertProvisioning.renewFailure" : "signedCertProvisioning.onboardFailure";
                Object[] arguments = new String[]{signedCertConfig.toDisplayPathString(null), remoteStationName, requester.getRequesterState().getDisplayTag(null), requester.getFaultCause()};
                details.message(LEX_MODULE, lexKey, (String[])arguments);
                throw new LocalizableRuntimeException(LEX_MODULE, lexKey, arguments);
            }
            String lexKey = renewal ? "signedCertProvisioning.renewInProgress" : "signedCertProvisioning.onboardInProgress";
            details.message(LEX_MODULE, lexKey, new String[]{signedCertConfig.toDisplayPathString(null), remoteStationName, requester.getRequesterState().getDisplayTag(null)});
        }
    }
}

