/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.alarm;

import com.vykon.vykonPro.util.BVykonProService;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BAlarmDataFilter
extends BComponent {
    public static final Property keysToInclude = BAlarmDataFilter.newProperty((int)0, (String)"enter alarmData keys to keep separated by commas", null);
    public static final Action receive = BAlarmDataFilter.newAction((int)24, (BValue)new BAlarmRecord(), null);
    public static final Topic alarm = BAlarmDataFilter.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BAlarmDataFilter.class);
    private static final BIcon icon = BIcon.std((String)"filter.png");
    private String[] filteredkeys;
    private BIDataValue[] filteredvalues;

    public String getKeysToInclude() {
        return this.getString(keysToInclude);
    }

    public void setKeysToInclude(String v) {
        this.setString(keysToInclude, v, null);
    }

    public void receive(BAlarmRecord alarm) {
        this.invoke(receive, (BValue)alarm, null);
    }

    public void fireAlarm(BAlarmRecord event) {
        this.fire(alarm, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.initializeKeys();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(keysToInclude)) {
            this.initializeKeys();
        }
    }

    private void initializeKeys() {
        if (this.getKeysToInclude().length() > 0) {
            if (this.getKeysToInclude().indexOf(",") > -1) {
                this.filteredkeys = TextUtil.splitAndTrim((String)this.getKeysToInclude(), (char)',');
            } else {
                this.filteredkeys = new String[1];
                this.filteredkeys[0] = this.getKeysToInclude().trim();
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == receive) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    public void doReceive(BAlarmRecord alarm) {
        BAlarmRecord myalarm = (BAlarmRecord)alarm.newCopy();
        this.filteredvalues = new BIDataValue[this.filteredkeys.length];
        for (int i = 0; i < this.filteredkeys.length; ++i) {
            if (myalarm.getAlarmFacet(this.filteredkeys[i]) == null) continue;
            if (this.filteredkeys[i].equals("msgText")) {
                String s = ((BString)myalarm.getAlarmFacet("msgText")).toString();
                s = SlotPath.unescape((String)BFormat.make((String)s).format((Object)myalarm));
                this.filteredvalues[i] = BString.make((String)s);
                continue;
            }
            this.filteredvalues[i] = (BIDataValue)myalarm.getAlarmFacet(this.filteredkeys[i]);
        }
        BFacets b = BFacets.make((String[])this.filteredkeys, (BIDataValue[])this.filteredvalues);
        myalarm.setAlarmData(b);
        this.fireAlarm(myalarm);
    }

    public BIcon getIcon() {
        return icon;
    }
}

