/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.bql;

import com.tridium.bql.BBqlTime;
import javax.baja.bql.BIAggregator;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BAbsTimeRange;

public class BRuntime
extends BObject
implements BIAggregator {
    public static final Type TYPE = Sys.loadType(BRuntime.class);
    private BAbsTime startOf = BAbsTime.NULL;
    private BAbsTimeRange range = new BAbsTimeRange();
    private boolean checkState;
    private boolean currentState;
    private boolean firstRecord = true;
    private BRelTime elapsed = BRelTime.DEFAULT;
    private BRelTime lastElapsed = BRelTime.DEFAULT;

    public Type getType() {
        return TYPE;
    }

    public void aggregate(BBoolean state, BAbsTime tstamp, BBoolean value) {
        this.aggregate(state.getBoolean(), tstamp, value.getBoolean());
    }

    public void aggregate(boolean state, BAbsTime tstamp, BBoolean value) {
        this.aggregate(state, tstamp, value.getBoolean());
    }

    public void aggregate(BBoolean state, BAbsTime tstamp, boolean value) {
        this.aggregate(state.getBoolean(), tstamp, value);
    }

    public void aggregate(boolean state, BAbsTime tstamp, boolean value) {
        if (this.startOf == BAbsTime.NULL) {
            if (value == state) {
                this.startOf = tstamp;
                this.currentState = value;
            }
        } else if (this.currentState != value && this.currentState == state) {
            long diff = tstamp.getMillis() - this.startOf.getMillis();
            this.elapsed = BRelTime.make((long)(this.elapsed.getMillis() + diff));
            this.currentState = value;
        } else if (this.currentState != value && this.currentState != state) {
            this.currentState = value;
            this.startOf = tstamp;
        }
    }

    public void aggregate(BString rollup, BBoolean state, BAbsTime tstamp, BBoolean value) {
        this.aggregate(rollup.toString(), state.getBoolean(), tstamp, value.getBoolean());
    }

    public void aggregate(String rollup, boolean state, BAbsTime tstamp, boolean value) {
        this.range = this.calcRollup(rollup, tstamp);
        this.checkState = state;
        if (this.firstRecord) {
            if (value == state) {
                this.startOf = this.range.getStartTime();
                this.currentState = value;
                long diff = tstamp.getMillis() - this.startOf.getMillis();
                this.elapsed = BRelTime.make((long)diff);
                System.out.println("aggregate startOf=" + this.startOf + " | tstamp=" + tstamp + " | value=" + value + " | elapsed=" + this.elapsed);
                this.startOf = tstamp;
            } else {
                this.startOf = tstamp;
                this.currentState = value;
                System.out.println("aggregate firstRecord tstamp=" + tstamp + " | value=" + value);
            }
            this.firstRecord = false;
        } else if (this.currentState != value && this.currentState == state) {
            long diff = tstamp.getMillis() - this.startOf.getMillis();
            this.elapsed = BRelTime.make((long)(this.elapsed.getMillis() + diff));
            this.currentState = value;
            System.out.println("aggregate startOf=" + this.startOf + " | tstamp=" + tstamp + " | value=" + value + " | elapsed=" + this.elapsed);
        } else if (this.currentState != value && this.currentState != state) {
            this.currentState = value;
            this.startOf = tstamp;
        } else {
            System.out.println("aggregate skipping tstamp=" + tstamp + " | value=" + value);
        }
    }

    public BAbsTimeRange calcRollup(String rollup, BAbsTime tstamp) {
        BAbsTime start = BAbsTime.DEFAULT;
        BAbsTime end = BAbsTime.END_OF_TIME;
        if (rollup.equals("hourly")) {
            start = BAbsTime.make((BAbsTime)tstamp, (BTime)BTime.make((int)tstamp.getHour(), (int)0, (int)0, (int)0));
            end = start.nextDay().subtract(BRelTime.make((long)1L));
        } else if (rollup.equals("daily")) {
            start = BBqlTime.startofday((BObject)tstamp);
            end = BBqlTime.endofday((BObject)tstamp);
        } else if (rollup.equals("weekly")) {
            BWeekday first = BWeekday.getFirstDayOfWeek(null);
            start = tstamp.getWeekday() != BWeekday.getFirstDayOfWeek(null) ? tstamp.prev(first) : tstamp;
            start = BAbsTime.make((BAbsTime)start, (BTime)BTime.MIDNIGHT);
            end = start.next(first).subtract(BRelTime.make((long)1L));
        } else if (rollup.equals("monthly")) {
            start = BBqlTime.startofmonth((BObject)tstamp);
            end = BBqlTime.endofmonth((BObject)tstamp);
        } else if (rollup.equals("yearly")) {
            start = BBqlTime.startofyear((BObject)tstamp);
            end = BBqlTime.endofyear((BObject)tstamp);
        }
        return new BAbsTimeRange(start, end);
    }

    public BRelTime commit() {
        if (this.currentState == this.checkState) {
            long diff = this.range.getEndTime().getMillis() - this.startOf.getMillis();
            this.lastElapsed = BRelTime.make((long)(this.elapsed.getMillis() + diff));
            System.out.println("commit startOf=" + this.startOf + " | end=" + this.range.getEndTime() + " | value=" + this.currentState + " | elapsed=" + this.elapsed + " | lastElapsed=" + this.lastElapsed);
        }
        return this.lastElapsed;
    }
}

