/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.energy;

import com.vykon.vykonPro.enums.BOssStopCalcModeEnum;
import java.text.DecimalFormat;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOptStartStop
extends BComponent {
    public static final Property stopCalcMode = BOptStartStop.newProperty((int)10, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BOssStopCalcModeEnum.TYPE)), (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BOssStopCalcModeEnum.TYPE)));
    public static final Property parameterResetTime = BOptStartStop.newProperty((int)10, (BValue)BAbsTime.NULL, null);
    public static final Property startEnable = BOptStartStop.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    public static final Property stopEnable = BOptStartStop.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    public static final Property scheduleStatus = BOptStartStop.newProperty((int)10, (BValue)new BStatusBoolean(false), null);
    public static final Property nextEventTime = BOptStartStop.newProperty((int)10, (BValue)BAbsTime.NULL, null);
    public static final Property nextEventValue = BOptStartStop.newProperty((int)10, (BValue)new BStatusBoolean(false), null);
    public static final Property outsideTemp = BOptStartStop.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property spaceTemp = BOptStartStop.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property startTimeCommand = BOptStartStop.newProperty((int)75, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property stopTimeCommand = BOptStartStop.newProperty((int)75, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property message = BOptStartStop.newProperty((int)11, (BValue)new BStatusString(""), null);
    public static final Property upperComfortLimit = BOptStartStop.newProperty((int)0, (float)77.0f, null);
    public static final Property lowerComfortLimit = BOptStartStop.newProperty((int)0, (float)68.0f, null);
    public static final Property comfortDeadband = BOptStartStop.newProperty((int)0, (float)2.0f, null);
    public static final Property dynamicParameterAdjust = BOptStartStop.newProperty((int)0, (boolean)true, null);
    public static final Property oldParameterMultiplier = BOptStartStop.newProperty((int)0, (int)2, null);
    public static final Property earliestStopTime = BOptStartStop.newProperty((int)0, (BValue)BTime.make((int)16, (int)0, (int)0), null);
    public static final Property startLimitMode = BOptStartStop.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"use hours", (String)"use time"));
    public static final Property earliestStartTime = BOptStartStop.newProperty((int)0, (BValue)BTime.make((int)2, (int)0, (int)0), null);
    public static final Property maxEarliestStartHours = BOptStartStop.newProperty((int)0, (BValue)BRelTime.makeHours((int)2), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)false), (String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Property drifttimePerDegreeCooling = BOptStartStop.newProperty((int)0, (float)10.0f, null);
    public static final Property drifttimePerDegreeHeating = BOptStartStop.newProperty((int)0, (float)10.0f, null);
    public static final Property runtimePerDegreeCooling = BOptStartStop.newProperty((int)0, (float)10.0f, null);
    public static final Property runtimePerDegreeHeating = BOptStartStop.newProperty((int)0, (float)10.0f, null);
    public static final Property lastStartTime = BOptStartStop.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property lastStopTime = BOptStartStop.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property outsideTempAtBeginning = BOptStartStop.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property spaceTempAtBeginning = BOptStartStop.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property calculatedCommandTime = BOptStartStop.newProperty((int)71, (BValue)BTime.DEFAULT, null);
    public static final Property calculatedStartTime = BOptStartStop.newProperty((int)67, (BValue)BTime.DEFAULT, null);
    public static final Property calculatedStopTime = BOptStartStop.newProperty((int)67, (BValue)BTime.DEFAULT, null);
    public static final Property comfortAlarm = BOptStartStop.newProperty((int)67, (BValue)new BStatusBoolean(false), (BFacets)BFacets.makeBoolean((String)"alarm", (String)"normal"));
    public static final Property programMode = BOptStartStop.newProperty((int)71, (int)0, null);
    public static final Property mode = BOptStartStop.newProperty((int)67, (BValue)new BStatusString(""), null);
    public static final Action startTimeTrigger = BOptStartStop.newAction((int)4, null);
    public static final Action stopTimeTrigger = BOptStartStop.newAction((int)4, null);
    public static final Action calculate = BOptStartStop.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BOptStartStop.class);
    private static final BIcon icon = BIcon.std((String)"schedule.png");
    boolean controlModeAtBeginning;
    boolean startDone;
    boolean analysisComplete = false;
    float observedMinutesPerDegree = 0.0f;
    float spaceTempChange = 0.0f;
    int leadTime = 0;
    int optimizedRuntimeMinutes = 0;
    int lastProgramMode = 0;
    BAbsTime now = BAbsTime.NULL;
    BAbsTime lastResetTime = BAbsTime.NULL;
    int lastMinute = 0;
    int lastStartDay = Clock.time().getDayOfYear();
    private static boolean ACTIVE = true;
    private static boolean INACTIVE = false;
    private static boolean START = true;
    private static boolean STOP = false;
    private static boolean DISABLED = false;
    private static boolean ENABLED = true;
    private static boolean HEATING = false;
    private static long TIME_00_01 = 60000L;
    private static int NO_CALCULATION = 0;
    private static int START_CALCULATION = 1;
    private static int START_IN_PROCESS = 2;
    private static int STOP_CALCULATION = 3;
    private static int STOP_IN_PROCESS = 4;
    Clock.Ticket ticket = null;

    public BEnum getStopCalcMode() {
        return (BEnum)this.get(stopCalcMode);
    }

    public void setStopCalcMode(BEnum v) {
        this.set(stopCalcMode, (BValue)v, null);
    }

    public BAbsTime getParameterResetTime() {
        return (BAbsTime)this.get(parameterResetTime);
    }

    public void setParameterResetTime(BAbsTime v) {
        this.set(parameterResetTime, (BValue)v, null);
    }

    public BStatusBoolean getStartEnable() {
        return (BStatusBoolean)this.get(startEnable);
    }

    public void setStartEnable(BStatusBoolean v) {
        this.set(startEnable, (BValue)v, null);
    }

    public BStatusBoolean getStopEnable() {
        return (BStatusBoolean)this.get(stopEnable);
    }

    public void setStopEnable(BStatusBoolean v) {
        this.set(stopEnable, (BValue)v, null);
    }

    public BStatusBoolean getScheduleStatus() {
        return (BStatusBoolean)this.get(scheduleStatus);
    }

    public void setScheduleStatus(BStatusBoolean v) {
        this.set(scheduleStatus, (BValue)v, null);
    }

    public BAbsTime getNextEventTime() {
        return (BAbsTime)this.get(nextEventTime);
    }

    public void setNextEventTime(BAbsTime v) {
        this.set(nextEventTime, (BValue)v, null);
    }

    public BStatusBoolean getNextEventValue() {
        return (BStatusBoolean)this.get(nextEventValue);
    }

    public void setNextEventValue(BStatusBoolean v) {
        this.set(nextEventValue, (BValue)v, null);
    }

    public BStatusNumeric getOutsideTemp() {
        return (BStatusNumeric)this.get(outsideTemp);
    }

    public void setOutsideTemp(BStatusNumeric v) {
        this.set(outsideTemp, (BValue)v, null);
    }

    public BStatusNumeric getSpaceTemp() {
        return (BStatusNumeric)this.get(spaceTemp);
    }

    public void setSpaceTemp(BStatusNumeric v) {
        this.set(spaceTemp, (BValue)v, null);
    }

    public BStatusBoolean getStartTimeCommand() {
        return (BStatusBoolean)this.get(startTimeCommand);
    }

    public void setStartTimeCommand(BStatusBoolean v) {
        this.set(startTimeCommand, (BValue)v, null);
    }

    public BStatusBoolean getStopTimeCommand() {
        return (BStatusBoolean)this.get(stopTimeCommand);
    }

    public void setStopTimeCommand(BStatusBoolean v) {
        this.set(stopTimeCommand, (BValue)v, null);
    }

    public BStatusString getMessage() {
        return (BStatusString)this.get(message);
    }

    public void setMessage(BStatusString v) {
        this.set(message, (BValue)v, null);
    }

    public float getUpperComfortLimit() {
        return this.getFloat(upperComfortLimit);
    }

    public void setUpperComfortLimit(float v) {
        this.setFloat(upperComfortLimit, v, null);
    }

    public float getLowerComfortLimit() {
        return this.getFloat(lowerComfortLimit);
    }

    public void setLowerComfortLimit(float v) {
        this.setFloat(lowerComfortLimit, v, null);
    }

    public float getComfortDeadband() {
        return this.getFloat(comfortDeadband);
    }

    public void setComfortDeadband(float v) {
        this.setFloat(comfortDeadband, v, null);
    }

    public boolean getDynamicParameterAdjust() {
        return this.getBoolean(dynamicParameterAdjust);
    }

    public void setDynamicParameterAdjust(boolean v) {
        this.setBoolean(dynamicParameterAdjust, v, null);
    }

    public int getOldParameterMultiplier() {
        return this.getInt(oldParameterMultiplier);
    }

    public void setOldParameterMultiplier(int v) {
        this.setInt(oldParameterMultiplier, v, null);
    }

    public BTime getEarliestStopTime() {
        return (BTime)this.get(earliestStopTime);
    }

    public void setEarliestStopTime(BTime v) {
        this.set(earliestStopTime, (BValue)v, null);
    }

    public boolean getStartLimitMode() {
        return this.getBoolean(startLimitMode);
    }

    public void setStartLimitMode(boolean v) {
        this.setBoolean(startLimitMode, v, null);
    }

    public BTime getEarliestStartTime() {
        return (BTime)this.get(earliestStartTime);
    }

    public void setEarliestStartTime(BTime v) {
        this.set(earliestStartTime, (BValue)v, null);
    }

    public BRelTime getMaxEarliestStartHours() {
        return (BRelTime)this.get(maxEarliestStartHours);
    }

    public void setMaxEarliestStartHours(BRelTime v) {
        this.set(maxEarliestStartHours, (BValue)v, null);
    }

    public float getDrifttimePerDegreeCooling() {
        return this.getFloat(drifttimePerDegreeCooling);
    }

    public void setDrifttimePerDegreeCooling(float v) {
        this.setFloat(drifttimePerDegreeCooling, v, null);
    }

    public float getDrifttimePerDegreeHeating() {
        return this.getFloat(drifttimePerDegreeHeating);
    }

    public void setDrifttimePerDegreeHeating(float v) {
        this.setFloat(drifttimePerDegreeHeating, v, null);
    }

    public float getRuntimePerDegreeCooling() {
        return this.getFloat(runtimePerDegreeCooling);
    }

    public void setRuntimePerDegreeCooling(float v) {
        this.setFloat(runtimePerDegreeCooling, v, null);
    }

    public float getRuntimePerDegreeHeating() {
        return this.getFloat(runtimePerDegreeHeating);
    }

    public void setRuntimePerDegreeHeating(float v) {
        this.setFloat(runtimePerDegreeHeating, v, null);
    }

    public BAbsTime getLastStartTime() {
        return (BAbsTime)this.get(lastStartTime);
    }

    public void setLastStartTime(BAbsTime v) {
        this.set(lastStartTime, (BValue)v, null);
    }

    public BAbsTime getLastStopTime() {
        return (BAbsTime)this.get(lastStopTime);
    }

    public void setLastStopTime(BAbsTime v) {
        this.set(lastStopTime, (BValue)v, null);
    }

    public BStatusNumeric getOutsideTempAtBeginning() {
        return (BStatusNumeric)this.get(outsideTempAtBeginning);
    }

    public void setOutsideTempAtBeginning(BStatusNumeric v) {
        this.set(outsideTempAtBeginning, (BValue)v, null);
    }

    public BStatusNumeric getSpaceTempAtBeginning() {
        return (BStatusNumeric)this.get(spaceTempAtBeginning);
    }

    public void setSpaceTempAtBeginning(BStatusNumeric v) {
        this.set(spaceTempAtBeginning, (BValue)v, null);
    }

    public BTime getCalculatedCommandTime() {
        return (BTime)this.get(calculatedCommandTime);
    }

    public void setCalculatedCommandTime(BTime v) {
        this.set(calculatedCommandTime, (BValue)v, null);
    }

    public BTime getCalculatedStartTime() {
        return (BTime)this.get(calculatedStartTime);
    }

    public void setCalculatedStartTime(BTime v) {
        this.set(calculatedStartTime, (BValue)v, null);
    }

    public BTime getCalculatedStopTime() {
        return (BTime)this.get(calculatedStopTime);
    }

    public void setCalculatedStopTime(BTime v) {
        this.set(calculatedStopTime, (BValue)v, null);
    }

    public BStatusBoolean getComfortAlarm() {
        return (BStatusBoolean)this.get(comfortAlarm);
    }

    public void setComfortAlarm(BStatusBoolean v) {
        this.set(comfortAlarm, (BValue)v, null);
    }

    public int getProgramMode() {
        return this.getInt(programMode);
    }

    public void setProgramMode(int v) {
        this.setInt(programMode, v, null);
    }

    public BStatusString getMode() {
        return (BStatusString)this.get(mode);
    }

    public void setMode(BStatusString v) {
        this.set(mode, (BValue)v, null);
    }

    public void startTimeTrigger() {
        this.invoke(startTimeTrigger, null, null);
    }

    public void stopTimeTrigger() {
        this.invoke(stopTimeTrigger, null, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.initClockTicket();
        super.started();
        if (!Sys.atSteadyState()) {
            return;
        }
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void clockChanged(BRelTime value) {
        this.initClockTicket();
        if (this.getProgramMode() == START_IN_PROCESS) {
            this.setProgramMode(START_CALCULATION);
        } else if (this.getProgramMode() == STOP_IN_PROCESS) {
            this.setProgramMode(STOP_CALCULATION);
        }
    }

    private void initClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BAbsTime tom = Clock.nextTopOfMinute().add(BRelTime.makeSeconds((int)15));
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)tom, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(drifttimePerDegreeCooling) || property.equals(drifttimePerDegreeHeating) || property.equals(runtimePerDegreeCooling) || property.equals(runtimePerDegreeHeating)) {
            this.setParameterResetTime(Clock.time());
        }
        if (property.equals(scheduleStatus) || property.equals(nextEventTime) || property.equals(nextEventValue)) {
            if (this.getProgramMode() == START_IN_PROCESS) {
                this.setProgramMode(START_CALCULATION);
            } else if (this.getProgramMode() == STOP_IN_PROCESS) {
                this.setProgramMode(STOP_CALCULATION);
            }
        }
        if (property.equals(programMode)) {
            switch (this.getProgramMode()) {
                case 0: {
                    this.getMode().setValue("No Calculation");
                    break;
                }
                case 1: {
                    this.getMode().setValue("Start Calculation");
                    break;
                }
                case 2: {
                    this.getMode().setValue("Start In Process");
                    break;
                }
                case 3: {
                    this.getMode().setValue("Stop Calculation");
                    break;
                }
                case 4: {
                    this.getMode().setValue("Stop In Process");
                }
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        return super.getSlotFacets(slot);
    }

    public void doStopTimeTrigger() {
    }

    public void doStartTimeTrigger() {
    }

    private String formatNumeric(double value, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(value);
    }

    public void doCalculate() {
        this.now = Clock.time();
        if (this.getStartEnable().getValue() == DISABLED || this.now.getDayOfYear() != this.lastStartDay) {
            this.startDone = false;
        }
        this.performStartStopAnalysis();
        this.performStartStopCalculation();
        this.performStartStopControl();
        this.updateControlOutput();
        this.lastProgramMode = this.getProgramMode();
    }

    private void performStartStopCalculation() {
        if (this.getNextEventTime().getDayOfYear() != this.now.getDayOfYear()) {
            this.setProgramMode(NO_CALCULATION);
            return;
        }
        if (this.getNextEventValue().getValue() == ACTIVE) {
            this.performStartCalculation();
        } else {
            this.performStopCalculation();
        }
    }

    private void performStartCalculation() {
        if (this.getStartEnable().getValue() != ENABLED || this.getScheduleStatus().getValue() == ACTIVE) {
            this.setProgramMode(NO_CALCULATION);
            return;
        }
        if (!this.startDone && this.getSpaceTemp().getStatus().isValid()) {
            if (this.getProgramMode() != START_IN_PROCESS) {
                this.setProgramMode(START_CALCULATION);
                this.leadTime = this.getSpaceTemp().getValue() > (double)this.getUpperComfortLimit() ? 1 + (int)((this.getSpaceTemp().getValue() - (double)this.getUpperComfortLimit()) * (double)this.getRuntimePerDegreeCooling()) : (this.getSpaceTemp().getValue() < (double)this.getLowerComfortLimit() ? 1 + (int)(((double)this.getLowerComfortLimit() - this.getSpaceTemp().getValue()) * (double)this.getRuntimePerDegreeHeating()) : 0);
            }
        } else {
            this.leadTime = 0;
        }
        this.leadTime = this.leadTime < 0 ? 0 : this.leadTime;
    }

    private void performStopCalculation() {
        int heatLeadTime = 0;
        int coolLeadTime = 0;
        this.leadTime = 0;
        if (this.getStopEnable().getValue() != ENABLED || this.getScheduleStatus().getValue() == INACTIVE) {
            this.setProgramMode(NO_CALCULATION);
            return;
        }
        if (!this.getSpaceTemp().getStatus().isValid() || this.getProgramMode() == STOP_IN_PROCESS) {
            return;
        }
        this.setProgramMode(STOP_CALCULATION);
        if (this.getSpaceTemp().getValue() > (double)this.getLowerComfortLimit()) {
            heatLeadTime = (int)((this.getSpaceTemp().getValue() - (double)this.getLowerComfortLimit()) * (double)this.getDrifttimePerDegreeHeating());
        }
        if (this.getSpaceTemp().getValue() < (double)this.getUpperComfortLimit()) {
            coolLeadTime = (int)(((double)this.getUpperComfortLimit() - this.getSpaceTemp().getValue()) * (double)this.getDrifttimePerDegreeCooling());
        }
        int stopMode = this.getStopCalcMode().getEnum().getOrdinal();
        switch (stopMode) {
            case 0: {
                this.leadTime = Math.min(heatLeadTime, coolLeadTime);
                if (this.leadTime == heatLeadTime) {
                    this.controlModeAtBeginning = HEATING;
                    break;
                }
                this.controlModeAtBeginning = !HEATING;
                break;
            }
            case 2: {
                this.leadTime = heatLeadTime;
                this.controlModeAtBeginning = HEATING;
                break;
            }
            case 1: {
                this.leadTime = coolLeadTime;
                this.controlModeAtBeginning = !HEATING;
            }
        }
        this.leadTime = this.leadTime < 0 ? 0 : this.leadTime;
    }

    private void performStartStopControl() {
        BTime currentTime;
        long calcCmdTime;
        if (this.getProgramMode() != START_CALCULATION && this.getProgramMode() != STOP_CALCULATION) {
            if (this.getNextEventValue().getValue()) {
                this.setCalculatedCommandTime(this.getCalculatedStartTime());
            } else {
                this.setCalculatedCommandTime(this.getCalculatedStopTime());
            }
            return;
        }
        if (this.getProgramMode() == START_CALCULATION) {
            calcCmdTime = this.getNextEventTime().getTimeOfDayMillis() - (long)this.leadTime * TIME_00_01;
            if (this.getStartLimitMode()) {
                long startLimit = this.getNextEventTime().getTimeOfDayMillis() - this.getMaxEarliestStartHours().getMillis();
                if (startLimit < 0L) {
                    startLimit = 0L;
                }
                if (calcCmdTime <= startLimit) {
                    this.setCalculatedStartTime(BTime.make((BRelTime)BRelTime.make((long)startLimit)));
                    this.setCalculatedCommandTime(this.getCalculatedStartTime());
                } else {
                    this.setCalculatedStartTime(BTime.make((BRelTime)BRelTime.make((long)(this.getNextEventTime().getTimeOfDayMillis() - (long)this.leadTime * TIME_00_01))));
                    this.setCalculatedCommandTime(this.getCalculatedStartTime());
                }
            } else if (calcCmdTime < this.getEarliestStartTime().getTimeOfDayMillis()) {
                this.setCalculatedStartTime(this.getEarliestStartTime());
                this.setCalculatedCommandTime(this.getCalculatedStartTime());
            } else {
                this.setCalculatedStartTime(BTime.make((BRelTime)BRelTime.make((long)(this.getNextEventTime().getTimeOfDayMillis() - (long)this.leadTime * TIME_00_01))));
                this.setCalculatedCommandTime(this.getCalculatedStartTime());
            }
        }
        if (this.getProgramMode() == STOP_CALCULATION) {
            calcCmdTime = this.getNextEventTime().getTimeOfDayMillis() - (long)this.leadTime * TIME_00_01;
            if (calcCmdTime < this.getEarliestStopTime().getTimeOfDayMillis()) {
                this.setCalculatedStopTime(this.getEarliestStopTime());
                this.setCalculatedCommandTime(this.getCalculatedStopTime());
            } else {
                this.setCalculatedStopTime(BTime.make((BRelTime)BRelTime.make((long)(this.getNextEventTime().getTimeOfDayMillis() - (long)this.leadTime * TIME_00_01))));
                this.setCalculatedCommandTime(this.getCalculatedStopTime());
            }
        }
        if ((currentTime = BTime.make((BAbsTime)Clock.time())).isAfter(this.getCalculatedCommandTime()) || currentTime.isAfter(BTime.make((BAbsTime)this.getNextEventTime()))) {
            if (this.getProgramMode() == START_CALCULATION) {
                this.startDone = true;
                this.setProgramMode(START_IN_PROCESS);
                this.setLastStartTime(Clock.time());
                this.getSpaceTempAtBeginning().setValue(this.getSpaceTemp().getValue());
                this.getOutsideTempAtBeginning().setValue(this.getOutsideTemp().getValue());
                this.startTimeTrigger();
                this.getMessage().setValue("Optimized start for " + this.getNextEventTime() + " schedule time.  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
            } else {
                this.setProgramMode(STOP_IN_PROCESS);
                this.setLastStopTime(Clock.time());
                this.getSpaceTempAtBeginning().setValue(this.getSpaceTemp().getValue());
                this.getOutsideTempAtBeginning().setValue(this.getOutsideTemp().getValue());
                this.stopTimeTrigger();
                this.getMessage().setValue("Optimized stop for " + this.getNextEventTime() + " schedule time.  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
            }
        }
    }

    private void updateControlOutput() {
        if (this.getProgramMode() == START_IN_PROCESS) {
            this.getStartTimeCommand().setValue(START);
            this.getStartTimeCommand().setStatusNull(false);
            this.getStopTimeCommand().setValue(STOP);
            this.getStopTimeCommand().setStatusNull(true);
        } else if (this.getProgramMode() == STOP_IN_PROCESS) {
            this.getStopTimeCommand().setValue(STOP);
            this.getStopTimeCommand().setStatusNull(false);
            this.getStartTimeCommand().setValue(STOP);
            this.getStartTimeCommand().setStatusNull(true);
        } else {
            this.getStopTimeCommand().setValue(STOP);
            this.getStopTimeCommand().setStatusNull(true);
            this.getStartTimeCommand().setValue(STOP);
            this.getStartTimeCommand().setStatusNull(true);
            this.analysisComplete = false;
        }
    }

    private void performStartStopAnalysis() {
        if (!this.getDynamicParameterAdjust() || this.analysisComplete || !this.getSpaceTemp().getStatus().isValid()) {
            return;
        }
        if (this.lastProgramMode == START_IN_PROCESS) {
            this.handleStartAnalysis();
        } else if (this.lastProgramMode == STOP_IN_PROCESS) {
            this.handleStopAnalysis();
        }
    }

    private void handleStartAnalysis() {
        if (this.isCoolingAnalysis()) {
            if (this.getSpaceTemp().getValue() < this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() <= (double)this.getUpperComfortLimit() || this.getScheduleStatus().getValue() == ACTIVE)) {
                this.spaceTempChange = (float)(this.getSpaceTempAtBeginning().getValue() - this.getSpaceTemp().getValue());
                this.optimizedRuntimeMinutes = this.getLastStartTime().delta(this.now).getMinutes();
                if (this.optimizedRuntimeMinutes < 0) {
                    return;
                }
                this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
                this.setRuntimePerDegreeCooling((this.getRuntimePerDegreeCooling() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
                this.analysisComplete = true;
                this.getMessage().setValue("Optimized start analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
            }
        } else if (this.getSpaceTemp().getValue() > this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() >= (double)this.getLowerComfortLimit() || this.getScheduleStatus().getValue() == ACTIVE)) {
            this.spaceTempChange = (float)(this.getSpaceTemp().getValue() - this.getSpaceTempAtBeginning().getValue());
            this.optimizedRuntimeMinutes = this.getLastStartTime().delta(this.now).getMinutes();
            if (this.optimizedRuntimeMinutes < 0) {
                return;
            }
            this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
            this.setRuntimePerDegreeHeating((this.getRuntimePerDegreeHeating() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
            this.analysisComplete = true;
            this.getMessage().setValue("Optimized start analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
        }
        float adjUpperLimit = this.getUpperComfortLimit() + this.getComfortDeadband();
        float adjLowerLimit = this.getLowerComfortLimit() - this.getComfortDeadband();
        if (this.getSpaceTemp().getValue() < (double)adjLowerLimit || this.getSpaceTemp().getValue() > (double)adjUpperLimit) {
            this.getComfortAlarm().setValue(true);
        } else {
            this.getComfortAlarm().setValue(false);
        }
    }

    private boolean isCoolingAnalysis() {
        return this.getSpaceTempAtBeginning().getValue() > (double)this.getUpperComfortLimit();
    }

    private void handleStopAnalysis() {
        if (this.controlModeAtBeginning == HEATING) {
            if (this.getSpaceTemp().getValue() < this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() <= (double)this.getLowerComfortLimit() || this.getScheduleStatus().getValue() == INACTIVE)) {
                this.spaceTempChange = (float)this.getSpaceTempAtBeginning().getValue() - (float)this.getSpaceTemp().getValue();
                this.optimizedRuntimeMinutes = this.getLastStopTime().delta(Clock.time()).getMinutes();
                if (this.optimizedRuntimeMinutes < 0) {
                    return;
                }
                this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
                this.setDrifttimePerDegreeHeating((this.getDrifttimePerDegreeHeating() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
                this.getMessage().setValue("Optimized stop analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
                this.analysisComplete = true;
            }
        } else if (this.getSpaceTemp().getValue() > this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() >= (double)this.getUpperComfortLimit() || this.getScheduleStatus().getValue() == INACTIVE)) {
            this.spaceTempChange = (float)this.getSpaceTemp().getValue() - (float)this.getSpaceTempAtBeginning().getValue();
            this.optimizedRuntimeMinutes = this.getLastStopTime().delta(this.now).getMinutes();
            if (this.optimizedRuntimeMinutes < 0) {
                return;
            }
            this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
            this.setDrifttimePerDegreeCooling((this.getDrifttimePerDegreeCooling() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
            this.getMessage().setValue("Optimized stop analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
            this.analysisComplete = true;
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

