/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.vykon.vykonPro.enums.BDateModeEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMinTracker
extends BComponent {
    public static final Property enabled = BMinTracker.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property facets = BMinTracker.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property dateMode = BMinTracker.newProperty((int)256, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BDateModeEnum.TYPE)), null);
    public static final Property billingCycleStartDay = BMinTracker.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)28));
    public static final Property in = BMinTracker.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property lastReset = BMinTracker.newProperty((int)9, (BValue)BAbsTime.NULL, null);
    public static final Property januaryMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property januaryTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property februaryMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property februaryTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property marchMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property marchTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property aprilMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property aprilTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property mayMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property mayTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property juneMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property juneTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property julyMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property julyTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property augustMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property augustTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property septemberMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property septemberTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property octoberMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property octoberTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property novemberMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property novemberTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property decemberMin = BMinTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property decemberTimestamp = BMinTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Action calculate = BMinTracker.newAction((int)4, null);
    public static final Action ticketExpired = BMinTracker.newAction((int)4, null);
    public static final Action resetMins = BMinTracker.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BMinTracker.class);
    BAbsTime now = null;
    Clock.Ticket ticket = null;
    private static final BIcon icon = BIcon.std((String)"arrowDown.png");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BEnum getDateMode() {
        return (BEnum)this.get(dateMode);
    }

    public void setDateMode(BEnum v) {
        this.set(dateMode, (BValue)v, null);
    }

    public int getBillingCycleStartDay() {
        return this.getInt(billingCycleStartDay);
    }

    public void setBillingCycleStartDay(int v) {
        this.setInt(billingCycleStartDay, v, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public BAbsTime getLastReset() {
        return (BAbsTime)this.get(lastReset);
    }

    public void setLastReset(BAbsTime v) {
        this.set(lastReset, (BValue)v, null);
    }

    public BStatusNumeric getJanuaryMin() {
        return (BStatusNumeric)this.get(januaryMin);
    }

    public void setJanuaryMin(BStatusNumeric v) {
        this.set(januaryMin, (BValue)v, null);
    }

    public BAbsTime getJanuaryTimestamp() {
        return (BAbsTime)this.get(januaryTimestamp);
    }

    public void setJanuaryTimestamp(BAbsTime v) {
        this.set(januaryTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getFebruaryMin() {
        return (BStatusNumeric)this.get(februaryMin);
    }

    public void setFebruaryMin(BStatusNumeric v) {
        this.set(februaryMin, (BValue)v, null);
    }

    public BAbsTime getFebruaryTimestamp() {
        return (BAbsTime)this.get(februaryTimestamp);
    }

    public void setFebruaryTimestamp(BAbsTime v) {
        this.set(februaryTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getMarchMin() {
        return (BStatusNumeric)this.get(marchMin);
    }

    public void setMarchMin(BStatusNumeric v) {
        this.set(marchMin, (BValue)v, null);
    }

    public BAbsTime getMarchTimestamp() {
        return (BAbsTime)this.get(marchTimestamp);
    }

    public void setMarchTimestamp(BAbsTime v) {
        this.set(marchTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getAprilMin() {
        return (BStatusNumeric)this.get(aprilMin);
    }

    public void setAprilMin(BStatusNumeric v) {
        this.set(aprilMin, (BValue)v, null);
    }

    public BAbsTime getAprilTimestamp() {
        return (BAbsTime)this.get(aprilTimestamp);
    }

    public void setAprilTimestamp(BAbsTime v) {
        this.set(aprilTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getMayMin() {
        return (BStatusNumeric)this.get(mayMin);
    }

    public void setMayMin(BStatusNumeric v) {
        this.set(mayMin, (BValue)v, null);
    }

    public BAbsTime getMayTimestamp() {
        return (BAbsTime)this.get(mayTimestamp);
    }

    public void setMayTimestamp(BAbsTime v) {
        this.set(mayTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getJuneMin() {
        return (BStatusNumeric)this.get(juneMin);
    }

    public void setJuneMin(BStatusNumeric v) {
        this.set(juneMin, (BValue)v, null);
    }

    public BAbsTime getJuneTimestamp() {
        return (BAbsTime)this.get(juneTimestamp);
    }

    public void setJuneTimestamp(BAbsTime v) {
        this.set(juneTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getJulyMin() {
        return (BStatusNumeric)this.get(julyMin);
    }

    public void setJulyMin(BStatusNumeric v) {
        this.set(julyMin, (BValue)v, null);
    }

    public BAbsTime getJulyTimestamp() {
        return (BAbsTime)this.get(julyTimestamp);
    }

    public void setJulyTimestamp(BAbsTime v) {
        this.set(julyTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getAugustMin() {
        return (BStatusNumeric)this.get(augustMin);
    }

    public void setAugustMin(BStatusNumeric v) {
        this.set(augustMin, (BValue)v, null);
    }

    public BAbsTime getAugustTimestamp() {
        return (BAbsTime)this.get(augustTimestamp);
    }

    public void setAugustTimestamp(BAbsTime v) {
        this.set(augustTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getSeptemberMin() {
        return (BStatusNumeric)this.get(septemberMin);
    }

    public void setSeptemberMin(BStatusNumeric v) {
        this.set(septemberMin, (BValue)v, null);
    }

    public BAbsTime getSeptemberTimestamp() {
        return (BAbsTime)this.get(septemberTimestamp);
    }

    public void setSeptemberTimestamp(BAbsTime v) {
        this.set(septemberTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getOctoberMin() {
        return (BStatusNumeric)this.get(octoberMin);
    }

    public void setOctoberMin(BStatusNumeric v) {
        this.set(octoberMin, (BValue)v, null);
    }

    public BAbsTime getOctoberTimestamp() {
        return (BAbsTime)this.get(octoberTimestamp);
    }

    public void setOctoberTimestamp(BAbsTime v) {
        this.set(octoberTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getNovemberMin() {
        return (BStatusNumeric)this.get(novemberMin);
    }

    public void setNovemberMin(BStatusNumeric v) {
        this.set(novemberMin, (BValue)v, null);
    }

    public BAbsTime getNovemberTimestamp() {
        return (BAbsTime)this.get(novemberTimestamp);
    }

    public void setNovemberTimestamp(BAbsTime v) {
        this.set(novemberTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getDecemberMin() {
        return (BStatusNumeric)this.get(decemberMin);
    }

    public void setDecemberMin(BStatusNumeric v) {
        this.set(decemberMin, (BValue)v, null);
    }

    public BAbsTime getDecemberTimestamp() {
        return (BAbsTime)this.get(decemberTimestamp);
    }

    public void setDecemberTimestamp(BAbsTime v) {
        this.set(decemberTimestamp, (BValue)v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void ticketExpired() {
        this.invoke(ticketExpired, null, null);
    }

    public void resetMins() {
        this.invoke(resetMins, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!this.getEnabled()) {
            return;
        }
        this.calculate();
        this.initClockTicket();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public void atSteadyState() {
        this.calculate();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)in) || slot.getName().endsWith("Min")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void clockChanged(BRelTime value) {
        if (this.getEnabled()) {
            this.initClockTicket();
        }
    }

    private void initClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.now = Clock.time();
        BMonth currentMonth = this.now.getMonth();
        int currentYear = this.now.getYear();
        int currentDay = this.now.getDay();
        BAbsTime firstOfMonth = null;
        BAbsTime nextMonth = null;
        if (this.getDateMode().getOrdinal() == 0) {
            firstOfMonth = BAbsTime.make((int)currentYear, (BMonth)currentMonth, (int)1, (int)0, (int)0, (int)15, (int)0);
            nextMonth = firstOfMonth.nextMonth();
        } else if (currentDay < this.getBillingCycleStartDay()) {
            nextMonth = BAbsTime.make((int)currentYear, (BMonth)currentMonth, (int)this.getBillingCycleStartDay(), (int)0, (int)0, (int)15, (int)0);
        } else {
            firstOfMonth = BAbsTime.make((int)currentYear, (BMonth)currentMonth, (int)this.getBillingCycleStartDay(), (int)0, (int)0, (int)15, (int)0);
            nextMonth = firstOfMonth.nextMonth();
        }
        this.ticket = Clock.schedule((BComponent)this, (BAbsTime)nextMonth, (Action)ticketExpired, null);
    }

    public void doTicketExpired() {
        this.doCalculate();
        this.initClockTicket();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (prop.equals(in) && this.getEnabled()) {
            if (this.getIn().getStatus().isValid()) {
                this.calculate();
            }
        } else if (prop.equals(enabled)) {
            if (this.getEnabled()) {
                this.initClockTicket();
                this.doCalculate();
            } else if (this.ticket != null) {
                this.ticket.cancel();
            }
        } else if (prop.equals(dateMode)) {
            this.initClockTicket();
        } else if (prop.equals(billingCycleStartDay) && this.getDateMode().getOrdinal() == 1) {
            this.initClockTicket();
        }
    }

    public void doCalculate() {
        this.now = Clock.time();
        int month = this.now.getMonth().getMonthOfYear();
        int year = this.now.getYear();
        int day = this.now.getDay();
        double inValue = this.getIn().getValue();
        if (this.getDateMode().getOrdinal() == 0) {
            this.checkMin(inValue, month, year);
        } else {
            int billDay = this.getBillingCycleStartDay();
            if (day < billDay) {
                BAbsTime prevMonth = this.now.prevMonth();
                this.checkMin(inValue, prevMonth.getMonth().getMonthOfYear(), prevMonth.getYear());
            } else {
                this.checkMin(inValue, month, year);
            }
        }
    }

    public void doResetMins() {
        this.now = Clock.time();
        this.setLastReset(this.now);
        this.getJanuaryMin().setValue(Double.POSITIVE_INFINITY);
        this.setJanuaryTimestamp(BAbsTime.NULL);
        this.getFebruaryMin().setValue(Double.POSITIVE_INFINITY);
        this.setFebruaryTimestamp(BAbsTime.NULL);
        this.getMarchMin().setValue(Double.POSITIVE_INFINITY);
        this.setMarchTimestamp(BAbsTime.NULL);
        this.getAprilMin().setValue(Double.POSITIVE_INFINITY);
        this.setAprilTimestamp(BAbsTime.NULL);
        this.getMayMin().setValue(Double.POSITIVE_INFINITY);
        this.setMayTimestamp(BAbsTime.NULL);
        this.getJuneMin().setValue(Double.POSITIVE_INFINITY);
        this.setJuneTimestamp(BAbsTime.NULL);
        this.getJulyMin().setValue(Double.POSITIVE_INFINITY);
        this.setJulyTimestamp(BAbsTime.NULL);
        this.getAugustMin().setValue(Double.POSITIVE_INFINITY);
        this.setAugustTimestamp(BAbsTime.NULL);
        this.getSeptemberMin().setValue(Double.POSITIVE_INFINITY);
        this.setSeptemberTimestamp(BAbsTime.NULL);
        this.getOctoberMin().setValue(Double.POSITIVE_INFINITY);
        this.setOctoberTimestamp(BAbsTime.NULL);
        this.getNovemberMin().setValue(Double.POSITIVE_INFINITY);
        this.setNovemberTimestamp(BAbsTime.NULL);
        this.getDecemberMin().setValue(Double.POSITIVE_INFINITY);
        this.setDecemberTimestamp(BAbsTime.NULL);
        this.calculate();
    }

    private void checkMin(double v, int m, int y) {
        switch (m) {
            case 1: {
                if (!(v <= this.getJanuaryMin().getValue()) && this.getJanuaryTimestamp().getYear() == y) break;
                this.getJanuaryMin().setValue(v);
                this.setJanuaryTimestamp(this.now);
                break;
            }
            case 2: {
                if (!(v <= this.getFebruaryMin().getValue()) && this.getFebruaryTimestamp().getYear() == y) break;
                this.getFebruaryMin().setValue(v);
                this.setFebruaryTimestamp(this.now);
                break;
            }
            case 3: {
                if (!(v <= this.getMarchMin().getValue()) && this.getMarchTimestamp().getYear() == y) break;
                this.getMarchMin().setValue(v);
                this.setMarchTimestamp(this.now);
                break;
            }
            case 4: {
                if (!(v <= this.getAprilMin().getValue()) && this.getAprilTimestamp().getYear() == y) break;
                this.getAprilMin().setValue(v);
                this.setAprilTimestamp(this.now);
                break;
            }
            case 5: {
                if (!(v <= this.getMayMin().getValue()) && this.getMayTimestamp().getYear() == y) break;
                this.getMayMin().setValue(v);
                this.setMayTimestamp(this.now);
                break;
            }
            case 6: {
                if (!(v <= this.getJuneMin().getValue()) && this.getJuneTimestamp().getYear() == y) break;
                this.getJuneMin().setValue(v);
                this.setJuneTimestamp(this.now);
                break;
            }
            case 7: {
                if (!(v <= this.getJulyMin().getValue()) && this.getJulyTimestamp().getYear() == y) break;
                this.getJulyMin().setValue(v);
                this.setJulyTimestamp(this.now);
                break;
            }
            case 8: {
                if (!(v <= this.getAugustMin().getValue()) && this.getAugustTimestamp().getYear() == y) break;
                this.getAugustMin().setValue(v);
                this.setAugustTimestamp(this.now);
                break;
            }
            case 9: {
                if (!(v <= this.getSeptemberMin().getValue()) && this.getSeptemberTimestamp().getYear() == y) break;
                this.getSeptemberMin().setValue(v);
                this.setSeptemberTimestamp(this.now);
                break;
            }
            case 10: {
                if (!(v <= this.getOctoberMin().getValue()) && this.getOctoberTimestamp().getYear() == y) break;
                this.getOctoberMin().setValue(v);
                this.setOctoberTimestamp(this.now);
                break;
            }
            case 11: {
                if (!(v <= this.getNovemberMin().getValue()) && this.getNovemberTimestamp().getYear() == y) break;
                this.getNovemberMin().setValue(v);
                this.setNovemberTimestamp(this.now);
                break;
            }
            case 12: {
                if (!(v <= this.getDecemberMin().getValue()) && this.getDecemberTimestamp().getYear() == y) break;
                this.getDecemberMin().setValue(v);
                this.setDecemberTimestamp(this.now);
            }
        }
    }

    public BStatusNumeric[] getMins() {
        BStatusNumeric[] peaks = new BStatusNumeric[]{(BStatusNumeric)this.getJanuaryMin().newCopy(), (BStatusNumeric)this.getFebruaryMin().newCopy(), (BStatusNumeric)this.getMarchMin().newCopy(), (BStatusNumeric)this.getAprilMin().newCopy(), (BStatusNumeric)this.getMayMin().newCopy(), (BStatusNumeric)this.getJuneMin().newCopy(), (BStatusNumeric)this.getJulyMin().newCopy(), (BStatusNumeric)this.getAugustMin().newCopy(), (BStatusNumeric)this.getSeptemberMin().newCopy(), (BStatusNumeric)this.getOctoberMin().newCopy(), (BStatusNumeric)this.getNovemberMin().newCopy(), (BStatusNumeric)this.getDecemberMin().newCopy()};
        return peaks;
    }

    public BAbsTime[] getTimestamps() {
        BAbsTime[] tstamps = new BAbsTime[]{(BAbsTime)this.getJanuaryTimestamp().newCopy(), (BAbsTime)this.getFebruaryTimestamp().newCopy(), (BAbsTime)this.getMarchTimestamp().newCopy(), (BAbsTime)this.getAprilTimestamp().newCopy(), (BAbsTime)this.getMayTimestamp().newCopy(), (BAbsTime)this.getJuneTimestamp().newCopy(), (BAbsTime)this.getJulyTimestamp().newCopy(), (BAbsTime)this.getAugustTimestamp().newCopy(), (BAbsTime)this.getSeptemberTimestamp().newCopy(), (BAbsTime)this.getOctoberTimestamp().newCopy(), (BAbsTime)this.getNovemberTimestamp().newCopy(), (BAbsTime)this.getDecemberTimestamp().newCopy()};
        return tstamps;
    }

    public BIcon getIcon() {
        return icon;
    }
}

